/*
 * Decompiled with CFR 0.152.
 */
package scalus.uplc.eval;

import java.io.Serializable;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.util.control.NonFatal$;
import scalus.builtin.PlatformSpecific;
import scalus.uplc.BuiltinRuntime;
import scalus.uplc.BuiltinsMeaning;
import scalus.uplc.Constant;
import scalus.uplc.DefaultFun;
import scalus.uplc.DefaultUni;
import scalus.uplc.NamedDeBruijn;
import scalus.uplc.Term;
import scalus.uplc.Term$;
import scalus.uplc.Term$Apply$;
import scalus.uplc.Term$Builtin$;
import scalus.uplc.Term$Const$;
import scalus.uplc.Term$Delay$;
import scalus.uplc.Term$Force$;
import scalus.uplc.Term$LamAbs$;
import scalus.uplc.Term$Var$;
import scalus.uplc.TypeScheme;
import scalus.uplc.TypeScheme$All$;
import scalus.uplc.TypeScheme$App$;
import scalus.uplc.TypeScheme$Arrow$;
import scalus.uplc.TypeScheme$TVar$;
import scalus.uplc.TypeScheme$Type$;
import scalus.uplc.eval.BudgetSpender;
import scalus.uplc.eval.BuiltinError;
import scalus.uplc.eval.BuiltinTermArgumentExpectedMachineError;
import scalus.uplc.eval.CekMachineCosts;
import scalus.uplc.eval.CekState;
import scalus.uplc.eval.CekState$Compute$;
import scalus.uplc.eval.CekState$Done$;
import scalus.uplc.eval.CekState$Return$;
import scalus.uplc.eval.CekValue;
import scalus.uplc.eval.CekValue$VBuiltin$;
import scalus.uplc.eval.CekValue$VCon$;
import scalus.uplc.eval.CekValue$VDelay$;
import scalus.uplc.eval.CekValue$VLamAbs$;
import scalus.uplc.eval.Context;
import scalus.uplc.eval.Context$;
import scalus.uplc.eval.Context$FrameApplyArg$;
import scalus.uplc.eval.Context$FrameApplyFun$;
import scalus.uplc.eval.Context$FrameForce$;
import scalus.uplc.eval.CostModel;
import scalus.uplc.eval.CostingFun;
import scalus.uplc.eval.EvaluationFailure;
import scalus.uplc.eval.ExBudget;
import scalus.uplc.eval.ExBudgetCategory;
import scalus.uplc.eval.ExBudgetCategory$;
import scalus.uplc.eval.ExBudgetCategory$BuiltinApp$;
import scalus.uplc.eval.ExBudgetCategory$Step$;
import scalus.uplc.eval.Logger;
import scalus.uplc.eval.MachineParams;
import scalus.uplc.eval.NonFunctionalApplicationMachineError;
import scalus.uplc.eval.NonPolymorphicInstantiationMachineError;
import scalus.uplc.eval.OpenTermEvaluatedMachineError;
import scalus.uplc.eval.StepKind$;
import scalus.uplc.eval.UnexpectedBuiltinTermArgumentMachineError;
import scalus.uplc.eval.UnknownBuiltin;

public class CekMachine
extends BuiltinsMeaning {
    private final MachineParams params;
    private final BudgetSpender budgetSpender;
    private final Logger logger;
    private final ArrayBuffer logs;

    public CekMachine(MachineParams params, BudgetSpender budgetSpender, Logger logger, PlatformSpecific platformSpecific) {
        this.params = params;
        this.budgetSpender = budgetSpender;
        this.logger = logger;
        super(params.builtinCostModel(), platformSpecific);
        this.logs = ArrayBuffer$.MODULE$.empty();
    }

    public MachineParams params() {
        return this.params;
    }

    public ArrayBuffer<String> logs() {
        return this.logs;
    }

    public Term evaluateTerm(Term term) {
        this.spendBudget(ExBudgetCategory$.Startup, this.params().machineCosts().startupCost(), (ArraySeq<Tuple2<String, CekValue>>)ArraySeq$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        return this.loop$1(CekState$Compute$.MODULE$.apply(Context$.NoFrame, (ArraySeq<Tuple2<String, CekValue>>)ArraySeq$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)), term));
    }

    private final CekState computeCek(Context ctx, ArraySeq<Tuple2<String, CekValue>> env, Term term) {
        CekMachineCosts costs = this.params().machineCosts();
        Term term2 = term;
        if (term2 instanceof Term.Var) {
            NamedDeBruijn namedDeBruijn;
            Term.Var var = Term$Var$.MODULE$.unapply((Term.Var)term2);
            NamedDeBruijn name = namedDeBruijn = var._1();
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Var), costs.varCost(), env);
            return CekState$Return$.MODULE$.apply(ctx, env, this.lookupVarName(env, name));
        }
        if (term2 instanceof Term.LamAbs) {
            Term.LamAbs lamAbs = Term$LamAbs$.MODULE$.unapply((Term.LamAbs)term2);
            String string = lamAbs._1();
            Term term3 = lamAbs._2();
            String name = string;
            Term term4 = term3;
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.LamAbs), costs.lamCost(), env);
            return CekState$Return$.MODULE$.apply(ctx, env, CekValue$VLamAbs$.MODULE$.apply(name, term4, env));
        }
        if (term2 instanceof Term.Apply) {
            Term.Apply apply = Term$Apply$.MODULE$.unapply((Term.Apply)term2);
            Term term5 = apply._1();
            Term term6 = apply._2();
            Term fun = term5;
            Term arg = term6;
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Apply), costs.applyCost(), env);
            return CekState$Compute$.MODULE$.apply(Context$FrameApplyArg$.MODULE$.apply(env, arg, ctx), env, fun);
        }
        if (term2 instanceof Term.Force) {
            Term term7;
            Term.Force force = Term$Force$.MODULE$.unapply((Term.Force)term2);
            Term term8 = term7 = force._1();
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Force), costs.forceCost(), env);
            return CekState$Compute$.MODULE$.apply(Context$FrameForce$.MODULE$.apply(ctx), env, term8);
        }
        if (term2 instanceof Term.Delay) {
            Term term9;
            Term.Delay delay = Term$Delay$.MODULE$.unapply((Term.Delay)term2);
            Term term10 = term9 = delay._1();
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Delay), costs.delayCost(), env);
            return CekState$Return$.MODULE$.apply(ctx, env, CekValue$VDelay$.MODULE$.apply(term10, env));
        }
        if (term2 instanceof Term.Const) {
            Constant constant;
            Term.Const const_ = Term$Const$.MODULE$.unapply((Term.Const)term2);
            Constant constant2 = constant = const_._1();
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Const), costs.constCost(), env);
            return CekState$Return$.MODULE$.apply(ctx, env, CekValue$VCon$.MODULE$.apply(constant2));
        }
        if (term2 instanceof Term.Builtin) {
            DefaultFun defaultFun;
            Term.Builtin builtin = Term$Builtin$.MODULE$.unapply((Term.Builtin)term2);
            DefaultFun bn = defaultFun = builtin._1();
            this.spendBudget(ExBudgetCategory$Step$.MODULE$.apply(StepKind$.Builtin), costs.builtinCost(), env);
            Option option = this.BuiltinMeanings().get((Object)bn);
            if (option instanceof Some) {
                BuiltinRuntime meaning = (BuiltinRuntime)((Some)option).value();
                return CekState$Return$.MODULE$.apply(ctx, env, CekValue$VBuiltin$.MODULE$.apply(bn, (Function0<Term>)(Function0 & Serializable)() -> term, meaning));
            }
            if (None$.MODULE$.equals(option)) {
                throw new UnknownBuiltin(bn, env);
            }
            throw new MatchError((Object)option);
        }
        Term term11 = Term$.Error;
        Term term12 = term2;
        if (!(term11 != null ? !term11.equals(term12) : term12 != null)) {
            throw new EvaluationFailure(env);
        }
        throw new MatchError((Object)term2);
    }

    private CekState returnCek(Context ctx, ArraySeq<Tuple2<String, CekValue>> env, CekValue value) {
        Context context = ctx;
        if (context instanceof Context.FrameApplyArg) {
            Context.FrameApplyArg frameApplyArg = Context$FrameApplyArg$.MODULE$.unapply((Context.FrameApplyArg)context);
            ArraySeq<Tuple2<String, CekValue>> arraySeq = frameApplyArg._1();
            Term term = frameApplyArg._2();
            Context context2 = frameApplyArg._3();
            ArraySeq<Tuple2<String, CekValue>> env2 = arraySeq;
            Term arg = term;
            Context ctx2 = context2;
            return CekState$Compute$.MODULE$.apply(Context$FrameApplyFun$.MODULE$.apply(value, ctx2), env2, arg);
        }
        if (context instanceof Context.FrameApplyFun) {
            Context.FrameApplyFun frameApplyFun = Context$FrameApplyFun$.MODULE$.unapply((Context.FrameApplyFun)context);
            CekValue cekValue = frameApplyFun._1();
            Context context3 = frameApplyFun._2();
            CekValue fun = cekValue;
            Context ctx3 = context3;
            return this.applyEvaluate(ctx3, env, fun, value);
        }
        if (context instanceof Context.FrameForce) {
            Context context4;
            Context.FrameForce frameForce = Context$FrameForce$.MODULE$.unapply((Context.FrameForce)context);
            Context ctx4 = context4 = frameForce._1();
            return this.forceEvaluate(ctx4, env, value);
        }
        Context context5 = Context$.NoFrame;
        Context context6 = context;
        if (!(context5 != null ? !context5.equals(context6) : context6 != null)) {
            return CekState$Done$.MODULE$.apply(this.dischargeCekValue(value));
        }
        throw new MatchError((Object)context);
    }

    private CekValue lookupVarName(ArraySeq<Tuple2<String, CekValue>> env, NamedDeBruijn name) {
        if (name.index() > env.size()) {
            throw new OpenTermEvaluatedMachineError(name, env);
        }
        return (CekValue)((Tuple2)env.apply(env.size() - name.index()))._2();
    }

    private CekState applyEvaluate(Context ctx, ArraySeq<Tuple2<String, CekValue>> env, CekValue fun, CekValue arg) {
        CekValue cekValue = fun;
        if (cekValue instanceof CekValue.VLamAbs) {
            CekValue.VLamAbs vLamAbs = CekValue$VLamAbs$.MODULE$.unapply((CekValue.VLamAbs)cekValue);
            String string = vLamAbs._1();
            Term term = vLamAbs._2();
            ArraySeq<Tuple2<String, CekValue>> arraySeq = vLamAbs._3();
            String name = string;
            Term term2 = term;
            ArraySeq<Tuple2<String, CekValue>> env2 = arraySeq;
            return CekState$Compute$.MODULE$.apply(ctx, (ArraySeq<Tuple2<String, CekValue>>)((ArraySeq)env2.$colon$plus((Object)Tuple2$.MODULE$.apply((Object)name, (Object)arg))), term2);
        }
        if (cekValue instanceof CekValue.VBuiltin) {
            CekValue.VBuiltin vBuiltin = CekValue$VBuiltin$.MODULE$.unapply((CekValue.VBuiltin)cekValue);
            DefaultFun defaultFun = vBuiltin._1();
            Function0<Term> function0 = vBuiltin._2();
            BuiltinRuntime builtinRuntime = vBuiltin._3();
            DefaultFun fun2 = defaultFun;
            Function0<Term> term = function0;
            BuiltinRuntime runtime = builtinRuntime;
            Function0 & Serializable term1 = (Function0 & Serializable)() -> Term$Apply$.MODULE$.apply((Term)term.apply(), this.dischargeCekValue(arg));
            TypeScheme typeScheme = runtime.typeScheme();
            if (typeScheme instanceof TypeScheme.Arrow) {
                TypeScheme typeScheme2;
                TypeScheme.Arrow arrow = TypeScheme$Arrow$.MODULE$.unapply((TypeScheme.Arrow)typeScheme);
                TypeScheme typeScheme3 = arrow._1();
                TypeScheme rest = typeScheme2 = arrow._2();
                Seq seq = (Seq)runtime.args().$colon$plus((Object)arg);
                Function2<Logger, Seq<CekValue>, CekValue> function2 = runtime.copy$default$2();
                CostingFun<CostModel> costingFun = runtime.copy$default$4();
                BuiltinRuntime runtime1 = runtime.copy(rest, function2, (Seq<CekValue>)seq, costingFun);
                CekValue res = this.evalBuiltinApp(env, fun2, (Function0<Term>)term1, runtime1);
                return CekState$Return$.MODULE$.apply(ctx, env, res);
            }
            throw new UnexpectedBuiltinTermArgumentMachineError((Term)term1.apply(), env);
        }
        throw new NonFunctionalApplicationMachineError(fun, env);
    }

    private CekState forceEvaluate(Context ctx, ArraySeq<Tuple2<String, CekValue>> env, CekValue value) {
        CekValue cekValue = value;
        if (cekValue instanceof CekValue.VDelay) {
            CekValue.VDelay vDelay = CekValue$VDelay$.MODULE$.unapply((CekValue.VDelay)cekValue);
            Term term = vDelay._1();
            ArraySeq<Tuple2<String, CekValue>> arraySeq = vDelay._2();
            Term term2 = term;
            ArraySeq<Tuple2<String, CekValue>> env2 = arraySeq;
            return CekState$Compute$.MODULE$.apply(ctx, env2, term2);
        }
        if (cekValue instanceof CekValue.VBuiltin) {
            CekValue.VBuiltin vBuiltin = CekValue$VBuiltin$.MODULE$.unapply((CekValue.VBuiltin)cekValue);
            DefaultFun defaultFun = vBuiltin._1();
            Function0<Term> function0 = vBuiltin._2();
            BuiltinRuntime builtinRuntime = vBuiltin._3();
            DefaultFun bn = defaultFun;
            Function0<Term> term = function0;
            BuiltinRuntime rt = builtinRuntime;
            Function0 & Serializable term1 = (Function0 & Serializable)() -> Term$Force$.MODULE$.apply((Term)term.apply());
            TypeScheme typeScheme = rt.typeScheme();
            if (typeScheme instanceof TypeScheme.All) {
                TypeScheme typeScheme2;
                TypeScheme.All all = TypeScheme$All$.MODULE$.unapply((TypeScheme.All)typeScheme);
                String string = all._1();
                TypeScheme t = typeScheme2 = all._2();
                BuiltinRuntime runtime1 = rt.copy(t, rt.copy$default$2(), rt.copy$default$3(), rt.copy$default$4());
                CekValue res = this.evalBuiltinApp(env, bn, (Function0<Term>)term1, runtime1);
                return CekState$Return$.MODULE$.apply(ctx, env, res);
            }
            throw new BuiltinTermArgumentExpectedMachineError((Term)term1.apply(), env);
        }
        throw new NonPolymorphicInstantiationMachineError(value, env);
    }

    private CekValue evalBuiltinApp(ArraySeq<Tuple2<String, CekValue>> env, DefaultFun builtinName, Function0<Term> term, BuiltinRuntime runtime) {
        block7: {
            CekValue cekValue;
            block5: {
                TypeScheme typeScheme;
                block6: {
                    block4: {
                        typeScheme = runtime.typeScheme();
                        if (!(typeScheme instanceof TypeScheme.Type)) break block4;
                        TypeScheme.Type type = TypeScheme$Type$.MODULE$.unapply((TypeScheme.Type)typeScheme);
                        DefaultUni defaultUni = type._1();
                        break block5;
                    }
                    if (!(typeScheme instanceof TypeScheme.TVar)) break block6;
                    TypeScheme.TVar tVar = TypeScheme$TVar$.MODULE$.unapply((TypeScheme.TVar)typeScheme);
                    String string = tVar._1();
                    break block5;
                }
                if (!(typeScheme instanceof TypeScheme.App)) break block7;
                TypeScheme.App app = TypeScheme$App$.MODULE$.unapply((TypeScheme.App)typeScheme);
                TypeScheme typeScheme2 = app._1();
                TypeScheme typeScheme3 = app._2();
            }
            this.spendBudget(ExBudgetCategory$BuiltinApp$.MODULE$.apply(builtinName), runtime.calculateCost(), env);
            try {
                cekValue = runtime.apply(this.logger);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    throw new BuiltinError(builtinName, (Term)term.apply(), e, env);
                }
                throw throwable;
            }
            return cekValue;
        }
        return CekValue$VBuiltin$.MODULE$.apply(builtinName, term, runtime);
    }

    private Term dischargeCekValue(CekValue value) {
        CekValue cekValue = value;
        if (cekValue instanceof CekValue.VCon) {
            Constant constant;
            CekValue.VCon vCon = CekValue$VCon$.MODULE$.unapply((CekValue.VCon)cekValue);
            Constant constant2 = constant = vCon._1();
            return Term$Const$.MODULE$.apply(constant2);
        }
        if (cekValue instanceof CekValue.VDelay) {
            CekValue.VDelay vDelay = CekValue$VDelay$.MODULE$.unapply((CekValue.VDelay)cekValue);
            Term term = vDelay._1();
            ArraySeq<Tuple2<String, CekValue>> arraySeq = vDelay._2();
            Term term2 = term;
            ArraySeq<Tuple2<String, CekValue>> env = arraySeq;
            return this.dischargeCekValEnv$1(env, Term$Delay$.MODULE$.apply(term2));
        }
        if (cekValue instanceof CekValue.VLamAbs) {
            CekValue.VLamAbs vLamAbs = CekValue$VLamAbs$.MODULE$.unapply((CekValue.VLamAbs)cekValue);
            String string = vLamAbs._1();
            Term term = vLamAbs._2();
            ArraySeq<Tuple2<String, CekValue>> arraySeq = vLamAbs._3();
            String name = string;
            Term term3 = term;
            ArraySeq<Tuple2<String, CekValue>> env = arraySeq;
            return this.dischargeCekValEnv$1(env, Term$LamAbs$.MODULE$.apply(name, term3));
        }
        if (cekValue instanceof CekValue.VBuiltin) {
            CekValue.VBuiltin vBuiltin = CekValue$VBuiltin$.MODULE$.unapply((CekValue.VBuiltin)cekValue);
            DefaultFun defaultFun = vBuiltin._1();
            Function0<Term> function0 = vBuiltin._2();
            BuiltinRuntime builtinRuntime = vBuiltin._3();
            Function0<Term> term = function0;
            return (Term)term.apply();
        }
        throw new MatchError((Object)cekValue);
    }

    private void spendBudget(ExBudgetCategory cat, ExBudget budget, ArraySeq<Tuple2<String, CekValue>> env) {
        this.budgetSpender.spendBudget(cat, budget, env);
    }

    private final Term loop$1(CekState state) {
        CekState cekState;
        while (true) {
            if ((cekState = state) instanceof CekState.Compute) {
                CekState.Compute compute = CekState$Compute$.MODULE$.unapply((CekState.Compute)cekState);
                Context context = compute._1();
                ArraySeq<Tuple2<String, CekValue>> arraySeq = compute._2();
                Term term = compute._3();
                Context ctx = context;
                ArraySeq<Tuple2<String, CekValue>> env = arraySeq;
                Term term2 = term;
                state = this.computeCek(ctx, env, term2);
                continue;
            }
            if (!(cekState instanceof CekState.Return)) break;
            CekState.Return return_ = CekState$Return$.MODULE$.unapply((CekState.Return)cekState);
            Context context = return_._1();
            ArraySeq<Tuple2<String, CekValue>> arraySeq = return_._2();
            CekValue cekValue = return_._3();
            Context ctx = context;
            ArraySeq<Tuple2<String, CekValue>> env = arraySeq;
            CekValue value = cekValue;
            state = this.returnCek(ctx, env, value);
        }
        if (cekState instanceof CekState.Done) {
            Term term;
            CekState.Done done = CekState$Done$.MODULE$.unapply((CekState.Done)cekState);
            Term term3 = term = done._1();
            return term3;
        }
        throw new MatchError((Object)cekState);
    }

    private final Term go$1(ArraySeq env$1, int lamCnt, Term term) {
        Term term2 = term;
        if (term2 instanceof Term.Var) {
            Term.Var var = Term$Var$.MODULE$.unapply((Term.Var)term2);
            NamedDeBruijn namedDeBruijn = var._1();
            NamedDeBruijn name = namedDeBruijn;
            if (lamCnt >= name.index()) {
                return term;
            }
            int relativeIdx = env$1.size() - (name.index() - lamCnt);
            if (env$1.isDefinedAt(relativeIdx)) {
                return this.dischargeCekValue((CekValue)((Tuple2)env$1.apply(relativeIdx))._2());
            }
            return term;
        }
        if (term2 instanceof Term.LamAbs) {
            Term.LamAbs lamAbs = Term$LamAbs$.MODULE$.unapply((Term.LamAbs)term2);
            String string = lamAbs._1();
            Term term3 = lamAbs._2();
            String name = string;
            Term body = term3;
            return Term$LamAbs$.MODULE$.apply(name, this.go$1(env$1, lamCnt + 1, body));
        }
        if (term2 instanceof Term.Apply) {
            Term.Apply apply = Term$Apply$.MODULE$.unapply((Term.Apply)term2);
            Term term4 = apply._1();
            Term term5 = apply._2();
            Term fun = term4;
            Term arg = term5;
            return Term$Apply$.MODULE$.apply(this.go$1(env$1, lamCnt, fun), this.go$1(env$1, lamCnt, arg));
        }
        if (term2 instanceof Term.Force) {
            Term term6;
            Term.Force force = Term$Force$.MODULE$.unapply((Term.Force)term2);
            Term term7 = term6 = force._1();
            return Term$Force$.MODULE$.apply(this.go$1(env$1, lamCnt, term7));
        }
        if (term2 instanceof Term.Delay) {
            Term term8;
            Term.Delay delay = Term$Delay$.MODULE$.unapply((Term.Delay)term2);
            Term term9 = term8 = delay._1();
            return Term$Delay$.MODULE$.apply(this.go$1(env$1, lamCnt, term9));
        }
        return term;
    }

    private final Term dischargeCekValEnv$1(ArraySeq env, Term term) {
        return this.go$1(env, 0, term);
    }
}

