/*
 * Decompiled with CFR 0.152.
 */
package scalus.utils;

import io.bullet.borer.Cbor$;
import io.bullet.borer.Decoder$;
import io.bullet.borer.Encoder$;
import io.bullet.borer.Input;
import io.bullet.borer.Input$;
import io.bullet.borer.Json$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.sys.process.package$;
import scalus.ledger.api.PlutusLedgerLanguage;
import scalus.ledger.api.PlutusLedgerLanguage$;
import scalus.uplc.DeBruijn$;
import scalus.uplc.DeBruijnedProgram;
import scalus.uplc.Program;
import scalus.uplc.ProgramFlatCodec$;
import scalus.utils.Hex$;
import scalus.utils.PlutusTextEnvelope;
import scalus.utils.PlutusTextEnvelope$;

public final class Utils$
implements Serializable {
    public static final Utils$ MODULE$ = new Utils$();

    private Utils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Utils$.class);
    }

    public final String bytesToHex(byte[] bytes) {
        return Hex$.MODULE$.bytesToHex(bytes);
    }

    public final byte[] hexToBytes(String hex) {
        return Hex$.MODULE$.hexToBytes(hex);
    }

    public String lowerFirst(String s) {
        return new StringBuilder(0).append(RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(s))))).append(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(s))).toString();
    }

    public byte[] sha2_256(byte[] bytes) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(bytes);
        return digest.digest();
    }

    public byte[] uplcToFlat(String program) {
        String cmd = "uplc convert --of flat";
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        package$.MODULE$.stringToProcess(cmd).$hash$less(() -> this.uplcToFlat$$anonfun$1(program)).$hash$greater(() -> this.uplcToFlat$$anonfun$2(outStream)).$bang();
        return outStream.toByteArray();
    }

    public String uplcEvaluate(String code) {
        String cmd = "uplc evaluate";
        String out = package$.MODULE$.stringToProcess(cmd).$hash$less(() -> this.$anonfun$1(code)).$bang$bang();
        return out;
    }

    public void writePlutusFile(String path, Program program, PlutusLedgerLanguage plutusVersion) {
        byte[] content = this.programToPlutusFileContent(program, plutusVersion);
        Files.write(Paths.get(path, new String[0]), content, new OpenOption[0]);
    }

    public byte[] programToPlutusFileContent(Program program, PlutusLedgerLanguage plutusVersion) {
        String string;
        PlutusLedgerLanguage plutusLedgerLanguage = plutusVersion;
        PlutusLedgerLanguage plutusLedgerLanguage2 = PlutusLedgerLanguage$.PlutusV1;
        PlutusLedgerLanguage plutusLedgerLanguage3 = plutusLedgerLanguage;
        if (!(plutusLedgerLanguage2 != null ? !plutusLedgerLanguage2.equals(plutusLedgerLanguage3) : plutusLedgerLanguage3 != null)) {
            string = "PlutusScriptV1";
        } else {
            PlutusLedgerLanguage plutusLedgerLanguage4 = PlutusLedgerLanguage$.PlutusV2;
            PlutusLedgerLanguage plutusLedgerLanguage5 = plutusLedgerLanguage;
            if (!(plutusLedgerLanguage4 != null ? !plutusLedgerLanguage4.equals(plutusLedgerLanguage5) : plutusLedgerLanguage5 != null)) {
                string = "PlutusScriptV2";
            } else {
                throw new Exception(new StringBuilder(28).append("Unsupported Plutus version: ").append(plutusVersion).toString());
            }
        }
        String type = string;
        return Json$.MODULE$.encode((Object)PlutusTextEnvelope$.MODULE$.apply(type, "", program.doubleCborHex()), Encoder$.MODULE$.fromCodec(PlutusTextEnvelope$.MODULE$.given_Codec_PlutusTextEnvelope())).toByteArray();
    }

    public Program readPlutusFileContent(byte[] content) {
        PlutusTextEnvelope envelope = (PlutusTextEnvelope)Json$.MODULE$.decode((Object)content, (Input.Provider)Input$.MODULE$.FromByteArrayProvider()).to(Decoder$.MODULE$.fromCodec(PlutusTextEnvelope$.MODULE$.given_Codec_PlutusTextEnvelope())).value();
        String doubleCborHex = envelope.cborHex();
        byte[] cbor = (byte[])Cbor$.MODULE$.decode((Object)this.hexToBytes(doubleCborHex), (Input.Provider)Input$.MODULE$.FromByteArrayProvider()).to(Decoder$.MODULE$.forByteArrayDefault()).value();
        byte[] scriptFlat = (byte[])Cbor$.MODULE$.decode((Object)cbor, (Input.Provider)Input$.MODULE$.FromByteArrayProvider()).to(Decoder$.MODULE$.forByteArrayDefault()).value();
        DeBruijnedProgram debruijnedProgram = ProgramFlatCodec$.MODULE$.decodeFlat(scriptFlat);
        Program program = DeBruijn$.MODULE$.fromDeBruijnProgram(debruijnedProgram);
        return program;
    }

    public Program readPlutusFile(String path) {
        byte[] content = Files.readAllBytes(Paths.get(path, new String[0]));
        return this.readPlutusFileContent(content);
    }

    private final InputStream uplcToFlat$$anonfun$1(String program$1) {
        return new ByteArrayInputStream(program$1.getBytes("UTF-8"));
    }

    private final OutputStream uplcToFlat$$anonfun$2(ByteArrayOutputStream outStream$1) {
        return outStream$1;
    }

    private final InputStream $anonfun$1(String code$1) {
        return new ByteArrayInputStream(code$1.getBytes("UTF-8"));
    }
}

