/*
 * Decompiled with CFR 0.152.
 */
package scalus.flat;

import java.io.Serializable;
import scala.Array$;
import scala.Byte$;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scalus.flat.package$;
import scalus.flat.package$Natural$;
import scalus.utils.HashConsed;
import scalus.utils.HashConsed$State$;

public final class package {
    public static int arrayBlocks(int n) {
        return package$.MODULE$.arrayBlocks(n);
    }

    public static int byteArraySize(byte[] byArray) {
        return package$.MODULE$.byteArraySize(byArray);
    }

    public static String byteAsBitString(byte by) {
        return package$.MODULE$.byteAsBitString(by);
    }

    public static <A> A decode(DecoderState decoderState, Flat<A> flat) {
        return package$.MODULE$.decode(decoderState, flat);
    }

    public static <A> void encode(A a, EncoderState encoderState, Flat<A> flat) {
        package$.MODULE$.encode(a, encoderState, flat);
    }

    public static Flat<byte[]> given_Flat_Array() {
        return package$.MODULE$.given_Flat_Array();
    }

    public static <A> listFlat<A> listFlat(Flat<A> flat) {
        return package$.MODULE$.listFlat(flat);
    }

    public static <A, B> pairFlat<A, B> pairFlat(Flat<A> flat, Flat<B> flat2) {
        return package$.MODULE$.pairFlat(flat, flat2);
    }

    public static List<Object> w7l(BigInt bigInt) {
        return package$.MODULE$.w7l(bigInt);
    }

    public static List<Object> w7l(long l) {
        return package$.MODULE$.w7l(l);
    }

    public static BigInt zagZig(BigInt bigInt) {
        return package$.MODULE$.zagZig(bigInt);
    }

    public static int zagZig(int n) {
        return package$.MODULE$.zagZig(n);
    }

    public static long zagZig(long l) {
        return package$.MODULE$.zagZig(l);
    }

    public static BigInt zigZag(BigInt bigInt) {
        return package$.MODULE$.zigZag(bigInt);
    }

    public static int zigZag(int n) {
        return package$.MODULE$.zigZag(n);
    }

    public static long zigZag(long l) {
        return package$.MODULE$.zigZag(l);
    }

    public static class ArrayByteFlat
    implements Flat<byte[]> {
        @Override
        public int bitSize(byte[] a) {
            return package$.MODULE$.byteArraySize(a);
        }

        @Override
        public void encode(byte[] a, EncoderState enc) {
            enc.filler();
            int numElems = a.length;
            int inx = 0;
            int blkLen = Math.min(255, numElems);
            while (blkLen > 0) {
                enc.bits(8, (byte)blkLen);
                for (int i = 0; i < blkLen; ++i) {
                    enc.bits(8, a[inx + i]);
                }
                inx += blkLen;
                blkLen = Math.min(255, numElems -= blkLen);
            }
            enc.bits(8, (byte)0);
        }

        @Override
        public byte[] decode(DecoderState decode) {
            decode.filler();
            int numElems = decode.buffer()[decode.currPtr()] & 0xFF;
            int decoderOffset = numElems + 1;
            int size = numElems;
            while (numElems == 255) {
                numElems = decode.buffer()[decode.currPtr() + decoderOffset] & 0xFF;
                size += numElems;
                decoderOffset += numElems + 1;
            }
            int size2 = size;
            byte[] result = new byte[size2];
            int numElems2 = decode.buffer()[decode.currPtr()] & 0xFF;
            decode.currPtr_$eq(decode.currPtr() + 1);
            int resultOffset = 0;
            while (numElems2 > 0) {
                Array$.MODULE$.copy((Object)decode.buffer(), decode.currPtr(), (Object)result, resultOffset, numElems2);
                decode.currPtr_$eq(decode.currPtr() + numElems2);
                resultOffset += numElems2;
                numElems2 = decode.buffer()[decode.currPtr()] & 0xFF;
                decode.currPtr_$eq(decode.currPtr() + 1);
            }
            return result;
        }
    }

    public static class DecoderState {
        private final byte[] buffer;
        private int currPtr;
        private int usedBits;
        private final HashConsed.State hashConsed;

        public DecoderState(byte[] buffer) {
            this.buffer = buffer;
            this.currPtr = 0;
            this.usedBits = 0;
            this.hashConsed = HashConsed$State$.MODULE$.empty();
        }

        public byte[] buffer() {
            return this.buffer;
        }

        public int currPtr() {
            return this.currPtr;
        }

        public void currPtr_$eq(int x$1) {
            this.currPtr = x$1;
        }

        public int usedBits() {
            return this.usedBits;
        }

        public void usedBits_$eq(int x$1) {
            this.usedBits = x$1;
        }

        public HashConsed.State hashConsed() {
            return this.hashConsed;
        }

        public String toString() {
            Object object = Predef$.MODULE$.byteArrayOps(this.buffer());
            return new StringBuilder(40).append("DecoderState(currPtr:").append(this.currPtr()).append(",usedBits:").append(this.usedBits()).append(",buffer:").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, package$::scalus$flat$package$DecoderState$$_$toString$$anonfun$adapted$2, ClassTag$.MODULE$.apply(String.class))).mkString(",")).append(")").toString();
        }

        public byte lookupBits8(int numBits) {
            if (numBits < 0 || numBits > 8) {
                throw new RuntimeException(new StringBuilder(42).append("Decoder.bits8: incorrect value of numBits ").append(numBits).toString());
            }
            this.ensureBits(numBits);
            int unusedBits = 8 - this.usedBits();
            int leadingZeros = 8 - numBits;
            int r = (this.buffer()[this.currPtr()] << this.usedBits() & 0xFF) >>> leadingZeros;
            if (numBits > unusedBits) {
                byte nextByte = this.buffer()[this.currPtr() + 1];
                int lowerBits = (nextByte & 0xFF) >>> unusedBits + leadingZeros;
                r |= lowerBits;
            }
            return (byte)(r & 0xFF);
        }

        public byte bits8(int numBits) {
            byte r = this.lookupBits8(numBits);
            this.dropBits(numBits);
            return r;
        }

        public void filler() {
            while (this.bits8(1) == 0) {
            }
        }

        public void ensureBits(int requiredBits) {
            if (requiredBits > this.availableBits()) {
                throw new RuntimeException(new StringBuilder(41).append("DecoderState: Not enough data available: ").append(this.toString()).toString());
            }
        }

        public int bitPosition() {
            return this.currPtr() * 8 + this.usedBits();
        }

        private int availableBits() {
            return 8 * this.availableBytes() - this.usedBits();
        }

        private int availableBytes() {
            return this.buffer().length - this.currPtr();
        }

        private void dropBits(int numBits) {
            int totUsed = numBits + this.usedBits();
            this.usedBits_$eq(totUsed % 8);
            this.currPtr_$eq(this.currPtr() + (int)Math.floor(Int$.MODULE$.int2double(totUsed / 8)));
        }
    }

    public static class EncoderState {
        private final byte[] buffer;
        private int nextPtr;
        private int usedBits;
        private int currentByte;

        public EncoderState(int bufferSize) {
            this.buffer = new byte[bufferSize];
            this.nextPtr = 0;
            this.usedBits = 0;
            this.currentByte = 0;
        }

        public byte[] buffer() {
            return this.buffer;
        }

        public int nextPtr() {
            return this.nextPtr;
        }

        public void nextPtr_$eq(int x$1) {
            this.nextPtr = x$1;
        }

        public int usedBits() {
            return this.usedBits;
        }

        public void usedBits_$eq(int x$1) {
            this.usedBits = x$1;
        }

        public int currentByte() {
            return this.currentByte;
        }

        public void currentByte_$eq(int x$1) {
            this.currentByte = x$1;
        }

        public byte[] result() {
            int len = this.usedBits() == 0 ? this.nextPtr() : this.nextPtr() + 1;
            byte[] result = new byte[len];
            System.arraycopy(this.buffer(), 0, result, 0, len);
            return result;
        }

        public String toString() {
            Object object = Predef$.MODULE$.byteArrayOps(this.buffer());
            return new StringBuilder(53).append("EncoderState(nextPtr:").append(this.nextPtr()).append(",usedBits:").append(this.usedBits()).append(",currentByte:").append(this.currentByte()).append(",buffer:").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, package$::scalus$flat$package$EncoderState$$_$toString$$anonfun$adapted$1, ClassTag$.MODULE$.apply(String.class))).mkString(",")).append(")").toString();
        }

        public void bits(int numBits, byte value) {
            this.usedBits_$eq(this.usedBits() + numBits);
            int unusedBits = 8 - this.usedBits();
            if (unusedBits > 0) {
                this.currentByte_$eq(this.currentByte() | value << unusedBits);
                return;
            }
            if (unusedBits == 0) {
                this.currentByte_$eq(this.currentByte() | value);
                this.nextWord();
                return;
            }
            byte used = (byte)(-unusedBits);
            this.currentByte_$eq(this.currentByte() | (value & 0xFF) >>> Byte$.MODULE$.byte2int(used));
            this.nextWord();
            this.currentByte_$eq(value << 8 - used);
            this.usedBits_$eq(Byte$.MODULE$.byte2int(used));
        }

        public void nextWord() {
            this.buffer()[this.nextPtr()] = (byte)this.currentByte();
            this.nextPtr_$eq(this.nextPtr() + 1);
            this.currentByte_$eq(0);
            this.usedBits_$eq(0);
        }

        public void filler() {
            this.currentByte_$eq(this.currentByte() | 1);
            this.nextWord();
        }

        public int bitPosition() {
            return this.nextPtr() * 8 + this.usedBits();
        }
    }

    public static interface Flat<A> {
        public int bitSize(A var1);

        public void encode(A var1, EncoderState var2);

        public A decode(DecoderState var1);
    }

    public static class Natural
    implements Product,
    Serializable {
        private final BigInt n;

        public static Natural apply(BigInt bigInt) {
            return package$Natural$.MODULE$.apply(bigInt);
        }

        public static Natural fromProduct(Product product) {
            return package$Natural$.MODULE$.fromProduct(product);
        }

        public static Natural unapply(Natural natural) {
            return package$Natural$.MODULE$.unapply(natural);
        }

        public Natural(BigInt n) {
            this.n = n;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Natural)) return false;
            Natural natural = (Natural)object;
            BigInt bigInt = this.n();
            BigInt bigInt2 = natural.n();
            if (bigInt == null) {
                if (bigInt2 != null) {
                    return false;
                }
            } else if (!bigInt.equals(bigInt2)) return false;
            if (!natural.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Natural;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Natural";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "n";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BigInt n() {
            return this.n;
        }

        public Natural copy(BigInt n) {
            return new Natural(n);
        }

        public BigInt copy$default$1() {
            return this.n();
        }

        public BigInt _1() {
            return this.n();
        }
    }

    public static class listFlat<A>
    implements Flat<List<A>> {
        private final Flat<A> evidence$1;

        public listFlat(Flat<A> evidence$1) {
            this.evidence$1 = evidence$1;
        }

        @Override
        public int bitSize(List<A> a) {
            Flat<A> flat = this.evidence$1;
            return BoxesRunTime.unboxToInt((Object)a.foldLeft((Object)BoxesRunTime.boxToInteger((int)1), (arg_0, arg_1) -> package$.scalus$flat$package$listFlat$$_$bitSize$$anonfun$adapted$1(flat, arg_0, arg_1)));
        }

        @Override
        public void encode(List<A> a, EncoderState encode) {
            Flat<A> flat = this.evidence$1;
            a.foreach(arg_0 -> package$.scalus$flat$package$listFlat$$_$encode$$anonfun$adapted$1(encode, flat, arg_0));
            encode.bits(1, (byte)0);
        }

        @Override
        public List<A> decode(DecoderState decode) {
            Flat<A> flat = this.evidence$1;
            ListBuffer result = ListBuffer$.MODULE$.empty();
            while (decode.bits8(1) == 1) {
                A a = flat.decode(decode);
                result.addOne(a);
            }
            return result.toList();
        }
    }

    public static class pairFlat<A, B>
    implements Flat<Tuple2<A, B>> {
        private final Flat<A> evidence$1;
        private final Flat<B> evidence$2;

        public pairFlat(Flat<A> evidence$1, Flat<B> evidence$2) {
            this.evidence$1 = evidence$1;
            this.evidence$2 = evidence$2;
        }

        @Override
        public int bitSize(Tuple2<A, B> a) {
            return this.evidence$1.bitSize(a._1()) + this.evidence$2.bitSize(a._2());
        }

        @Override
        public void encode(Tuple2<A, B> a, EncoderState encode) {
            this.evidence$1.encode(a._1(), encode);
            this.evidence$2.encode(a._2(), encode);
        }

        @Override
        public Tuple2<A, B> decode(DecoderState decode) {
            A a = this.evidence$1.decode(decode);
            B b = this.evidence$2.decode(decode);
            return Tuple2$.MODULE$.apply(a, b);
        }
    }
}

