/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.ledger;

import scala.Option;
import scala.Product;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scalus.builtin.ByteString;
import scalus.cardano.ledger.DatumOption;
import scalus.cardano.ledger.ScriptRef;
import scalus.cardano.ledger.TransactionOutput$;
import scalus.cardano.ledger.TransactionOutput$Babbage$;
import scalus.cardano.ledger.TransactionOutput$Shelley$;
import scalus.cardano.ledger.Value;

public abstract class TransactionOutput
implements Product,
Enum {
    public static TransactionOutput fromOrdinal(int n) {
        return TransactionOutput$.MODULE$.fromOrdinal(n);
    }

    public static final class Babbage
    extends TransactionOutput {
        private final ByteString address;
        private final Value value;
        private final Option datumOption;
        private final Option scriptRef;

        public static Babbage apply(ByteString byteString, Value value, Option<DatumOption> option, Option<ScriptRef> option2) {
            return TransactionOutput$Babbage$.MODULE$.apply(byteString, value, option, option2);
        }

        public static Babbage fromProduct(Product product) {
            return TransactionOutput$Babbage$.MODULE$.fromProduct(product);
        }

        public static Babbage unapply(Babbage babbage) {
            return TransactionOutput$Babbage$.MODULE$.unapply(babbage);
        }

        public static Option<DatumOption> $lessinit$greater$default$3() {
            return TransactionOutput$Babbage$.MODULE$.$lessinit$greater$default$3();
        }

        public static Option<ScriptRef> $lessinit$greater$default$4() {
            return TransactionOutput$Babbage$.MODULE$.$lessinit$greater$default$4();
        }

        public Babbage(ByteString datumOption, Value scriptRef, Option<DatumOption> option, Option<ScriptRef> option2) {
            this.address = address;
            this.value = (Value)value;
            this.datumOption = datumOption;
            this.scriptRef = scriptRef;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Babbage)) return false;
            Babbage babbage = (Babbage)object;
            ByteString byteString = this.address();
            ByteString byteString2 = babbage.address();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            Value value = this.value();
            Value value2 = babbage.value();
            if (value == null) {
                if (value2 != null) {
                    return false;
                }
            } else if (!value.equals(value2)) return false;
            Option<DatumOption> option = this.datumOption();
            Option<DatumOption> option2 = babbage.datumOption();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<ScriptRef> option3 = this.scriptRef();
            Option<ScriptRef> option4 = babbage.scriptRef();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Babbage;
        }

        public int productArity() {
            return 4;
        }

        @Override
        public String productPrefix() {
            return "Babbage";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "address";
                }
                case 1: {
                    return "value";
                }
                case 2: {
                    return "datumOption";
                }
                case 3: {
                    return "scriptRef";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteString address() {
            return this.address;
        }

        public Value value() {
            return this.value;
        }

        public Option<DatumOption> datumOption() {
            return this.datumOption;
        }

        public Option<ScriptRef> scriptRef() {
            return this.scriptRef;
        }

        public Babbage copy(ByteString address, Value value, Option<DatumOption> datumOption, Option<ScriptRef> scriptRef) {
            return new Babbage(address, value, datumOption, scriptRef);
        }

        public ByteString copy$default$1() {
            return this.address();
        }

        public Value copy$default$2() {
            return this.value();
        }

        public Option<DatumOption> copy$default$3() {
            return this.datumOption();
        }

        public Option<ScriptRef> copy$default$4() {
            return this.scriptRef();
        }

        public int ordinal() {
            return 1;
        }

        public ByteString _1() {
            return this.address();
        }

        public Value _2() {
            return this.value();
        }

        public Option<DatumOption> _3() {
            return this.datumOption();
        }

        public Option<ScriptRef> _4() {
            return this.scriptRef();
        }
    }

    public static final class Shelley
    extends TransactionOutput {
        private final ByteString address;
        private final Value value;
        private final Option datumHash;

        public static Shelley apply(ByteString byteString, Value value, Option<ByteString> option) {
            return TransactionOutput$Shelley$.MODULE$.apply(byteString, value, option);
        }

        public static Shelley fromProduct(Product product) {
            return TransactionOutput$Shelley$.MODULE$.fromProduct(product);
        }

        public static Shelley unapply(Shelley shelley) {
            return TransactionOutput$Shelley$.MODULE$.unapply(shelley);
        }

        public static Option<ByteString> $lessinit$greater$default$3() {
            return TransactionOutput$Shelley$.MODULE$.$lessinit$greater$default$3();
        }

        public Shelley(ByteString datumHash, Value value2, Option<ByteString> option) {
            this.address = address;
            this.value = (Value)value;
            this.datumHash = datumHash;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Shelley)) return false;
            Shelley shelley = (Shelley)object;
            ByteString byteString = this.address();
            ByteString byteString2 = shelley.address();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            Value value = this.value();
            Value value2 = shelley.value();
            if (value == null) {
                if (value2 != null) {
                    return false;
                }
            } else if (!value.equals(value2)) return false;
            Option<ByteString> option = this.datumHash();
            Option<ByteString> option2 = shelley.datumHash();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Shelley;
        }

        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "Shelley";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "address";
                }
                case 1: {
                    return "value";
                }
                case 2: {
                    return "datumHash";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteString address() {
            return this.address;
        }

        public Value value() {
            return this.value;
        }

        public Option<ByteString> datumHash() {
            return this.datumHash;
        }

        public Shelley copy(ByteString address, Value value, Option<ByteString> datumHash) {
            return new Shelley(address, value, datumHash);
        }

        public ByteString copy$default$1() {
            return this.address();
        }

        public Value copy$default$2() {
            return this.value();
        }

        public Option<ByteString> copy$default$3() {
            return this.datumHash();
        }

        public int ordinal() {
            return 0;
        }

        public ByteString _1() {
            return this.address();
        }

        public Value _2() {
            return this.value();
        }

        public Option<ByteString> _3() {
            return this.datumHash();
        }
    }
}

