/*
 * Decompiled with CFR 0.152.
 */
package scalus.cardano.address;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.cardano.address.Network;
import scalus.cardano.address.Network$;
import scalus.cardano.address.Network$Other$;
import scalus.cardano.address.Pointer;
import scalus.cardano.address.ShelleyAddress$;
import scalus.cardano.address.ShelleyDelegationPart;
import scalus.cardano.address.ShelleyDelegationPart$;
import scalus.cardano.address.ShelleyDelegationPart$Key$;
import scalus.cardano.address.ShelleyDelegationPart$Pointer$;
import scalus.cardano.address.ShelleyDelegationPart$Script$;
import scalus.cardano.address.ShelleyPaymentPart;
import scalus.cardano.address.ShelleyPaymentPart$Key$;
import scalus.cardano.address.ShelleyPaymentPart$Script$;
import scalus.cardano.ledger.Bech32$;

public class ShelleyAddress
implements Product,
Serializable {
    private final Network network;
    private final ShelleyPaymentPart payment;
    private final ShelleyDelegationPart delegation;

    public static ShelleyAddress apply(Network network, ShelleyPaymentPart shelleyPaymentPart, ShelleyDelegationPart shelleyDelegationPart) {
        return ShelleyAddress$.MODULE$.apply(network, shelleyPaymentPart, shelleyDelegationPart);
    }

    public static ShelleyAddress fromProduct(Product product) {
        return ShelleyAddress$.MODULE$.fromProduct(product);
    }

    public static ShelleyAddress unapply(ShelleyAddress shelleyAddress) {
        return ShelleyAddress$.MODULE$.unapply(shelleyAddress);
    }

    public ShelleyAddress(Network network, ShelleyPaymentPart payment, ShelleyDelegationPart delegation) {
        this.network = network;
        this.payment = payment;
        this.delegation = delegation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ShelleyAddress)) return false;
        ShelleyAddress shelleyAddress = (ShelleyAddress)object;
        Network network = this.network();
        Network network2 = shelleyAddress.network();
        if (network == null) {
            if (network2 != null) {
                return false;
            }
        } else if (!network.equals(network2)) return false;
        ShelleyPaymentPart shelleyPaymentPart = this.payment();
        ShelleyPaymentPart shelleyPaymentPart2 = shelleyAddress.payment();
        if (shelleyPaymentPart == null) {
            if (shelleyPaymentPart2 != null) {
                return false;
            }
        } else if (!shelleyPaymentPart.equals(shelleyPaymentPart2)) return false;
        ShelleyDelegationPart shelleyDelegationPart = this.delegation();
        ShelleyDelegationPart shelleyDelegationPart2 = shelleyAddress.delegation();
        if (shelleyDelegationPart == null) {
            if (shelleyDelegationPart2 != null) {
                return false;
            }
        } else if (!shelleyDelegationPart.equals(shelleyDelegationPart2)) return false;
        if (!shelleyAddress.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ShelleyAddress;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "ShelleyAddress";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "network";
            }
            case 1: {
                return "payment";
            }
            case 2: {
                return "delegation";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Network network() {
        return this.network;
    }

    public ShelleyPaymentPart payment() {
        return this.payment;
    }

    public ShelleyDelegationPart delegation() {
        return this.delegation;
    }

    public byte typeId() {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this.payment(), (Object)this.delegation());
        if (tuple2 != null) {
            ShelleyPaymentPart shelleyPaymentPart = (ShelleyPaymentPart)tuple2._1();
            ShelleyDelegationPart shelleyDelegationPart = (ShelleyDelegationPart)tuple2._2();
            if (shelleyPaymentPart instanceof ShelleyPaymentPart.Key) {
                ShelleyPaymentPart.Key key = ShelleyPaymentPart$Key$.MODULE$.unapply((ShelleyPaymentPart.Key)shelleyPaymentPart);
                ByteString byteString = key._1();
                if (shelleyDelegationPart instanceof ShelleyDelegationPart.Key) {
                    ShelleyDelegationPart.Key key2 = ShelleyDelegationPart$Key$.MODULE$.unapply((ShelleyDelegationPart.Key)shelleyDelegationPart);
                    ByteString byteString2 = key2._1();
                    return 0;
                }
            }
            if (shelleyPaymentPart instanceof ShelleyPaymentPart.Script) {
                ShelleyPaymentPart.Script script = ShelleyPaymentPart$Script$.MODULE$.unapply((ShelleyPaymentPart.Script)shelleyPaymentPart);
                ByteString byteString = script._1();
                if (shelleyDelegationPart instanceof ShelleyDelegationPart.Key) {
                    ShelleyDelegationPart.Key key = ShelleyDelegationPart$Key$.MODULE$.unapply((ShelleyDelegationPart.Key)shelleyDelegationPart);
                    ByteString byteString3 = key._1();
                    return 1;
                }
            }
            if (shelleyPaymentPart instanceof ShelleyPaymentPart.Key) {
                ShelleyPaymentPart.Key key = ShelleyPaymentPart$Key$.MODULE$.unapply((ShelleyPaymentPart.Key)shelleyPaymentPart);
                ByteString byteString = key._1();
                if (shelleyDelegationPart instanceof ShelleyDelegationPart.Script) {
                    ShelleyDelegationPart.Script script = ShelleyDelegationPart$Script$.MODULE$.unapply((ShelleyDelegationPart.Script)shelleyDelegationPart);
                    ByteString byteString4 = script._1();
                    return 2;
                }
            }
            if (shelleyPaymentPart instanceof ShelleyPaymentPart.Script) {
                ShelleyPaymentPart.Script script = ShelleyPaymentPart$Script$.MODULE$.unapply((ShelleyPaymentPart.Script)shelleyPaymentPart);
                ByteString byteString = script._1();
                if (shelleyDelegationPart instanceof ShelleyDelegationPart.Script) {
                    ShelleyDelegationPart.Script script2 = ShelleyDelegationPart$Script$.MODULE$.unapply((ShelleyDelegationPart.Script)shelleyDelegationPart);
                    ByteString byteString5 = script2._1();
                    return 3;
                }
            }
            if (shelleyPaymentPart instanceof ShelleyPaymentPart.Key) {
                ShelleyPaymentPart.Key key = ShelleyPaymentPart$Key$.MODULE$.unapply((ShelleyPaymentPart.Key)shelleyPaymentPart);
                ByteString byteString = key._1();
                if (shelleyDelegationPart instanceof ShelleyDelegationPart.Pointer) {
                    ShelleyDelegationPart.Pointer pointer = ShelleyDelegationPart$Pointer$.MODULE$.unapply((ShelleyDelegationPart.Pointer)shelleyDelegationPart);
                    Pointer pointer2 = pointer._1();
                    return 4;
                }
            }
            if (shelleyPaymentPart instanceof ShelleyPaymentPart.Script) {
                ShelleyPaymentPart.Script script = ShelleyPaymentPart$Script$.MODULE$.unapply((ShelleyPaymentPart.Script)shelleyPaymentPart);
                ByteString byteString = script._1();
                if (shelleyDelegationPart instanceof ShelleyDelegationPart.Pointer) {
                    ShelleyDelegationPart.Pointer pointer = ShelleyDelegationPart$Pointer$.MODULE$.unapply((ShelleyDelegationPart.Pointer)shelleyDelegationPart);
                    Pointer pointer3 = pointer._1();
                    return 5;
                }
            }
            if (shelleyPaymentPart instanceof ShelleyPaymentPart.Key) {
                ShelleyPaymentPart.Key key = ShelleyPaymentPart$Key$.MODULE$.unapply((ShelleyPaymentPart.Key)shelleyPaymentPart);
                ByteString byteString = key._1();
                ShelleyDelegationPart shelleyDelegationPart2 = ShelleyDelegationPart$.Null;
                ShelleyDelegationPart shelleyDelegationPart3 = shelleyDelegationPart;
                if (!(shelleyDelegationPart2 != null ? !shelleyDelegationPart2.equals(shelleyDelegationPart3) : shelleyDelegationPart3 != null)) {
                    return 6;
                }
            }
            if (shelleyPaymentPart instanceof ShelleyPaymentPart.Script) {
                ShelleyPaymentPart.Script script = ShelleyPaymentPart$Script$.MODULE$.unapply((ShelleyPaymentPart.Script)shelleyPaymentPart);
                ByteString byteString = script._1();
                ShelleyDelegationPart shelleyDelegationPart4 = ShelleyDelegationPart$.Null;
                ShelleyDelegationPart shelleyDelegationPart5 = shelleyDelegationPart;
                if (!(shelleyDelegationPart4 != null ? !shelleyDelegationPart4.equals(shelleyDelegationPart5) : shelleyDelegationPart5 != null)) {
                    return 7;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public byte toHeader() {
        return (byte)(this.typeId() << 4 | this.network().value() & 0xF);
    }

    public Try<String> hrp() {
        Network network = this.network();
        Network network2 = Network$.Testnet;
        Network network3 = network;
        if (!(network2 != null ? !network2.equals(network3) : network3 != null)) {
            return Success$.MODULE$.apply((Object)"addr_test");
        }
        Network network4 = Network$.Mainnet;
        Network network5 = network;
        if (!(network4 != null ? !network4.equals(network5) : network5 != null)) {
            return Success$.MODULE$.apply((Object)"addr");
        }
        if (network instanceof Network.Other) {
            byte by;
            Network.Other other = Network$Other$.MODULE$.unapply((Network.Other)network);
            byte x = by = other._1();
            return Failure$.MODULE$.apply((Throwable)new IllegalArgumentException(new StringBuilder(17).append("Unknown network: ").append(x).toString()));
        }
        throw new MatchError((Object)network);
    }

    public ByteString toBytes() {
        ByteString header = ByteString$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapByteArray(new byte[]{this.toHeader()}));
        ByteString paymentBytes = this.payment().toBytes();
        ByteString delegationBytes = this.delegation().toBytes();
        return header.concat(paymentBytes).concat(delegationBytes);
    }

    public String toHex() {
        return this.toBytes().toString();
    }

    public Try<String> toBech32() {
        return this.hrp().map((Function1 & Serializable)prefix -> {
            byte[] bytes = this.toBytes().bytes();
            return Tuple2$.MODULE$.apply(prefix, (Object)bytes);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String prefix = (String)tuple2._1();
                byte[] bytes = (byte[])tuple2._2();
                return Try$.MODULE$.apply(() -> ShelleyAddress.toBech32$$anonfun$2$$anonfun$1(prefix, bytes)).map((Function1 & Serializable)encoded -> encoded);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public boolean hasScript() {
        return this.payment().isScript() || this.delegation().isScript();
    }

    public boolean isEnterprise() {
        ShelleyDelegationPart shelleyDelegationPart = this.delegation();
        ShelleyDelegationPart shelleyDelegationPart2 = ShelleyDelegationPart$.Null;
        return !(shelleyDelegationPart != null ? !shelleyDelegationPart.equals(shelleyDelegationPart2) : shelleyDelegationPart2 != null);
    }

    public ShelleyAddress copy(Network network, ShelleyPaymentPart payment, ShelleyDelegationPart delegation) {
        return new ShelleyAddress(network, payment, delegation);
    }

    public Network copy$default$1() {
        return this.network();
    }

    public ShelleyPaymentPart copy$default$2() {
        return this.payment();
    }

    public ShelleyDelegationPart copy$default$3() {
        return this.delegation();
    }

    public Network _1() {
        return this.network();
    }

    public ShelleyPaymentPart _2() {
        return this.payment();
    }

    public ShelleyDelegationPart _3() {
        return this.delegation();
    }

    private static final String toBech32$$anonfun$2$$anonfun$1(String prefix$1, byte[] bytes$4) {
        return Bech32$.MODULE$.encodeFrom5Bit(prefix$1, Bech32$.MODULE$.to5Bit(bytes$4));
    }
}

