/*
 * Decompiled with CFR 0.152.
 */
package scalus.builtin;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.scalajs.js.Any$;
import scala.scalajs.js.BigInt;
import scala.scalajs.js.BigInt$;
import scala.scalajs.js.Iterable;
import scala.scalajs.js.JSConverters;
import scala.scalajs.js.JSConverters$;
import scala.scalajs.js.typedarray.Int8Array;
import scala.scalajs.js.typedarray.Uint8Array;
import scalus.builtin.BLS12_381_G1_Element;
import scalus.builtin.BLS12_381_G1_Element$;
import scalus.builtin.BLS12_381_G2_Element;
import scalus.builtin.BLS12_381_G2_Element$;
import scalus.builtin.BLS12_381_MlResult;
import scalus.builtin.BLS12_381_MlResult$;
import scalus.builtin.Blake2b$;
import scalus.builtin.BlakeOpts;
import scalus.builtin.ByteString;
import scalus.builtin.ByteString$;
import scalus.builtin.Ed25519Curves$;
import scalus.builtin.Hash;
import scalus.builtin.PlatformSpecific;
import scalus.builtin.ProjectivePoint;
import scalus.builtin.Ripemd160$;
import scalus.builtin.Secp256k1Curve$;
import scalus.builtin.Sha2$;
import scalus.builtin.Sha3$;

public interface NodeJsPlatformSpecific
extends PlatformSpecific {
    public static void $init$(NodeJsPlatformSpecific $this) {
    }

    public static Uint8Array toUint8Array$(NodeJsPlatformSpecific $this, ByteString bs) {
        return $this.toUint8Array(bs);
    }

    default public Uint8Array toUint8Array(ByteString bs) {
        IterableOnce iterableOnce = JSConverters$.MODULE$.iterableOnceConvertible2JSRichIterableOnce((Object)bs.bytes(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs));
        Int8Array int8Array = new Int8Array((Iterable)JSConverters.JSRichIterableOnce$.MODULE$.toJSArray$extension(iterableOnce));
        return new Uint8Array(int8Array.buffer(), int8Array.byteOffset(), int8Array.length());
    }

    public static ByteString toByteString$(NodeJsPlatformSpecific $this, Uint8Array arr) {
        return $this.toByteString(arr);
    }

    default public ByteString toByteString(Uint8Array arr) {
        return ByteString$.MODULE$.unsafeFromArray((byte[])Any$.MODULE$.iterableOps((Iterable)new Int8Array(arr.buffer(), arr.byteOffset(), arr.length())).toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public static BigInt toJsBigInt$(NodeJsPlatformSpecific $this, scala.math.BigInt bigInt) {
        return $this.toJsBigInt(bigInt);
    }

    default public BigInt toJsBigInt(scala.math.BigInt bigInt) {
        return BigInt$.MODULE$.apply(bigInt.toString());
    }

    public static ByteString sha2_256$(NodeJsPlatformSpecific $this, ByteString bs) {
        return $this.sha2_256(bs);
    }

    @Override
    default public ByteString sha2_256(ByteString bs) {
        return this.toByteString(Sha2$.MODULE$.sha256(this.toUint8Array(bs)));
    }

    public static ByteString sha3_256$(NodeJsPlatformSpecific $this, ByteString bs) {
        return $this.sha3_256(bs);
    }

    @Override
    default public ByteString sha3_256(ByteString bs) {
        return this.toByteString(Sha3$.MODULE$.sha3_256(this.toUint8Array(bs)));
    }

    public static ByteString blake2b_224$(NodeJsPlatformSpecific $this, ByteString bs) {
        return $this.blake2b_224(bs);
    }

    @Override
    default public ByteString blake2b_224(ByteString bs) {
        Hash hash = Blake2b$.MODULE$.create(new BlakeOpts(28));
        return this.toByteString(hash.update(this.toUint8Array(bs)).digest());
    }

    public static ByteString blake2b_256$(NodeJsPlatformSpecific $this, ByteString bs) {
        return $this.blake2b_256(bs);
    }

    @Override
    default public ByteString blake2b_256(ByteString bs) {
        Hash hash = Blake2b$.MODULE$.create(new BlakeOpts(32));
        return this.toByteString(hash.update(this.toUint8Array(bs)).digest());
    }

    public static boolean verifyEd25519Signature$(NodeJsPlatformSpecific $this, ByteString pk, ByteString msg, ByteString sig) {
        return $this.verifyEd25519Signature(pk, msg, sig);
    }

    @Override
    default public boolean verifyEd25519Signature(ByteString pk, ByteString msg, ByteString sig) {
        Predef$.MODULE$.require(pk.length() == 32, () -> NodeJsPlatformSpecific.verifyEd25519Signature$$anonfun$1(pk));
        Predef$.MODULE$.require(sig.length() == 64, () -> NodeJsPlatformSpecific.verifyEd25519Signature$$anonfun$2(sig));
        return Ed25519Curves$.MODULE$.ed25519().verify(this.toUint8Array(sig), this.toUint8Array(msg), this.toUint8Array(pk));
    }

    private boolean isValidPublicKey(ByteString pubKey) {
        boolean bl;
        try {
            ProjectivePoint point = Secp256k1Curve$.MODULE$.secp256k1().ProjectivePoint().fromHex(this.toUint8Array(pubKey));
            point.toAffine();
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    public static boolean verifyEcdsaSecp256k1Signature$(NodeJsPlatformSpecific $this, ByteString pk, ByteString msg, ByteString sig) {
        return $this.verifyEcdsaSecp256k1Signature(pk, msg, sig);
    }

    @Override
    default public boolean verifyEcdsaSecp256k1Signature(ByteString pk, ByteString msg, ByteString sig) {
        Predef$.MODULE$.require(pk.length() == 33, () -> NodeJsPlatformSpecific.verifyEcdsaSecp256k1Signature$$anonfun$1(pk));
        Predef$.MODULE$.require(this.isValidPublicKey(pk), () -> NodeJsPlatformSpecific.verifyEcdsaSecp256k1Signature$$anonfun$2(pk));
        Predef$.MODULE$.require(msg.length() == 32, () -> NodeJsPlatformSpecific.verifyEcdsaSecp256k1Signature$$anonfun$3(msg));
        Predef$.MODULE$.require(sig.length() == 64, () -> NodeJsPlatformSpecific.verifyEcdsaSecp256k1Signature$$anonfun$4(sig));
        return Secp256k1Curve$.MODULE$.secp256k1().verify(this.toUint8Array(sig), this.toUint8Array(msg), this.toUint8Array(pk));
    }

    public static boolean verifySchnorrSecp256k1Signature$(NodeJsPlatformSpecific $this, ByteString pk, ByteString msg, ByteString sig) {
        return $this.verifySchnorrSecp256k1Signature(pk, msg, sig);
    }

    @Override
    default public boolean verifySchnorrSecp256k1Signature(ByteString pk, ByteString msg, ByteString sig) {
        Predef$.MODULE$.require(pk.length() == 32, () -> NodeJsPlatformSpecific.verifySchnorrSecp256k1Signature$$anonfun$1(pk));
        Object object = Predef$.MODULE$.byteArrayOps(pk.bytes());
        Predef$.MODULE$.require(this.isValidPublicKey(ByteString$.MODULE$.fromArray((byte[])ArrayOps$.MODULE$.$plus$colon$extension(object, (Object)BoxesRunTime.boxToByte((byte)2), ClassTag$.MODULE$.apply(Byte.TYPE)))), () -> NodeJsPlatformSpecific.verifySchnorrSecp256k1Signature$$anonfun$2(pk));
        Predef$.MODULE$.require(msg.length() == 32, () -> NodeJsPlatformSpecific.verifySchnorrSecp256k1Signature$$anonfun$3(msg));
        Predef$.MODULE$.require(sig.length() == 64, () -> NodeJsPlatformSpecific.verifySchnorrSecp256k1Signature$$anonfun$4(sig));
        return Secp256k1Curve$.MODULE$.schnorr().verify(this.toUint8Array(sig), this.toUint8Array(msg), this.toUint8Array(pk));
    }

    public static boolean bls12_381_G1_equal$(NodeJsPlatformSpecific $this, BLS12_381_G1_Element elem1, BLS12_381_G1_Element elem2) {
        return $this.bls12_381_G1_equal(elem1, elem2);
    }

    @Override
    default public boolean bls12_381_G1_equal(BLS12_381_G1_Element elem1, BLS12_381_G1_Element elem2) {
        BLS12_381_G1_Element bLS12_381_G1_Element = elem1;
        BLS12_381_G1_Element bLS12_381_G1_Element2 = elem2;
        return !(bLS12_381_G1_Element != null ? !((Object)bLS12_381_G1_Element).equals(bLS12_381_G1_Element2) : bLS12_381_G1_Element2 != null);
    }

    public static BLS12_381_G1_Element bls12_381_G1_add$(NodeJsPlatformSpecific $this, BLS12_381_G1_Element elem1, BLS12_381_G1_Element elem2) {
        return $this.bls12_381_G1_add(elem1, elem2);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_add(BLS12_381_G1_Element elem1, BLS12_381_G1_Element elem2) {
        return elem1.add(elem2);
    }

    public static BLS12_381_G1_Element bls12_381_G1_scalarMul$(NodeJsPlatformSpecific $this, scala.math.BigInt scalar, BLS12_381_G1_Element elem) {
        return $this.bls12_381_G1_scalarMul(scalar, elem);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_scalarMul(scala.math.BigInt scalar, BLS12_381_G1_Element elem) {
        return elem.multiply(scalar);
    }

    public static BLS12_381_G1_Element bls12_381_G1_neg$(NodeJsPlatformSpecific $this, BLS12_381_G1_Element elem) {
        return $this.bls12_381_G1_neg(elem);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_neg(BLS12_381_G1_Element elem) {
        return elem.negate();
    }

    public static ByteString bls12_381_G1_compress$(NodeJsPlatformSpecific $this, BLS12_381_G1_Element elem) {
        return $this.bls12_381_G1_compress(elem);
    }

    @Override
    default public ByteString bls12_381_G1_compress(BLS12_381_G1_Element elem) {
        return elem.toCompressedByteString();
    }

    public static BLS12_381_G1_Element bls12_381_G1_uncompress$(NodeJsPlatformSpecific $this, ByteString byteString) {
        return $this.bls12_381_G1_uncompress(byteString);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_uncompress(ByteString byteString) {
        return BLS12_381_G1_Element$.MODULE$.fromCompressedByteString(byteString);
    }

    public static BLS12_381_G1_Element bls12_381_G1_hashToGroup$(NodeJsPlatformSpecific $this, ByteString byteString, ByteString dst) {
        return $this.bls12_381_G1_hashToGroup(byteString, dst);
    }

    @Override
    default public BLS12_381_G1_Element bls12_381_G1_hashToGroup(ByteString byteString, ByteString dst) {
        return BLS12_381_G1_Element$.MODULE$.hashToGroup(byteString, dst);
    }

    public static boolean bls12_381_G2_equal$(NodeJsPlatformSpecific $this, BLS12_381_G2_Element elem1, BLS12_381_G2_Element elem2) {
        return $this.bls12_381_G2_equal(elem1, elem2);
    }

    @Override
    default public boolean bls12_381_G2_equal(BLS12_381_G2_Element elem1, BLS12_381_G2_Element elem2) {
        BLS12_381_G2_Element bLS12_381_G2_Element = elem1;
        BLS12_381_G2_Element bLS12_381_G2_Element2 = elem2;
        return !(bLS12_381_G2_Element != null ? !((Object)bLS12_381_G2_Element).equals(bLS12_381_G2_Element2) : bLS12_381_G2_Element2 != null);
    }

    public static BLS12_381_G2_Element bls12_381_G2_add$(NodeJsPlatformSpecific $this, BLS12_381_G2_Element elem1, BLS12_381_G2_Element elem2) {
        return $this.bls12_381_G2_add(elem1, elem2);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_add(BLS12_381_G2_Element elem1, BLS12_381_G2_Element elem2) {
        return elem1.add(elem2);
    }

    public static BLS12_381_G2_Element bls12_381_G2_scalarMul$(NodeJsPlatformSpecific $this, scala.math.BigInt scalar, BLS12_381_G2_Element elem) {
        return $this.bls12_381_G2_scalarMul(scalar, elem);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_scalarMul(scala.math.BigInt scalar, BLS12_381_G2_Element elem) {
        return elem.multiply(scalar);
    }

    public static BLS12_381_G2_Element bls12_381_G2_neg$(NodeJsPlatformSpecific $this, BLS12_381_G2_Element elem) {
        return $this.bls12_381_G2_neg(elem);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_neg(BLS12_381_G2_Element elem) {
        return elem.negate();
    }

    public static ByteString bls12_381_G2_compress$(NodeJsPlatformSpecific $this, BLS12_381_G2_Element elem) {
        return $this.bls12_381_G2_compress(elem);
    }

    @Override
    default public ByteString bls12_381_G2_compress(BLS12_381_G2_Element elem) {
        return elem.toCompressedByteString();
    }

    public static BLS12_381_G2_Element bls12_381_G2_uncompress$(NodeJsPlatformSpecific $this, ByteString byteString) {
        return $this.bls12_381_G2_uncompress(byteString);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_uncompress(ByteString byteString) {
        return BLS12_381_G2_Element$.MODULE$.fromCompressedByteString(byteString);
    }

    public static BLS12_381_G2_Element bls12_381_G2_hashToGroup$(NodeJsPlatformSpecific $this, ByteString byteString, ByteString dst) {
        return $this.bls12_381_G2_hashToGroup(byteString, dst);
    }

    @Override
    default public BLS12_381_G2_Element bls12_381_G2_hashToGroup(ByteString byteString, ByteString dst) {
        return BLS12_381_G2_Element$.MODULE$.hashToGroup(byteString, dst);
    }

    public static BLS12_381_MlResult bls12_381_millerLoop$(NodeJsPlatformSpecific $this, BLS12_381_G1_Element elemG1, BLS12_381_G2_Element elemG2) {
        return $this.bls12_381_millerLoop(elemG1, elemG2);
    }

    @Override
    default public BLS12_381_MlResult bls12_381_millerLoop(BLS12_381_G1_Element elemG1, BLS12_381_G2_Element elemG2) {
        return BLS12_381_MlResult$.MODULE$.apply(elemG1, elemG2);
    }

    public static BLS12_381_MlResult bls12_381_mulMlResult$(NodeJsPlatformSpecific $this, BLS12_381_MlResult lhs, BLS12_381_MlResult rhs) {
        return $this.bls12_381_mulMlResult(lhs, rhs);
    }

    @Override
    default public BLS12_381_MlResult bls12_381_mulMlResult(BLS12_381_MlResult lhs, BLS12_381_MlResult rhs) {
        return lhs.multiply(rhs);
    }

    public static boolean bls12_381_finalVerify$(NodeJsPlatformSpecific $this, BLS12_381_MlResult lhs, BLS12_381_MlResult rhs) {
        return $this.bls12_381_finalVerify(lhs, rhs);
    }

    @Override
    default public boolean bls12_381_finalVerify(BLS12_381_MlResult lhs, BLS12_381_MlResult rhs) {
        BLS12_381_MlResult bLS12_381_MlResult = lhs;
        BLS12_381_MlResult bLS12_381_MlResult2 = rhs;
        return !(bLS12_381_MlResult != null ? !((Object)bLS12_381_MlResult).equals(bLS12_381_MlResult2) : bLS12_381_MlResult2 != null);
    }

    public static ByteString keccak_256$(NodeJsPlatformSpecific $this, ByteString bs) {
        return $this.keccak_256(bs);
    }

    @Override
    default public ByteString keccak_256(ByteString bs) {
        return this.toByteString(Sha3$.MODULE$.keccak_256(this.toUint8Array(bs)));
    }

    public static ByteString ripemd_160$(NodeJsPlatformSpecific $this, ByteString byteString) {
        return $this.ripemd_160(byteString);
    }

    @Override
    default public ByteString ripemd_160(ByteString byteString) {
        return this.toByteString(Ripemd160$.MODULE$.ripemd160(this.toUint8Array(byteString)));
    }

    private static Object verifyEd25519Signature$$anonfun$1(ByteString pk$1) {
        return new StringBuilder(26).append("Invalid public key length ").append(pk$1.length()).toString();
    }

    private static Object verifyEd25519Signature$$anonfun$2(ByteString sig$1) {
        return new StringBuilder(25).append("Invalid signature length ").append(sig$1.length()).toString();
    }

    private static Object verifyEcdsaSecp256k1Signature$$anonfun$1(ByteString pk$2) {
        return new StringBuilder(39).append("Invalid public key length ").append(pk$2.length()).append(", expected 33").toString();
    }

    private static Object verifyEcdsaSecp256k1Signature$$anonfun$2(ByteString pk$3) {
        return new StringBuilder(19).append("Invalid public key ").append(pk$3).toString();
    }

    private static Object verifyEcdsaSecp256k1Signature$$anonfun$3(ByteString msg$1) {
        return new StringBuilder(36).append("Invalid message length ").append(msg$1.length()).append(", expected 32").toString();
    }

    private static Object verifyEcdsaSecp256k1Signature$$anonfun$4(ByteString sig$2) {
        return new StringBuilder(38).append("Invalid signature length ").append(sig$2.length()).append(", expected 64").toString();
    }

    private static Object verifySchnorrSecp256k1Signature$$anonfun$1(ByteString pk$4) {
        return new StringBuilder(39).append("Invalid public key length ").append(pk$4.length()).append(", expected 33").toString();
    }

    private static Object verifySchnorrSecp256k1Signature$$anonfun$2(ByteString pk$5) {
        return new StringBuilder(19).append("Invalid public key ").append(pk$5).toString();
    }

    private static Object verifySchnorrSecp256k1Signature$$anonfun$3(ByteString msg$2) {
        return new StringBuilder(36).append("Invalid message length ").append(msg$2.length()).append(", expected 32").toString();
    }

    private static Object verifySchnorrSecp256k1Signature$$anonfun$4(ByteString sig$3) {
        return new StringBuilder(38).append("Invalid signature length ").append(sig$3.length()).append(", expected 64").toString();
    }
}

