/*
 * Decompiled with CFR 0.152.
 */
package scalus.builtin;

import scala.math.BigInt;
import scalus.builtin.BLS;
import scalus.builtin.BLS12_381_G1_Element$;
import scalus.builtin.ByteString;
import scalus.builtin.NodeJsPlatformSpecific$;
import scalus.builtin.PlatformSpecific$;

public class BLS12_381_G1_Element {
    private final BLS.G1.Point point;

    public static BLS12_381_G1_Element fromCompressedByteString(ByteString byteString) {
        return BLS12_381_G1_Element$.MODULE$.fromCompressedByteString(byteString);
    }

    public static BLS12_381_G1_Element hashToGroup(ByteString byteString, ByteString byteString2) {
        return BLS12_381_G1_Element$.MODULE$.hashToGroup(byteString, byteString2);
    }

    public static BLS12_381_G1_Element zero() {
        return BLS12_381_G1_Element$.MODULE$.zero();
    }

    public BLS12_381_G1_Element(BLS.G1.Point point) {
        this.point = point;
    }

    public BLS.G1.Point point() {
        return this.point;
    }

    public ByteString toCompressedByteString() {
        return NodeJsPlatformSpecific$.MODULE$.toByteString(this.point().toRawBytes(this.point().toRawBytes$default$1()));
    }

    public BLS12_381_G1_Element add(BLS12_381_G1_Element that) {
        return new BLS12_381_G1_Element(this.point().add(that.point()));
    }

    public BLS12_381_G1_Element multiply(BigInt scalar) {
        BigInt modScalar = scalar.$percent(PlatformSpecific$.MODULE$.bls12_381_scalar_period());
        int signum = modScalar.signum();
        if (signum > 0) {
            return new BLS12_381_G1_Element(this.point().multiply(NodeJsPlatformSpecific$.MODULE$.toJsBigInt(modScalar)));
        }
        if (signum < 0) {
            return new BLS12_381_G1_Element(this.point().multiply(NodeJsPlatformSpecific$.MODULE$.toJsBigInt(modScalar.abs())).negate());
        }
        return BLS12_381_G1_Element$.MODULE$.zero();
    }

    public BLS12_381_G1_Element negate() {
        return new BLS12_381_G1_Element(this.point().negate());
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof BLS12_381_G1_Element) {
            BLS12_381_G1_Element that2 = (BLS12_381_G1_Element)object;
            return this.point().isEquals(that2.point());
        }
        return false;
    }

    public int hashCode() {
        return this.toCompressedByteString().hashCode();
    }

    public String toString() {
        return new StringBuilder(2).append("0x").append(this.point().toHex(this.point().toHex$default$1())).toString();
    }
}

