/*
 * Decompiled with CFR 0.152.
 */
package scalus.uplc;

import io.bullet.borer.DataItem$;
import io.bullet.borer.Decoder;
import io.bullet.borer.Decoder$;
import io.bullet.borer.InputReader;
import io.bullet.borer.Reader;
import io.bullet.borer.Tag;
import io.bullet.borer.encodings.BaseEncoding;
import io.bullet.borer.encodings.BaseEncoding$;
import java.math.BigInteger;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.package$;
import scalus.builtins.ByteString$;
import scalus.uplc.Data;
import scalus.uplc.Data$B$;
import scalus.uplc.Data$Constr$;
import scalus.uplc.Data$I$;
import scalus.uplc.Data$List$;
import scalus.uplc.Data$Map$;

public final class PlutusDataCborDecoder$
implements Decoder<Data> {
    public static final PlutusDataCborDecoder$ MODULE$ = new PlutusDataCborDecoder$();

    private PlutusDataCborDecoder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PlutusDataCborDecoder$.class);
    }

    public Data read(InputReader<? extends Reader.Config> r) {
        Data data;
        PlutusDataCborDecoder$ selfDecoder = this;
        int maxCborByteArraySize = 64;
        int n = r.dataItem();
        switch (n) {
            case 8: 
            case 16: 
            case 32: {
                data = Data$I$.MODULE$.apply((BigInt)Decoder$.MODULE$.forBigInt().read(r));
                break;
            }
            case 262144: {
                data = Data$Map$.MODULE$.apply((List<Tuple2<Data, Data>>)((IterableOnceOps)Decoder$.MODULE$.forMap((Decoder)selfDecoder, (Decoder)selfDecoder).read(r)).toList());
                break;
            }
            case 65536: 
            case 131072: {
                data = Data$List$.MODULE$.apply((List<Data>)Predef$.MODULE$.wrapRefArray((Object[])Decoder$.MODULE$.forArray(ClassTag$.MODULE$.apply(Data.class), (Decoder)selfDecoder).read(r)).toList());
                break;
            }
            case 16384: {
                data = Data$B$.MODULE$.apply(ByteString$.MODULE$.unsafeFromArray((byte[])Decoder$.MODULE$.forByteArray((BaseEncoding)BaseEncoding$.MODULE$.base16()).read(r)));
                break;
            }
            case 0x200000: {
                Tag tag = r.readTag();
                if (tag instanceof Tag.Other) {
                    Tag.Other other = Tag.Other$.MODULE$.unapply((Tag.Other)tag);
                    long l = other._1();
                    if (102L == l) {
                        long len = r.readArrayHeader();
                        long i = r.readLong();
                        Object[] args = (Data[])Decoder$.MODULE$.forArray(ClassTag$.MODULE$.apply(Data.class), (Decoder)selfDecoder).read(r);
                        data = Data$Constr$.MODULE$.apply(i, (List<Data>)Predef$.MODULE$.wrapRefArray(args).toList());
                        break;
                    }
                    long value = l;
                    if (121L <= value && value < 128L) {
                        data = Data$Constr$.MODULE$.apply(value - 121L, (List<Data>)Predef$.MODULE$.wrapRefArray((Object[])Decoder$.MODULE$.forArray(ClassTag$.MODULE$.apply(Data.class), (Decoder)selfDecoder).read(r)).toList());
                        break;
                    }
                    long value2 = l;
                    if (1280L <= value2 && value2 < 1401L) {
                        data = Data$Constr$.MODULE$.apply(value2 - 1280L + 7L, (List<Data>)Predef$.MODULE$.wrapRefArray((Object[])Decoder$.MODULE$.forArray(ClassTag$.MODULE$.apply(Data.class), (Decoder)selfDecoder).read(r)).toList());
                        break;
                    }
                }
                if (Tag.PositiveBigNum$.MODULE$.equals(tag)) {
                    data = Data$I$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(this.fromByteArray$1(r, maxCborByteArraySize)));
                    break;
                }
                if (Tag.NegativeBigNum$.MODULE$.equals(tag)) {
                    data = Data$I$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(this.fromByteArray$1(r, maxCborByteArraySize).not()));
                    break;
                }
                throw package$.MODULE$.error("Unsupported");
            }
            default: {
                int i = n;
                throw package$.MODULE$.error(new StringBuilder(23).append("Unsupported data item ").append(i).append(" ").append(DataItem$.MODULE$.stringify(i)).toString());
            }
        }
        return data;
    }

    private final BigInteger fromByteArray$1(InputReader r$1, int maxCborByteArraySize$1) {
        byte[] byteArray = r$1.readByteArray();
        if (byteArray.length > maxCborByteArraySize$1) {
            throw r$1.overflow(new StringBuilder(78).append("ByteArray for decoding JBigInteger is longer than the configured max of ").append(maxCborByteArraySize$1).append(" bytes").toString());
        }
        return new BigInteger(1, byteArray);
    }
}

