/*
 * Decompiled with CFR 0.152.
 */
package scala.scalanative.testinterface.adapter;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Executor;
import sbt.testing.Framework;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.scalanative.build.Logger;
import scala.scalanative.testinterface.NativeRunnerRPC;
import scala.scalanative.testinterface.adapter.FrameworkAdapter;
import scala.scalanative.testinterface.adapter.TestAdapter$Config$;
import scala.scalanative.testinterface.adapter.package$;
import scala.scalanative.testinterface.adapter.package$AwaitFuture$;
import scala.scalanative.testinterface.common.FrameworkInfo;
import scala.scalanative.testinterface.common.NativeEndpoints$;
import scala.scalanative.testinterface.common.RPCCore;
import scala.scalanative.testinterface.common.RunMuxRPC;

public final class TestAdapter {
    private final Config config;
    private final TrieMap<Object, ManagedRunner> runners;
    private boolean closed;
    private int nextRunID;
    private Set<Object> runs;
    private final ExecutionContext executionContext;

    public TestAdapter(Config config) {
        this.config = config;
        Predef$.MODULE$.require(config.binaryFile().exists(), TestAdapter::$init$$$anonfun$1);
        this.runners = TrieMap$.MODULE$.empty();
        this.closed = false;
        this.nextRunID = 0;
        this.runs = Predef$.MODULE$.Set().empty();
        this.executionContext = ExecutionContext$.MODULE$.fromExecutor((Executor)ExecutionContext$.MODULE$.global(), (Function1)(JProcedure1 & Serializable)cause -> this.reportFailure((Throwable)cause));
    }

    public List<Option<Framework>> loadFrameworks(List<List<String>> frameworkNames) {
        Future future = package$.MODULE$.AwaitFuture(this.getRunnerForThread().com().call(NativeEndpoints$.MODULE$.detectFrameworks(), frameworkNames).map((Function1 & Serializable)_$1 -> _$1.map((Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)info -> new FrameworkAdapter((FrameworkInfo)info, this))), this.executionContext));
        return (List)package$AwaitFuture$.MODULE$.await$extension(future);
    }

    public void close() {
        TestAdapter testAdapter = this;
        synchronized (testAdapter) {
            String runInfo = this.runs.isEmpty() ? "All runs have completed." : new StringBuilder(17).append("Incomplete runs: ").append(this.runs).toString();
            String msg = new StringBuilder(32).append("TestAdapter.close() was called. ").append(runInfo).toString();
            if (this.runs.nonEmpty()) {
                this.config.logger().warn(msg);
            }
            IllegalStateException cause = new IllegalStateException(msg);
            this.stopEverything(cause);
        }
    }

    private void reportFailure(Throwable cause) {
        String msg = "Fatal failure in tests execution. Aborting all test runs.";
        AssertionError error = new AssertionError(msg, cause);
        this.config.logger().error(msg);
        this.config.logger().trace((Throwable)((Object)error));
        this.stopEverything((Throwable)((Object)error));
    }

    private void stopEverything(Throwable cause) {
        TestAdapter testAdapter = this;
        synchronized (testAdapter) {
            BoxedUnit boxedUnit;
            if (!this.closed) {
                this.closed = true;
                this.runners.values().foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.com().close(cause));
                this.runners.clear();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public int runStarting() {
        void var2_3;
        TestAdapter testAdapter = this;
        synchronized (testAdapter) {
            void var3_2;
            Predef$.MODULE$.require(!this.closed, TestAdapter::runStarting$$anonfun$1);
            int runID = this.nextRunID++;
            this.runs = (Set)this.runs.$plus((Object)BoxesRunTime.boxToInteger((int)runID));
            var2_3 = var3_2;
        }
        return (int)var2_3;
    }

    public void runDone(int runID) {
        TestAdapter testAdapter = this;
        synchronized (testAdapter) {
            Predef$.MODULE$.require(this.runs.contains((Object)BoxesRunTime.boxToInteger((int)runID)), () -> TestAdapter.runDone$$anonfun$1(runID));
            this.runs = (Set)this.runs.$minus((Object)BoxesRunTime.boxToInteger((int)runID));
        }
    }

    public ManagedRunner getRunnerForThread() {
        long threadId = Thread.currentThread().getId();
        return (ManagedRunner)this.runners.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)threadId), () -> this.getRunnerForThread$$anonfun$1(threadId));
    }

    private ManagedRunner startManagedRunner(long threadId) {
        ManagedRunner managedRunner;
        TestAdapter testAdapter = this;
        synchronized (testAdapter) {
            Predef$.MODULE$.require(!this.closed, TestAdapter::startManagedRunner$$anonfun$1);
            NativeRunnerRPC com = new NativeRunnerRPC(this.config.binaryFile(), this.config.envVars(), (Seq<String>)((Seq)scala.package$.MODULE$.Seq().empty()), this.config.logger(), this.executionContext);
            RunMuxRPC mux = new RunMuxRPC(com);
            managedRunner = new ManagedRunner(threadId, com, mux);
        }
        return managedRunner;
    }

    private static final String $init$$$anonfun$1() {
        return "Attempted to create a TestAdapter with non existing binary file. ";
    }

    private static final String runStarting$$anonfun$1() {
        return "We are closed. Cannot create new run.";
    }

    private static final String runDone$$anonfun$1(int runID$1) {
        return new StringBuilder(32).append("Tried to remove nonexistent run ").append(runID$1).toString();
    }

    private final ManagedRunner getRunnerForThread$$anonfun$1(long threadId$1) {
        return this.startManagedRunner(threadId$1);
    }

    private static final String startManagedRunner$$anonfun$1() {
        return "We are closed. Cannot create new runner.";
    }

    public static interface Config {
        public static Config apply() {
            return TestAdapter$Config$.MODULE$.apply();
        }

        public static int ordinal(Config config) {
            return TestAdapter$Config$.MODULE$.ordinal(config);
        }

        public File binaryFile();

        public Map<String, String> envVars();

        public Logger logger();

        public Config withEnvVars(Map<String, String> var1);

        public Config withBinaryFile(File var1);

        public Config withLogger(Logger var1);
    }

    public static final class ManagedRunner {
        private final long id;
        private final RPCCore com;
        private final RunMuxRPC mux;

        public ManagedRunner(long id, RPCCore com, RunMuxRPC mux) {
            this.id = id;
            this.com = com;
            this.mux = mux;
        }

        public long id() {
            return this.id;
        }

        public RPCCore com() {
            return this.com;
        }

        public RunMuxRPC mux() {
            return this.mux;
        }
    }
}

