/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.rxjava3.rxexpectation.internal;

import java.util.Collection;
import org.saynotobugs.confidence.Assessment;
import org.saynotobugs.confidence.Description;
import org.saynotobugs.confidence.Quality;
import org.saynotobugs.confidence.assessment.FailPrepended;
import org.saynotobugs.confidence.description.NumberDescription;
import org.saynotobugs.confidence.description.Spaced;
import org.saynotobugs.confidence.description.Text;
import org.saynotobugs.confidence.rxjava3.RxTestAdapter;

public final class Emits<T>
implements Quality<RxTestAdapter<T>> {
    private final int mEmissionCount;
    private final Quality<? super Iterable<T>> mEmissionQualities;

    public Emits(int emissionCount, Quality<? super Iterable<T>> emissionQualities) {
        this.mEmissionCount = emissionCount;
        this.mEmissionQualities = emissionQualities;
    }

    public Assessment assessmentOf(RxTestAdapter<T> candidate) {
        candidate.awaitNext(this.mEmissionCount);
        Collection<T> values = candidate.newValues(this.mEmissionCount);
        Assessment result = this.mEmissionQualities.assessmentOf(values);
        if (result.isSuccess()) {
            candidate.ack(values.size());
        }
        return new FailPrepended((Description)new Spaced(new Description[]{new Text((CharSequence)"emitted"), new NumberDescription((Number)values.size()), new Text((CharSequence)"items that")}), result);
    }

    public Description description() {
        return new Spaced(new Description[]{new Text((CharSequence)"emits"), new NumberDescription((Number)this.mEmissionCount), new Text((CharSequence)"items that"), this.mEmissionQualities.description()});
    }
}

