/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.rxjava3.rxexpectation;

import io.reactivex.rxjava3.schedulers.TestScheduler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.saynotobugs.confidence.Assessment;
import org.saynotobugs.confidence.Description;
import org.saynotobugs.confidence.Quality;
import org.saynotobugs.confidence.assessment.FailPrepended;
import org.saynotobugs.confidence.description.Spaced;
import org.saynotobugs.confidence.description.Text;
import org.saynotobugs.confidence.rxjava3.RxExpectation;
import org.saynotobugs.confidence.rxjava3.RxTestAdapter;

public final class Within<T>
implements RxExpectation<T> {
    private final Duration mDuration;
    private final RxExpectation<T> mDelegate;

    public Within(Duration duration, RxExpectation<T> delegate) {
        if (duration.isNegative()) {
            throw new IllegalArgumentException("Unsupported negative duration: " + duration);
        }
        this.mDuration = duration;
        this.mDelegate = delegate;
    }

    @Override
    public Quality<RxTestAdapter<T>> quality(final TestScheduler scheduler) {
        final Quality<RxTestAdapter<T>> delegate = this.mDelegate.quality(scheduler);
        return new Quality<RxTestAdapter<T>>(){

            public Assessment assessmentOf(RxTestAdapter<T> candidate) {
                scheduler.advanceTimeBy(Within.this.mDuration.toMillis(), TimeUnit.MILLISECONDS);
                scheduler.triggerActions();
                return new FailPrepended((Description)new Text((CharSequence)("after " + Within.this.mDuration)), delegate.assessmentOf(candidate));
            }

            public Description description() {
                return new Spaced(new Description[]{new Text((CharSequence)("after " + Within.this.mDuration)), delegate.description()});
            }
        };
    }
}

