/*
 * Decompiled with CFR 0.152.
 */
package org.saatsch.framework.base.swt.widgets.logintercept;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import org.saatsch.framework.base.swt.widgets.logintercept.Appending;
import org.saatsch.framework.base.swt.widgets.logintercept.LogInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogInterceptorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LogInterceptorFactory.class);

    public static void initLogging(Appending appending) {
        try {
            LogInterceptorFactory.doInitLogging(appending);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOG.error("Error while starting LOG interceptor: ", (Throwable)e);
        }
    }

    private static void doInitLogging(Appending appending) throws NoSuchFieldException, IllegalAccessException {
        Field field;
        PrintStream origOut = System.out;
        LogInterceptor outInterceptor = new LogInterceptor((OutputStream)origOut, appending);
        Class<?> clazz = LOG.getClass();
        if (null != clazz && null != (field = clazz.getDeclaredField("TARGET_STREAM"))) {
            field.setAccessible(true);
            field.set(null, outInterceptor);
        }
        System.setOut(outInterceptor);
    }
}

