/*
 * Decompiled with CFR 0.152.
 */
package org.saatsch.framework.base.swt.widgets.logintercept;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.SWTResourceManager;

public class LogComposite
extends Composite {
    private static final String WARN = "WARN";
    private static final String ERROR = "ERROR";
    private static final Color ORANGE = new Color((Device)Display.getDefault(), 255, 128, 0);
    private StyledText text;

    public LogComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout(256));
        this.text = new StyledText((Composite)this, 2818);
        this.text.setFont(SWTResourceManager.getFont("Courier New", 8, 0));
    }

    public void append(String s) {
        Display.getDefault().asyncExec(() -> {
            int oldCount = 0;
            if (this.shouldColorize(s)) {
                oldCount = this.text.getCharCount();
            }
            this.text.append(s + "\n");
            this.text.setTopIndex(this.text.getLineCount() - 5);
            if (this.shouldColorize(s)) {
                StyleRange style1 = new StyleRange();
                style1.start = oldCount;
                style1.length = s.length();
                style1.foreground = this.systemColor(s);
                this.text.setStyleRange(style1);
            }
        });
    }

    private boolean shouldColorize(String s) {
        return s.contains(ERROR) || s.contains(WARN);
    }

    private Color systemColor(String s) {
        if (s.contains(ERROR)) {
            return Display.getDefault().getSystemColor(3);
        }
        if (s.contains(WARN)) {
            return ORANGE;
        }
        return Display.getDefault().getSystemColor(2);
    }

    public void clear() {
        Display.getDefault().asyncExec(() -> this.text.setText(""));
    }
}

