/*
 * Decompiled with CFR 0.152.
 */
package org.saatsch.framework.base.swt.widgets;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.saatsch.framework.base.swt.DialogUtil;
import org.saatsch.framework.base.swt.Openable;

public class Loading
extends Dialog
implements Openable<Void> {
    private Shell loading;
    private Display display = this.getParent().getDisplay();
    private Runnable task;
    private Thread animateThread;
    private Image image;
    private Color shellBackground;
    private final boolean useGIFBackground = false;
    private GC shellGC;

    public Loading(Shell parent) {
        super(parent);
    }

    public Loading withTask(Runnable r) {
        this.task = r;
        return this;
    }

    @Override
    public Void open() {
        this.createContents();
        this.loading.open();
        this.loading.layout();
        this.display.asyncExec(this.task);
        while (!this.loading.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return null;
    }

    private void createContents() {
        this.loading = new Shell(this.getParent(), 65536);
        this.loading.setSize(200, 200);
        this.loading.setLayout((Layout)new FillLayout(256));
        this.fillContents();
        DialogUtil.center(this.loading, this.getParent());
    }

    private void fillContents() {
        this.shellGC = new GC((Drawable)this.loading);
        this.shellBackground = this.loading.getBackground();
        final ImageLoader loader = new ImageLoader();
        try {
            final ImageData[] imageDataArray = loader.load(this.getClass().getResourceAsStream("Rolling-1s-200px.gif"));
            if (imageDataArray.length > 1) {
                this.animateThread = new Thread("Animation"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Image offScreenImage = new Image((Device)Loading.this.display, loader.logicalScreenWidth, loader.logicalScreenHeight);
                        GC offScreenImageGC = new GC((Drawable)offScreenImage);
                        offScreenImageGC.setBackground(Loading.this.shellBackground);
                        offScreenImageGC.fillRectangle(0, 0, loader.logicalScreenWidth, loader.logicalScreenHeight);
                        try {
                            int imageDataIndex = 0;
                            ImageData imageData = imageDataArray[imageDataIndex];
                            if (Loading.this.image != null && !Loading.this.image.isDisposed()) {
                                Loading.this.image.dispose();
                            }
                            Loading.this.image = new Image((Device)Loading.this.display, imageData);
                            offScreenImageGC.drawImage(Loading.this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                            int repeatCount = loader.repeatCount;
                            while (loader.repeatCount == 0 || repeatCount > 0) {
                                switch (imageData.disposalMethod) {
                                    case 2: {
                                        Color bgColor = null;
                                        offScreenImageGC.setBackground(bgColor != null ? bgColor : Loading.this.shellBackground);
                                        offScreenImageGC.fillRectangle(imageData.x, imageData.y, imageData.width, imageData.height);
                                        if (bgColor == null) break;
                                        bgColor.dispose();
                                        break;
                                    }
                                    case 3: {
                                        offScreenImageGC.drawImage(Loading.this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                    }
                                }
                                imageDataIndex = (imageDataIndex + 1) % imageDataArray.length;
                                imageData = imageDataArray[imageDataIndex];
                                Loading.this.image.dispose();
                                Loading.this.image = new Image((Device)Loading.this.display, imageData);
                                offScreenImageGC.drawImage(Loading.this.image, 0, 0, imageData.width, imageData.height, imageData.x, imageData.y, imageData.width, imageData.height);
                                if (!offScreenImage.isDisposed() && !Loading.this.shellGC.isDisposed()) {
                                    Loading.this.shellGC.drawImage(offScreenImage, 0, 0);
                                }
                                try {
                                    int ms = imageData.delayTime * 10;
                                    if (ms < 20) {
                                        ms += 30;
                                    }
                                    if (ms < 30) {
                                        ms += 10;
                                    }
                                    Thread.sleep(ms);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (imageDataIndex != imageDataArray.length - 1) continue;
                                --repeatCount;
                            }
                        }
                        catch (SWTException ex) {
                            ex.printStackTrace();
                            System.out.println("There was an error animating the GIF");
                        }
                        finally {
                            if (offScreenImage != null && !offScreenImage.isDisposed()) {
                                offScreenImage.dispose();
                            }
                            if (offScreenImageGC != null && !offScreenImageGC.isDisposed()) {
                                offScreenImageGC.dispose();
                            }
                            if (Loading.this.image != null && !Loading.this.image.isDisposed()) {
                                Loading.this.image.dispose();
                            }
                        }
                    }
                };
                this.animateThread.setDaemon(true);
                this.animateThread.start();
            }
        }
        catch (SWTException ex) {
            System.out.println("There was an error loading the GIF");
        }
    }

    public void close() {
        this.animateThread.interrupt();
        this.image.dispose();
        this.shellGC.dispose();
        this.loading.dispose();
    }
}

