/*
 * Decompiled with CFR 0.152.
 */
package org.saatsch.framework.base.swt.textformat;

import java.util.Stack;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.saatsch.framework.base.swt.textformat.ColorFactory;
import org.saatsch.framework.base.util.Color;
import org.saatsch.framework.base.util.KeyValuePair;
import org.saatsch.framework.base.util.textformat.Format;
import org.saatsch.framework.base.util.textformat.FormattableText;

public class TextStyler {
    private Stack<Format> colorStack = new Stack();

    public void style(StyledText txtFormatted, FormattableText text) {
        txtFormatted.setText(text.getUnformatted());
        for (Format format : text.getFormats()) {
            if (!format.getTag().getName().equals("c")) continue;
            this.applyColor(txtFormatted, format);
        }
    }

    private void applyColor(StyledText txtFormatted, Format format) {
        if (format.getTag().isStart()) {
            this.openColor(format);
        } else {
            this.closeColor(txtFormatted, format);
        }
    }

    private void closeColor(StyledText txtFormatted, Format closing) {
        Format opening = this.colorStack.pop();
        StyleRange range = new StyleRange();
        range.start = opening.getOffset();
        range.length = closing.getOffset() - opening.getOffset();
        KeyValuePair keyValuePair = opening.getTag().getKeyValuePairByKey("val");
        if (null != keyValuePair) {
            range.foreground = ColorFactory.getInstance().getColor(Color.fromHexString((String)keyValuePair.getValue().toString()));
        }
        txtFormatted.setStyleRange(range);
    }

    private void openColor(Format format) {
        this.colorStack.push(format);
    }
}

