/*
 * Decompiled with CFR 0.152.
 */
package org.saatsch.framework.base.swt.safeapploop;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.saatsch.framework.base.UserException;
import org.saatsch.framework.base.swt.MessageBoxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeAppLoop {
    private static final String ERROR = "Error: ";
    private static final Logger LOG = LoggerFactory.getLogger(SafeAppLoop.class);

    private SafeAppLoop() {
    }

    public static void run(Shell shell, Display display) {
        while (!shell.isDisposed()) {
            boolean readAndDispatch = false;
            try {
                readAndDispatch = display.readAndDispatch();
            }
            catch (UserException e) {
                MessageBoxUtil.showErrorMessage("Input Error: " + e.getMessage(), shell);
                LOG.error(e.getMessage());
            }
            catch (Exception e) {
                MessageBoxUtil.showErrorMessage(ERROR + e.getMessage(), shell);
                LOG.error(ERROR, (Throwable)e);
            }
            if (readAndDispatch) continue;
            display.sleep();
        }
    }
}

