/*
 * Decompiled with CFR 0.152.
 */
package org.saatsch.framework.base.swt;

import java.awt.GraphicsEnvironment;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.saatsch.framework.base.swt.Openable;
import org.saatsch.framework.base.swt.safeapploop.SafeAppLoop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MinimalParentShell {
    private static final Logger LOG = LoggerFactory.getLogger(MinimalParentShell.class);
    protected Composite mainComposite;
    private static Shell shell;

    public Void open() {
        if (GraphicsEnvironment.isHeadless()) {
            LOG.info(this.getClass().getName() + " is skipped, because we are in headless mode.");
            return null;
        }
        Display display = Display.getDefault();
        shell = this.createContents();
        Openable dialog = this.init(shell);
        shell.open();
        shell.layout();
        if (null != dialog) {
            dialog.open();
            shell.dispose();
        } else {
            SafeAppLoop.run(shell, display);
        }
        return null;
    }

    private Shell createContents() {
        shell = new Shell();
        shell.setSize(796, 533);
        shell.setText("Minimal Parent Shell");
        shell.setLayout((Layout)new FillLayout(256));
        this.mainComposite = new Composite((Composite)shell, 0);
        this.mainComposite.setLayout((Layout)new FillLayout());
        return shell;
    }

    protected abstract Openable init(Shell var1);
}

