/*
 * Decompiled with CFR 0.152.
 */
package org.saatsch.framework.base.jface.beantree.namespaced;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.joda.beans.Bean;
import org.joda.beans.Property;
import org.saatsch.framework.base.jface.beantree.BeanTreeUtil;

public class NamespaceContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Map) {
            return ((Map)inputElement).entrySet().toArray();
        }
        if (inputElement instanceof Bean) {
            Bean b = (Bean)inputElement;
            return this.propsOf(b).toArray();
        }
        if (inputElement instanceof Collection) {
            return ((Collection)inputElement).toArray();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object element) {
        if (element instanceof Map.Entry) {
            Object value = ((Map.Entry)element).getValue();
            return this.getChildrenOfObject(value);
        }
        return this.getChildrenOfObject(element);
    }

    private Object[] getChildrenOfObject(Object value) {
        if (value instanceof Property) {
            Property property = (Property)value;
            Object propertyValue = property.get();
            if (propertyValue instanceof Bean) {
                return this.propsOf((Bean)propertyValue).toArray();
            }
            if (BeanTreeUtil.isCollection(property)) {
                return ((Collection)propertyValue).toArray();
            }
        }
        if (value instanceof Bean) {
            return this.getElements(value);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Map.Entry) {
            Object value = ((Map.Entry)element).getValue();
            return this.doesValueHaveChildren(value);
        }
        return this.doesValueHaveChildren(element);
    }

    private boolean doesValueHaveChildren(Object value) {
        if (value instanceof Property) {
            Object propertyValue = ((Property)value).get();
            if (propertyValue instanceof Bean) {
                return true;
            }
            if (this.isCollectionOfBeans((Property<Object>)((Property)value))) {
                return true;
            }
        }
        return value instanceof Bean;
    }

    private List<Property> propsOf(Bean bean) {
        ArrayList<Property> ret = new ArrayList<Property>();
        for (String name : bean.propertyNames()) {
            ret.add(bean.property(name));
        }
        return ret;
    }

    private boolean isCollectionOfBeans(Property<Object> property) {
        return BeanTreeUtil.isCollection(property) && Bean.class.isAssignableFrom(BeanTreeUtil.firstTypeArg(property.metaProperty()));
    }
}

