/*
 * Decompiled with CFR 0.152.
 */
package org.saatsch.framework.base.jface.beantree.namespaced;

import java.util.Map;
import org.eclipse.jface.viewers.LabelProvider;
import org.joda.beans.Property;
import org.saatsch.framework.base.jface.beantree.BeanTreeUtil;

public class NameProvider
extends LabelProvider {
    public String getText(Object element) {
        StringBuilder sb = new StringBuilder();
        if (element instanceof Map.Entry) {
            sb.append(((Map.Entry)element).getKey()).append(" - ");
            Object value = ((Map.Entry)element).getValue();
            sb.append(this.createText(value));
        } else {
            sb.append(this.createText(element));
        }
        return sb.toString();
    }

    private String createText(Object value) {
        if (value instanceof Property) {
            return ((Property)value).name() + this.typeStringOf((Property)value);
        }
        return "[" + value.getClass().getSimpleName() + "]";
    }

    private String typeStringOf(Property<?> prop) {
        if (BeanTreeUtil.isCollection(prop)) {
            return this.propTypeOf(prop) + this.typeArgOf(prop);
        }
        return this.propTypeOf(prop);
    }

    private String propTypeOf(Property<?> prop) {
        return " [" + prop.metaProperty().propertyType().getSimpleName() + "]";
    }

    private String typeArgOf(Property<?> prop) {
        return "<" + BeanTreeUtil.firstTypeArg(prop.metaProperty()).getSimpleName() + ">";
    }
}

