/*
 * Decompiled with CFR 0.152.
 */
package org.saatsch.framework.base.jface.beantree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.joda.beans.Bean;
import org.joda.beans.Property;
import org.saatsch.framework.base.jface.beantree.BeanTreeUtil;

public class PropertiesProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Bean) {
            Bean b = (Bean)inputElement;
            return this.propsOf(b).toArray();
        }
        if (inputElement instanceof Collection) {
            return ((Collection)inputElement).toArray();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object element) {
        if (element instanceof Property) {
            Property property = (Property)element;
            Object propertyValue = property.get();
            if (propertyValue instanceof Bean) {
                return this.propsOf((Bean)propertyValue).toArray();
            }
            if (BeanTreeUtil.isCollection(property)) {
                return ((Collection)propertyValue).toArray();
            }
        }
        if (element instanceof Bean) {
            return this.getElements(element);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Property) {
            Object propertyValue = ((Property)element).get();
            if (propertyValue instanceof Bean) {
                return true;
            }
            if (this.isCollectionOfBeans((Property<Object>)((Property)element))) {
                return true;
            }
        }
        return element instanceof Bean;
    }

    private List<Property> propsOf(Bean bean) {
        ArrayList<Property> ret = new ArrayList<Property>();
        for (String name : bean.propertyNames()) {
            ret.add(bean.property(name));
        }
        return ret;
    }

    private boolean isCollectionOfBeans(Property<Object> property) {
        return BeanTreeUtil.isCollection(property) && Bean.class.isAssignableFrom(BeanTreeUtil.firstTypeArg(property.metaProperty()));
    }
}

