/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.dialect.Rythm;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.InvokeTemplateParser;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;

public class RenderBodyParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.RENDER_BODY;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public Token go() {
                String blank;
                Regex r0;
                Regex r = RenderBodyParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("bad @renderBody statement. Correct usage: @renderBody(params...)", new Object[0]);
                }
                String matched = r.stringMatched();
                boolean lineBreak = false;
                if (matched.startsWith("\n") || matched.endsWith("\n")) {
                    lineBreak = matched.endsWith("\n");
                    r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                this.step(matched.length());
                String paramS = r.stringMatched(3);
                InvokeTemplateParser.ParameterDeclarationList params = new InvokeTemplateParser.ParameterDeclarationList();
                InvokeTemplateParser.InvokeTagToken.parseParams(paramS, params, this.ctx());
                return new RenderBodyToken(params, this.ctx(), lineBreak);
            }
        };
    }

    @Override
    protected String patternStr() {
        return "^(\\n?[ \\t\\x0B\\f]*%s%s\\s*((?@()))\\s*)";
    }

    public static void main(String[] args) {
        Regex r = new RenderBodyParser().reg(Rythm.INSTANCE);
        if (r.search("@renderBody(ab: 1, foo.bar())")) {
            // empty if block
        }
        RenderBodyParser.p(r, 6);
    }

    private static class RenderBodyToken
    extends CodeToken {
        protected InvokeTemplateParser.ParameterDeclarationList params;
        private boolean lineBreak = false;

        RenderBodyToken(InvokeTemplateParser.ParameterDeclarationList params, IContext ctx, boolean lineBreak) {
            super("", ctx);
            this.params = params;
            this.lineBreak = lineBreak;
        }

        @Override
        public void output() {
            this.pline("{", new Object[0]);
            this.ptline("org.rythmengine.template.ITag.__ParameterList _pl = null; ", new Object[0]);
            if (!this.params.pl.isEmpty()) {
                this.ptline("_pl = new org.rythmengine.template.ITag.__ParameterList();", new Object[0]);
                for (int i = 0; i < this.params.pl.size(); ++i) {
                    InvokeTemplateParser.ParameterDeclaration pd = this.params.pl.get(i);
                    this.pt("_pl.add(\"").p(pd.nameDef == null ? "" : pd.nameDef).p("\",").p(pd.valDef).p(");");
                    this.pline();
                }
            }
            this.ptline("_pTagBody(_pl, __buffer);", new Object[0]);
            this.pline("}", new Object[0]);
            if (this.lineBreak) {
                this.pline(";\npn();\n", new Object[0]);
            }
        }
    }
}

