/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.resource;

import java.io.File;
import org.rythmengine.resource.FileResourceLoader;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.TemplateResourceBase;
import org.rythmengine.utils.IO;

public class FileTemplateResource
extends TemplateResourceBase
implements ITemplateResource {
    private static final long serialVersionUID = -3059476990432671389L;
    private File file;
    private String key;

    @Override
    protected long defCheckInterval() {
        return 5000L;
    }

    public FileTemplateResource(String path, FileResourceLoader loader) {
        super(loader);
        File f = new File(path);
        File home = loader.getRoot();
        String homePath = home.getPath();
        if (!this.isValid(f)) {
            f = new File(home, path);
        } else if (path.startsWith(homePath)) {
            path = path.substring(homePath.length());
        }
        this.file = f;
        this.key = path.replace('\\', '/');
    }

    FileTemplateResource(File file, FileResourceLoader loader) {
        super(loader);
        this.file = file;
        String path = file.getPath();
        String homePath = loader.getRoot().getPath();
        if (path.startsWith(homePath)) {
            path = path.substring(homePath.length());
        }
        this.key = path.replace('\\', '/');
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    protected boolean isValid(File file) {
        return null != file && !file.isDirectory() && file.canRead();
    }

    @Override
    public boolean isValid() {
        return this.isValid(this.file);
    }

    @Override
    protected String reload() {
        String text = IO.readContentAsString(this.file);
        return text;
    }

    @Override
    public String getSuggestedClassName() {
        return FileTemplateResource.path2CN(this.key);
    }
}

