/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.logger;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rythmengine.logger.ILogger;

public class CommonsLogger
implements ILogger {
    private static final long serialVersionUID = 1L;
    protected final Log logger;
    protected final String className;

    public CommonsLogger(Class c) {
        this.className = c.getName();
        this.logger = LogFactory.getLog((Class)c);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    private String fmt(String tmpl, Object ... args) {
        if (args.length == 0) {
            return tmpl;
        }
        return String.format(tmpl, args);
    }

    @Override
    public void trace(String msg, Object ... arg) {
        this.logger.trace((Object)this.fmt(msg, arg));
    }

    @Override
    public void trace(Throwable t, String msg, Object ... arg) {
        this.logger.trace((Object)this.fmt(msg, arg), t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg, Object ... arg) {
        this.logger.debug((Object)this.fmt(msg, arg));
    }

    @Override
    public void debug(Throwable t, String msg, Object ... arg) {
        this.logger.debug((Object)this.fmt(msg, arg), t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String msg, Object ... arg) {
        this.logger.info((Object)this.fmt(msg, arg));
    }

    @Override
    public void info(Throwable t, String msg, Object ... arg) {
        this.logger.info((Object)this.fmt(msg, arg), t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String msg, Object ... arg) {
        this.logger.warn((Object)this.fmt(msg, arg));
    }

    @Override
    public void warn(Throwable t, String msg, Object ... arg) {
        this.logger.warn((Object)this.fmt(msg, arg), t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String msg, Object ... arg) {
        this.logger.error((Object)this.fmt(msg, arg));
    }

    @Override
    public void error(Throwable t, String msg, Object ... arg) {
        this.logger.error((Object)this.fmt(msg, arg), t);
    }
}

