/**
 * Copyright (C) 2013-2016 The Rythm Engine project
 * for LICENSE and other details see:
 * https://github.com/rythmengine/rythmengine
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.*;
import org.rythmengine.internal.dialect.DialectManager;
import org.rythmengine.internal.parser.Directive;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.utils.F;
import org.rythmengine.utils.S;

import java.util.ArrayList;
import java.util.List;

public class ArgsParser extends KeywordParserFactory {

    @Override
    public Keyword keyword() {
        return Keyword.ARGS;
    }

    public IParser create(final IContext ctx) {
        return new ParserBase(ctx) {
            /*
             * parse @args {...}
             */
            public Token go2(String s) {
                Regex r = reg(dialect());
                final List<F.T4<Integer, String, String, String>> ral = new ArrayList();
                s = s.replaceAll("[\\n\\r]+", ",").replaceAll("[,]+", ",");
                int line = ctx.currentLine();
                while (r.search(s)) {
                    String type = r.stringMatched(2);
                    checkRestrictedClass(type);
                    String name = r.stringMatched(4);
                    String neu = r.stringMatched(6); // check the 'new' keyword
                    if (null == neu) neu = "";
                    String defVal = r.stringMatched(7);
                    if (null != defVal) defVal = neu + " " + defVal;
                    name = ExpressionParser.processPositionPlaceHolder(name);
                    ral.add(new F.T4(line, type, name, defVal));
                }
                return new Directive("", ctx()) {
                    @Override
                    public void call() {
                        for (F.T4<Integer, String, String, String> rd : ral) {
                            builder().addRenderArgs(rd._1, rd._2, rd._3, rd._4);
                        }
                    }
                };
            }

            /*
             * parse @args String s...
             */
            public Token go() {
                String remain = remain();
                Regex r = new Regex(String.format("\\n?[ \\t\\x0B\\f]*%s%s(\\([ \t\f]*\\))?[ \t\f]*((?@{}))\\n?", a(), keyword()));
                if (r.search(remain)) {
                    String matched = r.stringMatched();
                    if (matched.startsWith("\n") || matched.endsWith("\n")) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    }
                    String s = r.stringMatched(2);
                    s = S.strip(s, "{", "}");
                    step(matched.length());
                    return go2(s);
                }
                boolean startWithLineBreak = remain.startsWith("\n");
                if (startWithLineBreak) {
                    remain = remain.substring(1);
                }
                String space = "";
                Regex r0 = new Regex("^(\\s+).*");
                if (r0.search(remain)) {
                    space = r0.stringMatched(1);
                }
                //space = startWithLineBreak ? "\n" + space : space;
                step(space.length());
                remain = remain.replaceFirst("^\\s+", "");
                String key = String.format("%s%s ", a(), keyword());
                if (!remain.startsWith(key)) {
                    raiseParseException("No argument declaration found");
                }
                step(key.length() + (startWithLineBreak ? 1 : 0));
                remain = remain();
                r = reg(dialect());
                int step = 0;
                //final List<CodeBuilder.RenderArgDeclaration> ral = new ArrayList<CodeBuilder.RenderArgDeclaration>();
                while (r.search(remain)) {
                    String matched = r.stringMatched();
                    if (matched.startsWith("\n") || matched.startsWith("\r")) {
                        break;
                    }
                    step += matched.length();
                    String type = r.stringMatched(2);
                    checkRestrictedClass(type);
                    String name = r.stringMatched(4);
                    String neu = r.stringMatched(6); // check the 'new' keyword
                    if (null == neu) neu = "";
                    String defVal = r.stringMatched(7);
                    if (null != defVal) defVal = neu + " " + defVal;
                    name = ExpressionParser.processPositionPlaceHolder(name);
                    //ral.add(new CodeBuilder.RenderArgDeclaration(ctx().currentLine(), name, type, defVal));
                    ctx().getCodeBuilder().addRenderArgs(ctx().currentLine(), type, name, defVal);
                }
                step(step);
                // strip off the following ";" symbol and line breaks
                char c;
                while (true) {
                    c = peek();
                    if ((' ' == c || ';' == c || '\n' == c) && ctx.hasRemain()) {
                        step(1);
                        if (space.length() > 0) {
                            ctx.getCodeBuilder().addBuilder(new Token.StringToken(space, ctx));
                        }
                        if ('\n' == c && startWithLineBreak) {
                            ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                        }
                    } else {
                        break;
                    }
                }
                return new Directive("", ctx()) {
                    @Override
                    public void call() {
//                        for (CodeBuilder.RenderArgDeclaration rd: ral) {
//                            builder().addRenderArgs(rd);
//                        }
                    }
                };
            }
        };
    }

    public static List<CodeBuilder.RenderArgDeclaration> parseArgDeclaration(int lineNo, String s) {
        final List<CodeBuilder.RenderArgDeclaration> ral = new ArrayList<CodeBuilder.RenderArgDeclaration>();
        Regex r = new ArgsParser().reg(DialectManager.current());
        while (r.search(s)) {
            String matched = r.stringMatched();
            if (matched.startsWith("\n") || matched.startsWith("\r")) {
                break;
            }
            String name = r.stringMatched(4);
            String type = r.stringMatched(2);
            String defVal = r.stringMatched(5);
            name = ExpressionParser.processPositionPlaceHolder(name);
            ral.add(new CodeBuilder.RenderArgDeclaration(lineNo, type, name, defVal));
        }
        return ral;
    }

    public static final String PATTERN = "\\G[ \\t\\x0B\\f]*,?[ \\t\\x0B\\f]*(([\\sa-zA-Z_][\\w$_\\.]*(?@\\<\\>)?(\\[\\])?)[ \\t\\x0B\\f]+([@a-zA-Z_][\\w$_]*))([ \\t\\x0B\\f]*=[ \\t\\x0B\\f]*(new[ \\t\\x0B\\f]+)?((?@{})|[0-9]+[fLld]?|'[.]'|(?@\"\")|[a-zA-Z_][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*(\\.[a-zA-Z][a-zA-Z0-9_\\.]*(?@())*(?@[])*(?@())*)*))?";

    public static final String PATTERN2 = "";

    @Override
    protected String patternStr() {
        return PATTERN;
    }

    protected String patternStr0() {
        return "(%s%s([\\s,]+[a-zA-Z][a-zA-Z0-9_\\.]*(\\<[a-zA-Z][a-zA-Z0-9_\\.,]*\\>)?[\\s]+[a-zA-Z][a-zA-Z0-9_\\.]*)+(;|\\r?\\n)+).*";
    }

}
