/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.extension.IByteCodeHelper;
import org.rythmengine.internal.compiler.ClassReloadException;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.template.ITemplate;
import org.rythmengine.utils.IO;

public class TemplateClassLoader
extends ClassLoader {
    private static final ILogger logger = Logger.get(TemplateClass.class);
    private final ClassStateHashCreator classStateHashCreator = new ClassStateHashCreator();
    public TemplateClassloaderState currentState = new TemplateClassloaderState();
    public ProtectionDomain protectionDomain;
    public RythmEngine engine;
    private RythmConfiguration conf;
    private static final ThreadLocal<String> sandboxPassword = new ThreadLocal();
    private Set<String> notFoundTypes = null;
    int pathHash = 0;

    private static ClassLoader getDefParent(RythmEngine engine) {
        return (ClassLoader)engine.conf().get(RythmConfigurationKey.ENGINE_CLASS_LOADER_PARENT_IMPL);
    }

    public TemplateClassLoader(RythmEngine engine) {
        this(TemplateClassLoader.getDefParent(engine), engine);
    }

    public TemplateClassLoader(ClassLoader parent, RythmEngine engine) {
        super(parent);
        this.engine = engine;
        this.conf = engine.conf();
        for (TemplateClass tc : engine.classes().all()) {
            tc.uncompile();
        }
        this.pathHash = this.computePathHash();
    }

    public static void setSandboxPassword(String password) {
        sandboxPassword.set(password);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        if (name.contains("UrlResolver")) {
            logger.info("loading UrlResovler...", new Object[0]);
        }
        if (Rythm.insideSandbox() && this.conf.restrictedClasses().contains(name)) {
            throw new ClassNotFoundException("Access to class " + name + " is restricted in sandbox mode");
        }
        TemplateClass tc = this.engine.classes().clsNameIdx.get(name);
        if (null == tc && (c = this.findLoadedClass(name)) != null) {
            return c;
        }
        Class<?> TemplateClass2 = this.loadTemplateClass(name);
        if (TemplateClass2 != null) {
            if (resolve) {
                this.resolveClass(TemplateClass2);
            }
            return TemplateClass2;
        }
        return super.loadClass(name, resolve);
    }

    private Class<?> loadTemplateClass(String name) {
        Class<?> maybeAlreadyLoaded = this.findLoadedClass(name);
        if (maybeAlreadyLoaded != null) {
            return maybeAlreadyLoaded;
        }
        long start = System.currentTimeMillis();
        TemplateClass templateClass = this.engine.classes().getByClassName(name);
        if (templateClass != null) {
            if (templateClass.isDefinable()) {
                return templateClass.javaClass;
            }
            byte[] bc = templateClass.enhancedByteCode;
            if (!templateClass.isClass()) {
                this.definePackage(templateClass.getPackage(), null, null, null, null, null, null, null);
            } else {
                this.loadPackage(name);
            }
            if (bc != null) {
                templateClass.javaClass = this.defineClass(templateClass.name(), templateClass.enhancedByteCode, 0, templateClass.enhancedByteCode.length, this.protectionDomain);
                this.resolveClass(templateClass.javaClass);
                if (!templateClass.isClass()) {
                    templateClass.javaPackage = templateClass.javaClass.getPackage();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("%sms to load class %s from clsNameIdx", System.currentTimeMillis() - start, name);
                }
                return templateClass.javaClass;
            }
            if (templateClass.javaByteCode != null || templateClass.compile() != null) {
                templateClass.enhance();
                templateClass.javaClass = this.defineClass(templateClass.name(), templateClass.enhancedByteCode, 0, templateClass.enhancedByteCode.length, this.protectionDomain);
                this.resolveClass(templateClass.javaClass);
                if (!templateClass.isClass()) {
                    templateClass.javaPackage = templateClass.javaClass.getPackage();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("%sms to load class %s", System.currentTimeMillis() - start, name);
                }
                return templateClass.javaClass;
            }
            this.engine.classes().remove(name);
        } else {
            if (name.lastIndexOf("__R_T_C__") == -1) {
                return null;
            }
            int pos = name.indexOf("$");
            if (-1 != pos) {
                String parentCN = name.substring(0, pos);
                TemplateClass parent = this.engine.classes().getByClassName(parentCN);
                if (null == parent) {
                    throw new RuntimeException("Cannot find inner class def: " + name);
                }
                TemplateClass tc = TemplateClass.createInnerClass(name, null, parent);
                this.engine.classCache().loadTemplateClass(tc);
                byte[] bc = tc.enhancedByteCode;
                if (null == bc) {
                    while (null != parent && parent.isInner()) {
                        parent = parent.root();
                    }
                    if (null == parent) {
                        throw new RuntimeException("Unexpected: cannot find the root class of inner class: " + name);
                    }
                    parent.reset();
                    parent.refresh(true);
                    parent.compile();
                    tc = this.engine.classes().getByClassName(name);
                    Class<ITemplate> c = tc.javaClass;
                    if (null != c) {
                        return c;
                    }
                    bc = tc.enhancedByteCode;
                    if (null == bc) {
                        throw new RuntimeException("Cannot find bytecode cache for inner class: " + name);
                    }
                }
                tc.javaClass = this.defineClass(tc.name(), bc, 0, bc.length, this.protectionDomain);
                return tc.javaClass;
            }
        }
        return null;
    }

    private String getPackageName(String name) {
        int dot = name.lastIndexOf(46);
        return dot > -1 ? name.substring(0, dot) : "";
    }

    private void loadPackage(String className) {
        int symbol = className.indexOf("$");
        if (symbol > -1) {
            className = className.substring(0, symbol);
        }
        if (this.findLoadedClass(className = (symbol = className.lastIndexOf(".")) > -1 ? className.substring(0, symbol) + ".package-info" : "package-info") == null) {
            this.loadTemplateClass(className);
        }
    }

    private boolean typeNotFound(String name) {
        if (null == this.notFoundTypes) {
            this.notFoundTypes = this.engine.classes().compiler.notFoundTypes;
        }
        return this.notFoundTypes.contains(name);
    }

    private void setTypeNotFound(String name) {
        if (null == this.notFoundTypes) {
            this.notFoundTypes = this.engine.classes().compiler.notFoundTypes;
        }
        if (this.engine.isProdMode()) {
            this.notFoundTypes.add(name);
        } else if (name.matches("^(java\\.|play\\.|com\\.greenlaw110\\.).*")) {
            this.notFoundTypes.add(name);
        }
    }

    protected byte[] getClassDefinition(String name0) {
        IByteCodeHelper helper;
        if (this.typeNotFound(name0)) {
            return null;
        }
        byte[] ba = null;
        String name = name0.replace(".", "/") + ".class";
        InputStream is = this.getResourceAsStream(name);
        if (null != is) {
            try {
                int count;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                while ((count = is.read(buffer, 0, buffer.length)) > 0) {
                    os.write(buffer, 0, count);
                }
                ba = os.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (null == ba && null != (helper = this.engine.conf().byteCodeHelper())) {
            ba = helper.findByteCode(name0);
        }
        if (null == ba) {
            this.setTypeNotFound(name0);
        }
        return ba;
    }

    public void detectChange(TemplateClass tc) {
        if (this.engine.isProdMode() && null != tc.name()) {
            return;
        }
        if (!tc.refresh()) {
            return;
        }
        if (tc.compile() != null) {
            throw new ClassReloadException("Need reload");
        }
        this.engine.classes().remove(tc);
        this.currentState = new TemplateClassloaderState();
    }

    public void detectChanges() {
        if (this.engine.isProdMode()) {
            return;
        }
        ArrayList<TemplateClass> modifieds = new ArrayList<TemplateClass>();
        for (TemplateClass tc : this.engine.classes().all()) {
            if (!tc.refresh()) continue;
            modifieds.add(tc);
        }
        HashSet<TemplateClass> modifiedWithDependencies = new HashSet<TemplateClass>();
        modifiedWithDependencies.addAll(modifieds);
        ArrayList<ClassDefinition> newDefinitions = new ArrayList<ClassDefinition>();
        boolean dirtySig = false;
        for (TemplateClass tc : modifiedWithDependencies) {
            if (tc.compile() == null) {
                this.engine.classes().remove(tc);
                this.currentState = new TemplateClassloaderState();
                continue;
            }
            int sigChecksum = tc.sigChecksum;
            tc.enhance();
            if (sigChecksum != tc.sigChecksum) {
                dirtySig = true;
            }
            newDefinitions.add(new ClassDefinition(tc.javaClass, tc.enhancedByteCode));
            this.currentState = new TemplateClassloaderState();
        }
        if (!newDefinitions.isEmpty()) {
            throw new ClassReloadException("Need Reload");
        }
        if (dirtySig) {
            throw new ClassReloadException("Signature change !");
        }
        int hash = this.computePathHash();
        if (hash != this.pathHash) {
            for (TemplateClass tc : this.engine.classes().all()) {
                if (tc.templateResource.isValid()) continue;
                this.engine.classes().remove(tc);
                this.currentState = new TemplateClassloaderState();
            }
            throw new ClassReloadException("Path has changed");
        }
    }

    public int computePathHash() {
        return this.engine.isProdMode() ? 0 : this.classStateHashCreator.computePathHash(this.engine.conf().tmpDir());
    }

    public static class TemplateClassloaderState {
        private static AtomicLong nextStateValue = new AtomicLong();
        private final long currentStateValue = nextStateValue.getAndIncrement();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateClassloaderState that = (TemplateClassloaderState)o;
            return this.currentStateValue == that.currentStateValue;
        }

        public int hashCode() {
            return (int)(this.currentStateValue ^ this.currentStateValue >>> 32);
        }
    }

    public static class ClassStateHashCreator {
        private final Pattern classDefFinderPattern = Pattern.compile("\\s+class\\s([a-zA-Z0-9_]+)\\s+");
        private final Map<File, FileWithClassDefs> classDefsInFileCache = new HashMap<File, FileWithClassDefs>();

        public synchronized int computePathHash(File ... paths) {
            StringBuilder buf = new StringBuilder();
            for (File file : paths) {
                this.scan(buf, file);
            }
            return buf.toString().hashCode();
        }

        private void scan(StringBuilder buf, File current) {
            File[] fa;
            if (!current.isDirectory()) {
                if (current.getName().endsWith(".java")) {
                    buf.append(this.getClassDefsForFile(current));
                }
            } else if (!current.getName().startsWith(".") && null != (fa = current.listFiles())) {
                for (File file : current.listFiles()) {
                    this.scan(buf, file);
                }
            }
        }

        private String getClassDefsForFile(File file) {
            FileWithClassDefs fileWithClassDefs = this.classDefsInFileCache.get(file);
            if (fileWithClassDefs != null && fileWithClassDefs.fileNotChanges()) {
                return fileWithClassDefs.getClassDefs();
            }
            StringBuilder buf = new StringBuilder();
            Matcher matcher = this.classDefFinderPattern.matcher(IO.readContentAsString(file));
            buf.append(file.getName());
            buf.append("(");
            while (matcher.find()) {
                buf.append(matcher.group(1));
                buf.append(",");
            }
            buf.append(")");
            String classDefs = buf.toString();
            this.classDefsInFileCache.put(file, new FileWithClassDefs(file, classDefs));
            return classDefs;
        }

        private static class FileWithClassDefs {
            private final File file;
            private final long size;
            private final long lastModified;
            private final String classDefs;

            private FileWithClassDefs(File file, String classDefs) {
                this.file = file;
                this.classDefs = classDefs;
                this.size = file.length();
                this.lastModified = file.lastModified();
            }

            public boolean fileNotChanges() {
                return this.size == this.file.length() && this.lastModified == this.file.lastModified();
            }

            public String getClassDefs() {
                return this.classDefs;
            }
        }
    }
}

