/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.conf;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.GAEDetector;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.extension.IByteCodeEnhancer;
import org.rythmengine.extension.IByteCodeHelper;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.IDurationParser;
import org.rythmengine.extension.II18nMessageResolver;
import org.rythmengine.extension.ISourceCodeEnhancer;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.utils.RawData;

public class RythmConfiguration {
    private Map<String, Object> raw;
    private Map<RythmConfigurationKey, Object> data;
    private RythmEngine engine;
    private String _pluginVersion = null;
    private IByteCodeHelper _byteCodeHelper = null;
    private Boolean _play = null;
    private Boolean _logRenderTime = null;
    private Boolean _loadPrecompiled = null;
    private Boolean _precompileMode = null;
    private Boolean _disableFileWrite = null;
    private Boolean _gae = null;
    private Set<String> _restrictedClasses = null;
    private Boolean _enableTypeInference = null;
    private Boolean _smartEscapeEnabled = null;
    private Boolean _naturalTemplateEnabled = null;
    private Boolean _debugJavaSourceEnabled = null;
    private Boolean _cacheEnabled = null;
    private Boolean _transformEnabled = null;
    private Boolean _compactEnabled = null;
    private IDurationParser _durationParser = null;
    private ICodeType _defaultCodeType = null;
    private File _tmpDir = null;
    private List<URI> _templateHome = null;
    private IByteCodeEnhancer _byteCodeEnhancer = IByteCodeEnhancer.INSTS.NULL;
    private ISourceCodeEnhancer _srcEnhancer = null;
    private Locale _locale = null;
    private List<String> _messageSources = null;
    private II18nMessageResolver _i18n = null;
    private String _suffix = null;
    private Integer _resourceRefreshInterval = null;
    private Boolean _autoScan = null;
    private String _allowedSysProps = null;
    private Boolean _sandboxTmpIO = null;
    private Boolean _hasGlobalInclude = null;
    public static final RythmConfiguration EMPTY_CONF = new RythmConfiguration(Collections.emptyMap(), null);
    private static final ILogger logger = Logger.get(RythmConfiguration.class);

    public RythmConfiguration(Map<String, ?> configuration, RythmEngine engine) {
        this.raw = new HashMap(configuration);
        this.data = new HashMap<RythmConfigurationKey, Object>(configuration.size());
        this.engine = engine;
    }

    public <T> T get(RythmConfigurationKey key) {
        Object o = this.data.get((Object)key);
        if (null == o) {
            o = key.getConfiguration(this.raw);
            if (null != o) {
                this.data.put(key, o);
            } else {
                this.data.put(key, RawData.NULL);
            }
        }
        if (o == RawData.NULL) {
            return null;
        }
        return (T)o;
    }

    public <T> List<T> getList(RythmConfigurationKey key, Class<T> c) {
        Object o = this.data.get((Object)key);
        if (null == o) {
            List<T> l = RythmConfigurationKey.getImplList(key.getKey(), this.raw, c);
            this.data.put(key, l);
            return l;
        }
        return (List)o;
    }

    public <T> T get(String key) {
        RythmConfigurationKey rk;
        if (key.startsWith("rythm.")) {
            key = key.replaceFirst("rythm.", "");
        }
        if (null != (rk = RythmConfigurationKey.valueOfIgnoreCase(key))) {
            return this.get(rk);
        }
        return (T)this.raw.get(key);
    }

    public String pluginVersion() {
        if (null == this._pluginVersion) {
            this._pluginVersion = (String)this.get(RythmConfigurationKey.ENGINE_PLUGIN_VERSION);
        }
        return this._pluginVersion;
    }

    public IByteCodeHelper byteCodeHelper() {
        if (null == this._byteCodeHelper) {
            this._byteCodeHelper = (IByteCodeHelper)this.get(RythmConfigurationKey.ENGINE_CLASS_LOADER_BYTE_CODE_HELPER_IMPL);
        }
        return this._byteCodeHelper;
    }

    public boolean playFramework() {
        if (null == this._play) {
            this._play = (Boolean)this.get(RythmConfigurationKey.ENGINE_PLAYFRAMEWORK);
        }
        return this._play;
    }

    public boolean logRenderTime() {
        if (null == this._logRenderTime) {
            this._logRenderTime = (Boolean)this.get(RythmConfigurationKey.LOG_TIME_RENDER_ENABLED);
        }
        return this._logRenderTime;
    }

    public boolean loadPrecompiled() {
        if (null == this._loadPrecompiled) {
            Boolean b = (Boolean)this.get(RythmConfigurationKey.ENGINE_LOAD_PRECOMPILED_ENABLED);
            this._loadPrecompiled = b != false || this.gae();
        }
        return this._loadPrecompiled;
    }

    public boolean precompileMode() {
        if (null == this._precompileMode) {
            this._precompileMode = (Boolean)this.get(RythmConfigurationKey.ENGINE_PRECOMPILE_MODE);
        }
        return this._precompileMode;
    }

    public boolean disableFileWrite() {
        if (null == this._disableFileWrite) {
            boolean b = (Boolean)this.get(RythmConfigurationKey.ENGINE_FILE_WRITE_ENABLED);
            b = b && !this.gae();
            this._disableFileWrite = !b;
        }
        return this._disableFileWrite;
    }

    private static boolean isGaeSdkInClasspath() {
        try {
            Class.forName("com.google.appengine.api.LifecycleManager");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean gae() {
        if (null == this._gae) {
            boolean b = RythmConfiguration.isGaeSdkInClasspath();
            if (b) {
                try {
                    Class<?> clz = Class.forName("org.rythmengine.conf.GAEDetectorImpl");
                    GAEDetector detector = (GAEDetector)clz.newInstance();
                    b = detector.isInGaeCloud();
                }
                catch (Throwable t) {
                    logger.warn(t, "error detecting gae environment", new Object[0]);
                    b = false;
                }
            }
            this._gae = b;
        }
        return this._gae;
    }

    public Set<String> restrictedClasses() {
        if (null == this._restrictedClasses) {
            String s = (String)this.get(RythmConfigurationKey.SANDBOX_RESTRICTED_CLASS);
            s = s + ";org.rythmengine.Rythm;RythmEngine;RythmSecurityManager,java.io;java.nio;java.security;java.rmi;java.net;java.awt;java.applet";
            this._restrictedClasses = new HashSet<String>();
            for (String cls : Arrays.asList(s.split(";"))) {
                if ("".equals(cls = cls.trim())) continue;
                this._restrictedClasses.add(cls);
            }
        }
        return new HashSet<String>(this._restrictedClasses);
    }

    public boolean typeInferenceEnabled() {
        if (null == this._enableTypeInference) {
            this._enableTypeInference = (Boolean)this.get(RythmConfigurationKey.FEATURE_TYPE_INFERENCE_ENABLED);
        }
        return this._enableTypeInference;
    }

    public boolean smartEscapeEnabled() {
        if (null == this._smartEscapeEnabled) {
            this._smartEscapeEnabled = (Boolean)this.get(RythmConfigurationKey.FEATURE_SMART_ESCAPE_ENABLED);
        }
        return this._smartEscapeEnabled;
    }

    public boolean naturalTemplateEnabled() {
        if (null == this._naturalTemplateEnabled) {
            this._naturalTemplateEnabled = (Boolean)this.get(RythmConfigurationKey.FEATURE_NATURAL_TEMPLATE_ENABLED);
        }
        return this._naturalTemplateEnabled;
    }

    public boolean debugJavaSourceEnabled() {
        if (null == this._debugJavaSourceEnabled) {
            this._debugJavaSourceEnabled = (Boolean)this.get(RythmConfigurationKey.ENGINE_OUTPUT_JAVA_SOURCE_ENABLED);
        }
        return this._debugJavaSourceEnabled;
    }

    public boolean cacheEnabled() {
        if (this == EMPTY_CONF) {
            return false;
        }
        if (null == this._cacheEnabled) {
            Boolean po;
            Boolean ce = (Boolean)this.get(RythmConfigurationKey.CACHE_ENABLED);
            this._cacheEnabled = ce == false ? Boolean.valueOf(false) : (this.engine.isProdMode() ? Boolean.valueOf(true) : Boolean.valueOf((po = (Boolean)this.get(RythmConfigurationKey.CACHE_PROD_ONLY_ENABLED)) == false));
        }
        return this._cacheEnabled;
    }

    public boolean cacheDisabled() {
        return !this.cacheEnabled();
    }

    public boolean transformEnabled() {
        if (null == this._transformEnabled) {
            this._transformEnabled = (Boolean)this.get(RythmConfigurationKey.FEATURE_TRANSFORM_ENABLED);
        }
        return this._transformEnabled;
    }

    public boolean compactModeEnabled() {
        if (null == this._compactEnabled) {
            this._compactEnabled = (Boolean)this.get(RythmConfigurationKey.CODEGEN_COMPACT_ENABLED);
        }
        return this._compactEnabled;
    }

    public IDurationParser durationParser() {
        if (null == this._durationParser) {
            this._durationParser = (IDurationParser)this.get(RythmConfigurationKey.CACHE_DURATION_PARSER_IMPL);
        }
        return this._durationParser;
    }

    public ICodeType defaultCodeType() {
        if (null == this._defaultCodeType) {
            this._defaultCodeType = (ICodeType)this.get(RythmConfigurationKey.DEFAULT_CODE_TYPE_IMPL);
        }
        return this._defaultCodeType;
    }

    public File tmpDir() {
        if (null == this._tmpDir) {
            URI uri = (URI)this.get(RythmConfigurationKey.HOME_TMP);
            this._tmpDir = new File(uri.getPath());
        }
        return this._tmpDir;
    }

    public List<URI> templateHome() {
        if (null == this._templateHome) {
            Object o = this.get(RythmConfigurationKey.HOME_TEMPLATE);
            if (o instanceof URI) {
                this._templateHome = Arrays.asList((URI)o);
            } else if (o instanceof List) {
                this._templateHome = (List)o;
            } else if (o instanceof File) {
                File root = (File)o;
                this._templateHome = Arrays.asList(root.toURI());
            }
        }
        return this._templateHome;
    }

    public void setTemplateHome(File home) {
        this.raw.put(RythmConfigurationKey.HOME_TEMPLATE.getKey(), home);
        this.data.put(RythmConfigurationKey.HOME_TEMPLATE, home);
    }

    public IByteCodeEnhancer byteCodeEnhancer() {
        if (IByteCodeEnhancer.INSTS.NULL == this._byteCodeEnhancer) {
            this._byteCodeEnhancer = (IByteCodeEnhancer)this.get(RythmConfigurationKey.CODEGEN_BYTE_CODE_ENHANCER);
        }
        return this._byteCodeEnhancer;
    }

    public ISourceCodeEnhancer sourceEnhancer() {
        if (null == this._srcEnhancer) {
            this._srcEnhancer = (ISourceCodeEnhancer)this.get(RythmConfigurationKey.CODEGEN_SOURCE_CODE_ENHANCER);
        }
        return this._srcEnhancer;
    }

    public Locale locale() {
        if (null == this._locale) {
            this._locale = (Locale)this.get(RythmConfigurationKey.I18N_LOCALE);
        }
        return this._locale;
    }

    public List<String> messageSources() {
        if (null == this._messageSources) {
            this._messageSources = Arrays.asList(this.get(RythmConfigurationKey.I18N_MESSAGE_SOURCES).toString().split("[, \\t]+"));
        }
        return this._messageSources;
    }

    public II18nMessageResolver i18nMessageResolver() {
        if (null == this._i18n) {
            this._i18n = (II18nMessageResolver)this.get(RythmConfigurationKey.I18N_MESSAGE_RESOLVER);
        }
        return this._i18n;
    }

    public String resourceNameSuffix() {
        if (null == this._suffix) {
            this._suffix = (String)this.get(RythmConfigurationKey.RESOURCE_NAME_SUFFIX);
        }
        return this._suffix;
    }

    public long resourceRefreshInterval() {
        if (null == this._resourceRefreshInterval) {
            this._resourceRefreshInterval = (Integer)this.get(RythmConfigurationKey.RESOURCE_REFRESH_INTERVAL);
        }
        return this._resourceRefreshInterval.longValue();
    }

    public boolean autoScan() {
        if (null == this._autoScan) {
            this._autoScan = (Boolean)this.get(RythmConfigurationKey.RESOURCE_AUTO_SCAN);
        }
        return this._autoScan;
    }

    public String allowedSystemProperties() {
        if (null == this._allowedSysProps) {
            this._allowedSysProps = (String)this.get(RythmConfigurationKey.SANDBOX_ALLOWED_SYSTEM_PROPERTIES);
        }
        return this._allowedSysProps;
    }

    public boolean sandboxTmpIO() {
        if (null == this._sandboxTmpIO) {
            this._sandboxTmpIO = (Boolean)this.get(RythmConfigurationKey.SANDBOX_TEMP_IO_ENABLED);
        }
        return this._sandboxTmpIO;
    }

    public boolean hasGlobalInclude() {
        RythmConfiguration rythmConfiguration = this;
        if (rythmConfiguration.engine.insideSandbox()) {
            return false;
        }
        if (null == this._hasGlobalInclude) {
            ITemplateResource rsrc = this.engine.resourceManager().getResource("__global.rythm");
            this._hasGlobalInclude = rsrc.isValid();
        }
        return this._hasGlobalInclude;
    }

    public static RythmConfiguration get() {
        RythmEngine engine = RythmEngine.get();
        return null != engine ? engine.conf() : EMPTY_CONF;
    }

    public void debug() {
        logger.info("start to dump rythm configuration >>>", new Object[0]);
        for (RythmConfigurationKey k : RythmConfigurationKey.values()) {
            logger.info("%s: %s", new Object[]{k, this.get(k)});
        }
        logger.info("end dumping rythm configuration <<<", new Object[0]);
    }
}

