/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.utils;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.internal.CacheKey;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.template.ITemplate;

public class I18N {
    private static final ILogger logger = Logger.get(I18N.class);
    private static final Map<String, ResourceBundle> bundleCache = new HashMap<String, ResourceBundle>();

    public static Locale locale(ITemplate template) {
        if (null != template) {
            return template.__curLocale();
        }
        RythmEngine engine = RythmEngine.get();
        Locale retval = null != engine ? engine.conf().locale() : (Locale)RythmConfigurationKey.I18N_LOCALE.getDefaultConfiguration();
        return retval;
    }

    public static Locale locale() {
        return I18N.locale(null);
    }

    public static ResourceBundle bundle(String name) {
        return I18N.bundle(null, name, null);
    }

    public static ResourceBundle bundle(ITemplate template, String name, Locale locale) {
        RythmEngine engine;
        if (null == name) {
            throw new NullPointerException();
        }
        String cacheKey = null;
        ResourceBundle retval = null;
        if (null == locale) {
            locale = I18N.locale(template);
        }
        RythmEngine rythmEngine = engine = null == template ? RythmEngine.get() : template.__engine();
        if (null != engine && null != locale) {
            cacheKey = CacheKey.i18nBundle(engine, locale);
            retval = bundleCache.get(cacheKey);
        }
        if (null == retval) {
            try {
                if (null == locale) {
                    locale = (Locale)RythmConfigurationKey.I18N_LOCALE.getDefaultConfiguration();
                }
                retval = ResourceBundle.getBundle(name, locale);
                bundleCache.put(cacheKey, retval);
            }
            catch (RuntimeException e) {
                logger.warn(e, "Error getting resource bundle by name %s", name);
            }
        }
        return retval;
    }
}

