/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.utils;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.rythmengine.RythmEngine;
import org.rythmengine.template.ITemplate;
import org.rythmengine.utils.RawData;
import org.rythmengine.utils.S;

public enum Escape {
    RAW,
    CSV{

        @Override
        protected RawData apply_(String s) {
            return new RawData(CSVEscape.escape(s));
        }
    }
    ,
    HTML{

        @Override
        protected RawData apply_(String s) {
            return S.escapeHtml(s);
        }
    }
    ,
    JS{

        @Override
        protected RawData apply_(String s) {
            return S.escapeJavaScript(s);
        }
    }
    ,
    JSON{

        @Override
        protected RawData apply_(String s) {
            return S.escapeJson(s);
        }
    }
    ,
    XML{

        @Override
        protected RawData apply_(String s) {
            return S.escapeXml(s);
        }
    };

    private static String[] sa_;

    public RawData apply(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        String s = o.toString();
        return this.apply_(s);
    }

    protected RawData apply_(String s) {
        return new RawData(s);
    }

    public static String[] stringValues() {
        if (null == sa_) {
            Escape[] ea = Escape.values();
            Object[] sa = new String[ea.length];
            for (int i = 0; i < ea.length; ++i) {
                sa[i] = ea[i].toString();
            }
            Arrays.sort(sa);
            sa_ = sa;
        }
        return (String[])sa_.clone();
    }

    public static Escape valueOfIngoreCase(Object o) {
        String escape = S.str(o);
        if (S.empty(escape)) {
            return RythmEngine.get().conf().defaultCodeType().escape();
        }
        if ((escape = escape.toUpperCase()).equals("JAVASCRIPT")) {
            escape = "JS";
        }
        return Escape.valueOf(escape);
    }

    public static Escape valueOfIngoreCase(ITemplate template, Object o) {
        String escape = S.str(o);
        if (S.empty(escape)) {
            if (null != template) {
                return template.__curEscape();
            }
            RythmEngine engine = RythmEngine.get();
            if (null == engine) {
                return RAW;
            }
            return RythmEngine.get().conf().defaultCodeType().escape();
        }
        if ((escape = escape.toUpperCase()).equals("JAVASCRIPT")) {
            escape = "JS";
        }
        return Escape.valueOf(escape);
    }

    static {
        sa_ = null;
    }

    private static class CSVEscape {
        private static final char CSV_DELIMITER = ',';
        private static final char CSV_QUOTE = '\"';
        private static final String CSV_QUOTE_STR = String.valueOf('\"');
        private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

        private CSVEscape() {
        }

        private static String escape(String s) {
            if (StringUtils.containsNone((CharSequence)s, (char[])CSV_SEARCH_CHARS)) {
                return s;
            }
            StringBuilder sb = new StringBuilder(CSV_QUOTE_STR);
            sb.append(StringUtils.replace((String)s, (String)CSV_QUOTE_STR, (String)(CSV_QUOTE_STR + CSV_QUOTE_STR)));
            return sb.append(CSV_QUOTE_STR).toString();
        }
    }
}

