/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.Sandbox;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.exception.FastRuntimeException;
import org.rythmengine.exception.RythmException;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.II18nMessageResolver;
import org.rythmengine.internal.IEvent;
import org.rythmengine.internal.RythmEvents;
import org.rythmengine.internal.TemplateBuilder;
import org.rythmengine.internal.compiler.ClassReloadException;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.template.ITag;
import org.rythmengine.template.ITemplate;
import org.rythmengine.utils.Escape;
import org.rythmengine.utils.F;
import org.rythmengine.utils.IO;
import org.rythmengine.utils.JSONWrapper;
import org.rythmengine.utils.Range;
import org.rythmengine.utils.RawData;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public abstract class TemplateBase
extends TemplateBuilder
implements ITemplate {
    protected static final ILogger __logger = Logger.get(TemplateBase.class);
    protected transient RythmEngine __engine = null;
    private transient TemplateClass __templateClass = null;
    private Writer w;
    private OutputStream os;
    protected Map<String, Object> __renderArgs = new HashMap<String, Object>();
    private String layoutContent = "";
    private Map<String, String> layoutSections = new HashMap<String, String>();
    private Map<String, Object> renderProperties = new HashMap<String, Object>();
    protected TemplateBase __parent = null;
    private StringBuilder tmpOut = null;
    private String section = null;
    private TextBuilder tmpCaller = null;
    private String secureCode = null;
    private Writer w_ = null;
    private static final ThreadLocal<Boolean> cce_ = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private Map<String, Object> userCtx;
    protected ITemplate.__Context __ctx = null;
    protected boolean __logTime = false;
    private II18nMessageResolver i18n = null;
    private Stack<F.T2<String, Object>> itrVars = new Stack();

    public void __setTemplateClass(TemplateClass templateClass) {
        this.__templateClass = templateClass;
    }

    public void __prepareRender(ICodeType type, Locale locale, RythmEngine engine) {
        TemplateClass tc = this.__templateClass;
        this.__ctx.init(this, type, locale, tc, engine);
        Class<?> c = this.getClass();
        Class<?> pc = c.getSuperclass();
        if (TemplateBase.class.isAssignableFrom(pc) && !Modifier.isAbstract(pc.getModifiers())) {
            try {
                TemplateClass ptc = engine.classes().getByClassName(pc.getName());
                if (null == ptc) {
                    throw new RuntimeException("Cannot find template class for parent class: " + pc);
                }
                this.__parent = (TemplateBase)ptc.asTemplate(engine);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (null != this.__parent) {
            this.__parent.__ctx.init(this.__parent, type, locale, tc, engine);
        }
    }

    protected S s() {
        return S.INSTANCE;
    }

    @Override
    public ITemplate __setWriter(Writer writer) {
        if (null == writer) {
            throw new NullPointerException();
        }
        if (null != this.os) {
            throw new IllegalStateException("Cannot set writer to template when outputstream is presented");
        }
        if (null != this.w) {
            throw new IllegalStateException("Cannot set writer to template when an writer is presented");
        }
        this.w = writer;
        return this;
    }

    @Override
    public ITemplate __setOutputStream(OutputStream os) {
        if (null == os) {
            throw new NullPointerException();
        }
        if (null != this.w) {
            throw new IllegalStateException("Cannot set output stream to template when writer is presented");
        }
        if (null != this.os) {
            throw new IllegalStateException("Cannot set output stream to template when an outputstream is presented");
        }
        this.os = os;
        return this;
    }

    @Override
    public RythmEngine __engine() {
        return null == this.__engine ? Rythm.engine() : this.__engine;
    }

    protected void __invokeTag(int line, String name) {
        this.__engine.invokeTemplate(line, name, this, null, null, null);
    }

    protected void __invokeTag(int line, String name, boolean ignoreNonExistsTag) {
        this.__engine.invokeTemplate(line, name, this, null, null, null, ignoreNonExistsTag);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params) {
        this.__engine.invokeTemplate(line, name, this, params, null, null);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params, boolean ignoreNonExistsTag) {
        this.__engine.invokeTemplate(line, name, this, params, null, null, ignoreNonExistsTag);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params, ITag.__Body body) {
        this.__engine.invokeTemplate(line, name, this, params, body, null);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params, ITag.__Body body, boolean ignoreNoExistsTag) {
        this.__engine.invokeTemplate(line, name, this, params, body, null, ignoreNoExistsTag);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params, ITag.__Body body, ITag.__Body context) {
        this.__engine.invokeTemplate(line, name, this, params, body, context);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params, ITag.__Body body, ITag.__Body context, boolean ignoreNonExistsTag) {
        this.__engine.invokeTemplate(line, name, this, params, body, context, ignoreNonExistsTag);
    }

    protected RawData __render(String template, Object ... args) {
        if (null == template) {
            return new RawData("");
        }
        return S.raw(this.__engine.sandbox().render(template, args));
    }

    protected RawData __render(String template) {
        if (null == template) {
            return new RawData("");
        }
        return S.raw(this.__engine.sandbox().render(template, this.__renderArgs));
    }

    protected final void __setLayoutContent(String body) {
        this.layoutContent = body;
    }

    private void __addLayoutSection(String name, String section) {
        if (this.layoutSections.containsKey(name)) {
            return;
        }
        this.layoutSections.put(name, section);
    }

    protected void __startSection(String name) {
        if (null == name) {
            throw new NullPointerException("section name cannot be null");
        }
        if (null != this.tmpOut) {
            throw new IllegalStateException("section cannot be nested");
        }
        this.tmpCaller = this.__caller;
        this.__caller = null;
        this.tmpOut = this.__buffer;
        this.__buffer = new StringBuilder();
        this.section = name;
    }

    protected void __endSection() {
        this.__endSection(false);
    }

    protected void __endSection(boolean def) {
        if (null == this.tmpOut && null == this.tmpCaller) {
            throw new IllegalStateException("section has not been started");
        }
        this.__addLayoutSection(this.section, this.__buffer.toString());
        this.__buffer = this.tmpOut;
        this.__caller = this.tmpCaller;
        this.tmpOut = null;
        this.tmpCaller = null;
    }

    protected void __pLayoutSection(String name) {
        this.p(this.layoutSections.get(name));
    }

    protected RawData __getSection(String name) {
        return S.raw(this.layoutSections.get(name));
    }

    protected RawData __getSection() {
        return S.raw(S.isEmpty(this.layoutContent) ? this.layoutSections.get("__CONTENT__") : this.layoutContent);
    }

    protected void __pLayoutContent() {
        this.p(this.__getSection());
    }

    private void addAllLayoutSections(Map<String, String> sections) {
        if (null != sections) {
            this.layoutSections.putAll(sections);
        }
    }

    private void addAllRenderProperties(Map<String, Object> properties) {
        if (null != properties) {
            this.renderProperties.putAll(properties);
        }
    }

    protected TemplateBase __internalClone() {
        try {
            return (TemplateBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public ITemplate __cloneMe(RythmEngine engine, ITemplate caller) {
        if (null == engine) {
            throw new NullPointerException();
        }
        TemplateBase tmpl = this.__internalClone();
        if (tmpl.__parent != null) {
            tmpl.__parent = (TemplateBase)tmpl.__parent.__cloneMe(engine, caller);
        }
        tmpl.__engine = engine;
        tmpl.__ctx = new ITemplate.__Context();
        if (null != this.__buffer) {
            tmpl.__buffer = new StringBuilder();
        }
        tmpl.__renderArgs = new HashMap<String, Object>(this.__renderArgs.size());
        tmpl.layoutSections = new HashMap<String, String>();
        tmpl.renderProperties = new HashMap<String, Object>();
        if (null != caller) {
            tmpl.__caller = (TextBuilder)((Object)caller);
            HashMap<String, Object> callerRenderArgs = new HashMap<String, Object>(((TemplateBase)caller).__renderArgs);
            Map<String, Class> types = tmpl.__renderArgTypeMap();
            for (String s : callerRenderArgs.keySet()) {
                Class c;
                Object o;
                if (tmpl.__renderArgs.containsKey(s) || null == (o = callerRenderArgs.get(s)) || TemplateBase.__isDefVal(o) || null != (c = types.get(s)) && !c.isAssignableFrom(o.getClass())) continue;
                tmpl.__setRenderArg(s, o);
            }
        }
        tmpl.__setUserContext(engine.renderSettings.userContext());
        return tmpl;
    }

    protected void __internalInit() {
        this.__loadExtendingArgs();
        this.__init();
    }

    protected void __setup() {
    }

    protected void __loadExtendingArgs() {
    }

    @Override
    public void __init() {
    }

    private boolean __logTime() {
        return false;
    }

    @Override
    public TemplateClass __getTemplateClass(boolean useCaller) {
        TemplateBase caller;
        TemplateClass tc = this.__templateClass;
        if (useCaller && null == tc && null != (caller = this.__caller())) {
            return caller.__getTemplateClass(true);
        }
        return tc;
    }

    @Override
    public final void render(OutputStream os) {
        this.__setOutputStream(os);
        this.render();
    }

    @Override
    public final void render(Writer w) {
        this.__setWriter(w);
        this.render();
    }

    protected void __triggerRenderEvent(IEvent<Void, ITemplate> event, RythmEngine engine) {
        event.trigger(engine, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String render() {
        RythmEngine engine = this.__engine();
        boolean engineSet = RythmEngine.set(engine);
        try {
            String string;
            block12: {
                long l = 0L;
                boolean logTime = this.__logTime();
                if (logTime) {
                    l = System.currentTimeMillis();
                }
                this.__triggerRenderEvent(RythmEvents.ON_RENDER, engine);
                this.__setup();
                if (logTime) {
                    __logger.debug("< preprocess [%s]: %sms", this.getClass().getName(), System.currentTimeMillis() - l);
                    l = System.currentTimeMillis();
                }
                try {
                    String s;
                    string = s = this.__internalRender();
                    this.__triggerRenderEvent(RythmEvents.RENDERED, engine);
                    if (!logTime) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        this.__triggerRenderEvent(RythmEvents.RENDERED, engine);
                        if (logTime) {
                            __logger.debug("<<<<<<<<<<<< [%s] total render: %sms", this.getClass().getName(), System.currentTimeMillis() - l);
                        }
                        throw throwable;
                    }
                    catch (ClassReloadException e) {
                        engine.restart(e);
                        String string2 = this.render();
                        return string2;
                    }
                }
                __logger.debug("<<<<<<<<<<<< [%s] total render: %sms", this.getClass().getName(), System.currentTimeMillis() - l);
            }
            return string;
        }
        finally {
            if (engineSet) {
                RythmEngine.clear();
            }
        }
    }

    @Override
    public ITemplate __setSecureCode(String secureCode) {
        if (null == secureCode) {
            return this;
        }
        this.secureCode = secureCode;
        if (null != this.__parent) {
            this.__parent.__setSecureCode(secureCode);
        }
        return this;
    }

    protected void __setOutput(String path) {
        try {
            this.w_ = new BufferedWriter(new FileWriter(path));
        }
        catch (Exception e) {
            throw new FastRuntimeException(e.getMessage());
        }
    }

    protected void __setOutput(File file) {
        try {
            this.w_ = new BufferedWriter(new FileWriter(file));
        }
        catch (Exception e) {
            throw new FastRuntimeException(e.getMessage());
        }
    }

    protected void __setOutput(OutputStream os) {
        this.w_ = new OutputStreamWriter(os);
    }

    protected void __setOutput(Writer w) {
        this.w_ = w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void __internalBuild() {
        this.w_ = null;
        try {
            long l = 0L;
            if (this.__logTime()) {
                l = System.currentTimeMillis();
            }
            String code = this.secureCode;
            Sandbox.enterRestrictedZone(code);
            try {
                this.__internalInit();
                this.build();
            }
            finally {
                Sandbox.leaveCurZone(code);
            }
            if (this.__logTime()) {
                __logger.debug("<<<<<<<<<<<< [%s] build: %sms", this.getClass().getName(), System.currentTimeMillis() - l);
            }
        }
        catch (RythmException e) {
            throw e;
        }
        catch (Throwable e) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            String msg = null;
            for (StackTraceElement se : stackTrace) {
                TemplateClass tc;
                String cName = se.getClassName();
                if (!cName.contains("__R_T_C__")) continue;
                if (cName.indexOf("$") != -1) {
                    cName = cName.substring(0, cName.lastIndexOf("$"));
                }
                if (null == (tc = this.__engine.classes().getByClassName(cName))) continue;
                if (null == msg && S.isEmpty(msg = e.getMessage())) {
                    msg = "Rythm runtime exception caused by " + e.getClass().getName();
                }
                RythmException re = new RythmException(this.__engine, e, tc, se.getLineNumber(), -1, msg);
                int lineNo = re.templateLineNumber;
                String key = tc.getKey().toString();
                int i = key.indexOf(10);
                if (i == -1) {
                    i = key.indexOf(13);
                }
                if (i > -1) {
                    key = key.substring(0, i - 1) + "...";
                }
                if (key.length() > 80) {
                    key = key.substring(0, 80) + "...";
                }
                if (lineNo != -1) {
                    StackTraceElement[] newStack = new StackTraceElement[stackTrace.length + 1];
                    newStack[0] = new StackTraceElement(tc.name(), "", key, lineNo);
                    System.arraycopy(stackTrace, 0, newStack, 1, stackTrace.length);
                    re.setStackTrace(newStack);
                }
                throw re;
            }
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        if (null != this.w_) {
            try {
                IO.writeContent((CharSequence)this.toString(), this.w_);
                this.w_ = null;
            }
            catch (Exception e) {
                Logger.error(e, "failed to write template content to output destination", new Object[0]);
            }
        }
    }

    protected boolean __hasParent() {
        return null != this.__parent && this.__parent != this;
    }

    protected String __internalRender() {
        this.__internalBuild();
        if (this.__hasParent()) {
            this.__parent.__setLayoutContent(this.toString());
            this.__parent.addAllLayoutSections(this.layoutSections);
            this.__parent.addAllRenderProperties(this.renderProperties);
            this.__parent.__setRenderArgs(this.__renderArgs);
            return this.__parent.render();
        }
        return this.toString();
    }

    @Override
    public TextBuilder build() {
        return this;
    }

    @Override
    public Map<String, Object> __getUserContext() {
        return null == this.userCtx ? Collections.EMPTY_MAP : this.userCtx;
    }

    @Override
    public ITemplate __setUserContext(Map<String, Object> context) {
        this.userCtx = context;
        return this;
    }

    protected Class[] __renderArgTypeArray() {
        return null;
    }

    protected String __renderArgName(int i) {
        return null;
    }

    protected Map<String, Class> __renderArgTypeMap() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public ITemplate __setRenderArgs(Map<String, Object> args) {
        this.__renderArgs.putAll(args);
        return this;
    }

    @Override
    public ITemplate __setRenderArg(JSONWrapper jsonData) {
        if (jsonData.isArray()) {
            this.setJSONArray(jsonData.getArray());
        } else {
            this.setJSONObject(jsonData.getObject());
        }
        return this;
    }

    private void setJSONArray(List<Object> jsonArray) {
        Class[] types = this.__renderArgTypeArray();
        int paraNo = jsonArray.size();
        if (types.length == 1 && types[0].equals(List.class)) {
            String vn;
            Map<String, Class> typeMap = this.__renderArgTypeMap();
            Class c = typeMap.get((vn = this.__renderArgName(0)) + "__0");
            if (null == c) {
                c = typeMap.get(vn);
            }
            List p = JSON.parseArray((String)jsonArray.toString(), (Class)c);
            this.__setRenderArg(vn, (Object)p);
        } else {
            for (int i = 0; i < types.length && i < paraNo; ++i) {
                Object o = jsonArray.get(i);
                Class c = types[i];
                Object p = o instanceof List ? JSON.parseArray((String)o.toString(), (Class)c) : JSON.parseObject((String)o.toString(), (Class)c);
                this.__setRenderArg(i, p);
            }
        }
    }

    private void setJSONObject(Map<String, Object> jsonObject) {
        Map<String, Class> types = this.__renderArgTypeMap();
        for (String nm : jsonObject.keySet()) {
            Object p;
            if (!types.containsKey(nm)) continue;
            Class c = types.get(nm);
            Object o = jsonObject.get(nm);
            if (o instanceof List) {
                Map<String, Class> typeMap = this.__renderArgTypeMap();
                Class c0 = typeMap.get(nm + "__0");
                boolean isArray = false;
                if (null == c0) {
                    isArray = true;
                    c0 = typeMap.get(nm);
                }
                if (isArray) {
                    JSONArray l = (JSONArray)o;
                    Class<?> c1 = c0.getComponentType();
                    int size = l.size();
                    Object a = Array.newInstance(c1, size);
                    for (int i = 0; i < size; ++i) {
                        Object el = l.get(i);
                        el = JSON.parseObject((String)el.toString(), c1);
                        Array.set(a, i, el);
                    }
                    p = a;
                } else {
                    p = JSON.parseArray((String)o.toString(), (Class)c0);
                }
            } else {
                String s = o.toString();
                p = String.class.equals((Object)c) ? s : JSON.parseObject((String)s, (Class)c);
            }
            this.__setRenderArg(nm, p);
        }
    }

    protected TemplateBase __setRenderArgs0(ITag.__ParameterList params) {
        for (int i = 0; i < params.size(); ++i) {
            ITag.__Parameter param = params.get(i);
            if (null != param.name) {
                this.__setRenderArg(param.name, param.value);
                continue;
            }
            this.__setRenderArg(i, param.value);
        }
        return this;
    }

    @Override
    public ITemplate __setRenderArgs(Object ... args) {
        return this;
    }

    @Override
    public ITemplate __setRenderArg(String name, Object arg) {
        this.__renderArgs.put(name, arg);
        return this;
    }

    protected final TemplateBase __set(String name, Object arg) {
        this.__setRenderArg(name, arg);
        return this;
    }

    protected final TemplateBase __caller() {
        return null == this.__caller ? null : (TemplateBase)this.__caller;
    }

    @Override
    public <T> T __getRenderArg(String name) {
        Object val = this.__renderArgs.get(name);
        if (null != this.__caller) {
            if (!TemplateBase.__isDefVal(val)) {
                return (T)val;
            }
            return this.caller().__getRenderArg(name);
        }
        return (T)val;
    }

    protected static final <T> T __get(Map<String, Object> map, String name, Class<T> cls) {
        Object o = map.get(name);
        return (T)(null != o ? o : TemplateBase.__transNull(cls));
    }

    protected final <T> T __get(String name, Class<T> cls) {
        T o = this.__get(name);
        return null != o ? o : TemplateBase.__transNull(cls);
    }

    protected static final <T> T __safeCast(Object o, Class<T> cls) {
        return (T)(null != o ? o : TemplateBase.__transNull(cls));
    }

    protected static final <T> T __transNull(Class<T> cls) {
        if (null == cls) {
            return null;
        }
        if (cls.equals(String.class)) {
            return (T)"";
        }
        if (cls.equals(Integer.class)) {
            return (T)Integer.valueOf(0);
        }
        if (cls.equals(Boolean.class)) {
            return (T)Boolean.valueOf(false);
        }
        if (cls.equals(Double.class)) {
            return (T)Double.valueOf(0.0);
        }
        if (cls.equals(Float.class)) {
            return (T)Float.valueOf(0.0f);
        }
        if (cls.equals(Long.class)) {
            return (T)Long.valueOf(0L);
        }
        if (cls.equals(Short.class)) {
            return (T)Short.valueOf((short)0);
        }
        if (cls.equals(Byte.class)) {
            return (T)Byte.valueOf((byte)0);
        }
        if (cls.equals(Character.class)) {
            return (T)Character.valueOf('\u0000');
        }
        return null;
    }

    protected static final boolean __isDefVal(Object o) {
        if (null == o) {
            return true;
        }
        if (o instanceof String) {
            return "".equals(o);
        }
        if (o instanceof Boolean) {
            return Boolean.valueOf(false).equals(o);
        }
        if (o instanceof Integer) {
            return Integer.valueOf(0).equals(o);
        }
        if (o instanceof Double) {
            return Double.valueOf(0.0).equals(o);
        }
        if (o instanceof Float) {
            return Float.valueOf(0.0f).equals(o);
        }
        if (o instanceof Long) {
            return Long.valueOf(0L).equals(o);
        }
        if (o instanceof Short) {
            return Short.valueOf((short)0).equals(o);
        }
        if (o instanceof Byte) {
            return Byte.valueOf((byte)0).equals(o);
        }
        if (o instanceof Character) {
            return Character.valueOf('\u0000').equals(o);
        }
        return false;
    }

    protected final <T> T __get(String name) {
        return this.__getRenderArg(name);
    }

    protected final <T> T __getAs(String name, Class<T> c) {
        T o = this.__getRenderArg(name);
        if (null == o) {
            return null;
        }
        return o;
    }

    protected final <T> T __getRenderProperty(String name, T def) {
        Object o = this.__renderArgs.get(name);
        return (T)(TemplateBase.__isDefVal(o) ? def : o);
    }

    protected final <T> T __getRenderProperty(String name) {
        return this.__getRenderProperty(name, null);
    }

    protected final <T> T __getRenderPropertyAs(String name, T def) {
        T o = this.__getRenderProperty(name, def);
        return null == o ? def : o;
    }

    protected final void __setRenderProperty(String name, Object val) {
        this.__renderArgs.put(name, val);
    }

    protected final void __handleTemplateExecutionException(Exception e) {
        try {
            if (!RythmEvents.ON_RENDER_EXCEPTION.trigger(this.__engine(), F.T2(this, e)).booleanValue()) {
                throw e;
            }
        }
        catch (RuntimeException e0) {
            throw e0;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public ITemplate __setRenderArg(int position, Object arg) {
        return this;
    }

    @Override
    public ICodeType __curCodeType() {
        return this.__ctx.currentCodeType();
    }

    @Override
    public Locale __curLocale() {
        return this.__ctx.currentLocale();
    }

    @Override
    public Escape __curEscape() {
        return this.__ctx.currentEscape();
    }

    private boolean appendToBuffer() {
        return null != this.__parent || null == this.w && null == this.os;
    }

    private boolean appendToWriter() {
        return null == this.__parent && null != this.w;
    }

    private boolean appendToOutputStream() {
        return null == this.__parent && null != this.os;
    }

    @Override
    protected void __append(TextBuilder.StrBuf wrapper) {
        if (this.appendToBuffer()) {
            super.__append(wrapper);
        }
        if (null == this.os && null == this.w) {
            return;
        }
        if (this.appendToOutputStream()) {
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(wrapper.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(Object o) {
        String oStr = o.toString();
        if (this.appendToBuffer()) {
            super.__append(oStr);
        }
        if (null == this.os && null == this.w) {
            return;
        }
        TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(oStr);
        if (this.appendToOutputStream()) {
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(wrapper.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(char c) {
        if (this.appendToBuffer()) {
            super.__append(c);
        }
        if (null == this.os && null == this.w) {
            return;
        }
        if (this.appendToOutputStream()) {
            try {
                this.os.write(c);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(c);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(int i) {
        if (this.appendToBuffer()) {
            super.__append(i);
        }
        if (null == this.os && null == this.w) {
            return;
        }
        if (this.appendToOutputStream()) {
            TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(String.valueOf(i));
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(String.valueOf(i));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(long l) {
        if (this.appendToBuffer()) {
            super.__append(l);
        }
        if (null == this.os && null == this.w) {
            return;
        }
        if (this.appendToOutputStream()) {
            TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(String.valueOf(l));
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(String.valueOf(l));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(float f) {
        if (this.appendToBuffer()) {
            super.__append(f);
        }
        if (null == this.os && null == this.w) {
            return;
        }
        if (this.appendToOutputStream()) {
            TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(String.valueOf(f));
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(String.valueOf(f));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(double d) {
        if (this.appendToBuffer()) {
            super.__append(d);
        }
        if (null == this.os && null == this.w) {
            return;
        }
        if (this.appendToOutputStream()) {
            TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(String.valueOf(d));
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(String.valueOf(d));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(boolean b) {
        if (this.appendToBuffer()) {
            super.__append(b);
        }
        if (null == this.os && null == this.w) {
            return;
        }
        if (this.appendToOutputStream()) {
            TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(String.valueOf(b));
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(String.valueOf(b));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Escape __defaultEscape() {
        return this.__ctx.currentEscape();
    }

    @Override
    public final TemplateBase pe(Object o) {
        return (TemplateBase)super.pe(o);
    }

    @Override
    public final TemplateBase pe(Object o, Escape escape) {
        return (TemplateBase)super.pe(o, escape);
    }

    protected final Class __getClass(int o) {
        return Integer.TYPE;
    }

    protected final Class __getClass(boolean o) {
        return Boolean.TYPE;
    }

    protected final Class __getClass(char o) {
        return Character.TYPE;
    }

    protected final Class __getClass(long o) {
        return Long.TYPE;
    }

    protected final Class __getClass(float o) {
        return Float.TYPE;
    }

    protected final Class __getClass(double o) {
        return Double.TYPE;
    }

    protected final Class __getClass(byte o) {
        return Byte.TYPE;
    }

    protected final Class __getClass(Object o) {
        if (null == o) {
            return Void.TYPE;
        }
        return o.getClass();
    }

    protected final Object __eval(String expr) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.__renderArgs);
        ctx.putAll(this.itrVars());
        try {
            return this.__engine().eval(expr, this, ctx);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected static void __log(String msg, Object ... args) {
        __logger.info(msg, args);
    }

    protected static void __debug(String msg, Object ... args) {
        __logger.debug(msg, args);
    }

    protected static void __info(String msg, Object ... args) {
        __logger.info(msg, args);
    }

    protected static void __warn(String msg, Object ... args) {
        __logger.error(msg, args);
    }

    protected static void __warn(Throwable t, String msg, Object ... args) {
        __logger.error(t, msg, args);
    }

    protected static void __error(String msg, Object ... args) {
        __logger.error(msg, args);
    }

    protected static void __error(Throwable t, String msg, Object ... args) {
        __logger.error(t, msg, args);
    }

    protected String __i18n(String key, Object ... args) {
        if (this.i18n == null) {
            this.i18n = this.__engine().conf().i18nMessageResolver();
        }
        return this.i18n.getMessage(this, key, args);
    }

    protected void __pushItrVar(String name, Object val) {
        this.itrVars.push(F.T2(name, val));
    }

    protected void __popItrVar() {
        if (this.itrVars.isEmpty()) {
            return;
        }
        this.itrVars.pop();
    }

    private Map<String, Object> itrVars() {
        if (this.itrVars.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        if (this.itrVars.size() == 1) {
            return this.itrVars.peek().asMap();
        }
        Stack<F.T2<String, Object>> tmp = new Stack<F.T2<String, Object>>();
        HashMap<String, Object> m = new HashMap<String, Object>();
        Stack<F.T2<String, Object>> vs = this.itrVars;
        while (!vs.isEmpty()) {
            F.T2<String, Object> var = vs.pop();
            tmp.push(var);
            String k = (String)var._1;
            if (m.containsKey(k)) continue;
            m.put(k, var._2);
        }
        while (!tmp.isEmpty()) {
            vs.push((F.T2<String, Object>)tmp.pop());
        }
        return m;
    }

    public static void main(String[] args) {
        Integer[] ia;
        Integer[] o = ia = new Integer[]{1, 2};
        __Itr it = __Itr.valueOf((Object)o);
        Iterator i$ = it.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            System.out.println(i);
        }
    }

    protected static class __Itr<T>
    implements Iterable<T> {
        protected Object _o = null;
        protected int _size = -1;
        protected Iterator<T> iterator = null;
        protected int cursor = 0;
        private static final Iterator nullIterator = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
        private static final __Itr EMPTY_ITR = new __Itr(){

            @Override
            public int size() {
                return 0;
            }

            @Override
            public Iterator iterator() {
                return nullIterator;
            }
        };

        private __Itr() {
        }

        private __Itr(Object o) {
            if (o.getClass().isArray()) {
                this._size = Array.getLength(o);
                this.iterator = new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return __Itr.this.cursor < __Itr.this._size;
                    }

                    @Override
                    public T next() {
                        return Array.get(__Itr.this._o, __Itr.this.cursor++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            } else {
                String s = o.toString();
                if (S.isEmpty(s)) {
                    this._o = "";
                    this._size = 0;
                    this.iterator = Collections.EMPTY_LIST.iterator();
                    return;
                }
                ArrayList<String> seps = new ArrayList<String>();
                RythmEngine engine = RythmEngine.get();
                RythmConfiguration conf = engine.conf();
                if ("zh".equals(conf.locale().getLanguage())) {
                    seps.addAll(Arrays.asList("\n,\u3001,\uff0c,\uff1b,\u3002,\uff1a".split(",")));
                } else {
                    seps.add("\n");
                }
                seps.addAll(Arrays.asList(";^,^:^_^-".split("\\^")));
                for (String sep : seps) {
                    if (!s.contains(sep)) continue;
                    List<String> ls = Arrays.asList(s.split(sep));
                    ArrayList<String> ls0 = new ArrayList<String>();
                    for (String s0 : ls) {
                        ls0.add(s0.trim());
                    }
                    this._o = ls0;
                    this._size = ls.size();
                    this.iterator = ls0.iterator();
                    break;
                }
                if (null == this._o) {
                    ArrayList<String> ls = new ArrayList<String>();
                    ls.add(s);
                    this._size = 1;
                    this.iterator = ls.iterator();
                }
            }
        }

        public static <T> __Itr<T> valueOf(T[] ta) {
            final __Itr<T> itr = new __Itr<T>();
            itr._o = ta;
            itr._size = ta.length;
            itr.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return itr.cursor < itr._size;
                }

                @Override
                public T next() {
                    return ((Object[])itr._o)[itr.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return itr;
        }

        public static __Itr<Integer> valueOf(int[] ta) {
            final __Itr<Integer> itr = new __Itr<Integer>();
            itr._o = ta;
            itr._size = ta.length;
            itr.iterator = new Iterator<Integer>(){

                @Override
                public boolean hasNext() {
                    return itr.cursor < itr._size;
                }

                @Override
                public Integer next() {
                    return ((int[])itr._o)[itr.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return itr;
        }

        public static __Itr<Long> valueOf(long[] ta) {
            final __Itr<Long> itr = new __Itr<Long>();
            itr._o = ta;
            itr._size = ta.length;
            itr.iterator = new Iterator<Long>(){

                @Override
                public boolean hasNext() {
                    return itr.cursor < itr._size;
                }

                @Override
                public Long next() {
                    return ((long[])itr._o)[itr.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return itr;
        }

        public static __Itr<Float> valueOf(float[] ta) {
            final __Itr<Float> itr = new __Itr<Float>();
            itr._o = ta;
            itr._size = ta.length;
            itr.iterator = new Iterator<Float>(){

                @Override
                public boolean hasNext() {
                    return itr.cursor < itr._size;
                }

                @Override
                public Float next() {
                    return Float.valueOf(((float[])itr._o)[itr.cursor++]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return itr;
        }

        public static __Itr<Double> valueOf(double[] ta) {
            final __Itr<Double> itr = new __Itr<Double>();
            itr._o = ta;
            itr._size = ta.length;
            itr.iterator = new Iterator<Double>(){

                @Override
                public boolean hasNext() {
                    return itr.cursor < itr._size;
                }

                @Override
                public Double next() {
                    return ((double[])itr._o)[itr.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return itr;
        }

        public static __Itr<Short> valueOf(short[] ta) {
            final __Itr<Short> itr = new __Itr<Short>();
            itr._o = ta;
            itr._size = ta.length;
            itr.iterator = new Iterator<Short>(){

                @Override
                public boolean hasNext() {
                    return itr.cursor < itr._size;
                }

                @Override
                public Short next() {
                    return ((short[])itr._o)[itr.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return itr;
        }

        public static __Itr<Character> valueOf(char[] ta) {
            final __Itr<Character> itr = new __Itr<Character>();
            itr._o = ta;
            itr._size = ta.length;
            itr.iterator = new Iterator<Character>(){

                @Override
                public boolean hasNext() {
                    return itr.cursor < itr._size;
                }

                @Override
                public Character next() {
                    return Character.valueOf(((char[])itr._o)[itr.cursor++]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return itr;
        }

        public static __Itr<Byte> valueOf(byte[] ta) {
            final __Itr<Byte> itr = new __Itr<Byte>();
            itr._o = ta;
            itr._size = ta.length;
            itr.iterator = new Iterator<Byte>(){

                @Override
                public boolean hasNext() {
                    return itr.cursor < itr._size;
                }

                @Override
                public Byte next() {
                    return ((byte[])itr._o)[itr.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return itr;
        }

        public static __Itr<Boolean> valueOf(boolean[] ta) {
            final __Itr<Boolean> itr = new __Itr<Boolean>();
            itr._o = ta;
            itr._size = ta.length;
            itr.iterator = new Iterator<Boolean>(){

                @Override
                public boolean hasNext() {
                    return itr.cursor < itr._size;
                }

                @Override
                public Boolean next() {
                    return ((boolean[])itr._o)[itr.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return itr;
        }

        public static <T extends Comparable> __Itr<T> valueOf(Range range) {
            __Itr<T> itr = new __Itr<T>();
            itr._o = range;
            itr._size = range.size();
            itr.iterator = range.iterator();
            return itr;
        }

        public static __Itr valueOf(Object obj) {
            if (null == obj) {
                return EMPTY_ITR;
            }
            if (obj instanceof Iterable) {
                return __Itr.valueOf((Iterable)obj);
            }
            Class<?> c = obj.getClass();
            if (c.isArray()) {
                Class<?> ct = c.getComponentType();
                if (ct.equals(Integer.TYPE)) {
                    return __Itr.valueOf((int[])obj);
                }
                if (ct.equals(Long.TYPE)) {
                    return __Itr.valueOf((long[])obj);
                }
                if (ct.equals(Float.TYPE)) {
                    return __Itr.valueOf((float[])obj);
                }
                if (ct.equals(Double.TYPE)) {
                    return __Itr.valueOf((double[])obj);
                }
                if (ct.equals(Character.TYPE)) {
                    return __Itr.valueOf((char[])obj);
                }
                if (ct.equals(Byte.TYPE)) {
                    return __Itr.valueOf((byte[])obj);
                }
                if (ct.equals(Boolean.TYPE)) {
                    return __Itr.valueOf((boolean[])obj);
                }
            }
            return new __Itr(obj);
        }

        public static <T> __Itr valueOf(Iterable<T> tc) {
            __Itr<T> itr = new __Itr<T>();
            itr._o = tc;
            itr._size = tc instanceof Collection ? ((Collection)tc).size() : -1;
            itr.iterator = tc.iterator();
            return itr;
        }

        public int size() {
            return this._size;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterator;
        }
    }
}

