/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.sandbox;

import java.io.File;
import java.io.FilePermission;
import java.net.InetAddress;
import java.security.Permission;
import org.rythmengine.RythmEngine;
import org.rythmengine.Sandbox;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.utils.S;

public class RythmSecurityManager
extends SecurityManager {
    private SecurityManager osm = System.getSecurityManager();
    private SecurityManager csm;
    private String code = null;
    private static IFilePathValidator readable = new IFilePathValidator(){

        @Override
        public boolean isValid(String path) {
            StackTraceElement ste;
            StackTraceElement[] st;
            String uxPath = path;
            if (path.matches("^(jar:file:)?[a-zA-Z]:.*")) {
                uxPath = "/" + path.replace("\\", "/").toLowerCase();
            }
            if (uxPath.startsWith(BASE_RYTHM) || uxPath.startsWith(BASE_JDK)) {
                return true;
            }
            if (RythmSecurityManager.allowTmpDirIO(path)) {
                return true;
            }
            return RythmSecurityManager.engine().conf().playFramework() && (st = new Throwable().getStackTrace()).length > 6 && S.eq((ste = st[5]).getClassName(), "play.classloading.ApplicationClasses");
        }
    };
    private static IFilePathValidator writable;
    private static IFilePathValidator deletable;
    private static final String BASE_RYTHM;
    private static final String BASE_JDK;

    private static RythmEngine engine() {
        return RythmEngine.get();
    }

    public String getCode() {
        Throwable t = new Throwable();
        StackTraceElement[] st = t.getStackTrace();
        StackTraceElement ste = st[1];
        if (S.ne(ste.getClassName(), RythmEngine.class.getName())) {
            RythmSecurityManager.forbidden();
        }
        return this.code;
    }

    public RythmSecurityManager(SecurityManager customSecurityManager, String password, RythmEngine re) {
        this.csm = customSecurityManager;
        if (null == password) {
            throw new NullPointerException();
        }
        this.code = password;
    }

    private static void forbidden() {
        throw new SecurityException("Access to protected resource is restricted in Sandbox mode");
    }

    public void forbiddenIfCodeNotMatch(String code) {
        if (S.ne(code, this.code)) {
            RythmSecurityManager.forbidden();
        }
    }

    private void checkRythm() {
        if (Sandbox.isRestricted()) {
            RythmSecurityManager.forbidden();
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (null != this.osm) {
            this.osm.checkAccess(t);
        }
        if (null != this.csm) {
            this.csm.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        this.checkRythm();
        if (null != this.csm) {
            this.csm.checkAccess(g);
        }
        if (null != this.osm) {
            this.osm.checkAccess(g);
        }
    }

    @Override
    public void checkExit(int status) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkExit(status);
        }
        if (null != this.csm) {
            this.csm.checkExit(status);
        }
    }

    @Override
    public void checkExec(String cmd) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkExec(cmd);
        }
        if (null != this.csm) {
            this.csm.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkLink(lib);
        }
        if (null != this.csm) {
            this.csm.checkLink(lib);
        }
    }

    private static boolean allowTmpDirIO(String path) {
        RythmConfiguration conf = RythmEngine.get().conf();
        if (conf.sandboxTmpIO()) {
            String tmp = System.getProperty("java.io.tmpdir");
            if (path.startsWith(tmp)) {
                return true;
            }
            if ((path + File.separator).startsWith(tmp)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeCheckFile(String path, IFilePathValidator validator) {
        if (!Sandbox.isRestricted()) {
            return;
        }
        Sandbox.enterSafeZone(this.code);
        try {
            if (!validator.isValid(path)) {
                RythmSecurityManager.forbidden();
            }
        }
        finally {
            Sandbox.leaveCurZone(this.code);
        }
    }

    @Override
    public void checkRead(String file) {
        this.safeCheckFile(file, readable);
        if (null != this.csm) {
            this.csm.checkRead(file);
        }
        if (null != this.osm) {
            this.osm.checkRead(file);
        }
    }

    @Override
    public void checkWrite(String file) {
        this.safeCheckFile(file, writable);
        if (null != this.csm) {
            this.csm.checkWrite(file);
        }
        if (null != this.osm) {
            this.osm.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        this.safeCheckFile(file, deletable);
        if (null != this.csm) {
            this.csm.checkDelete(file);
        }
        if (null != this.osm) {
            this.osm.checkDelete(file);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        this.checkRythm();
        if (null != this.csm) {
            this.csm.checkConnect(host, port);
        }
        if (null != this.osm) {
            this.osm.checkConnect(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        this.checkRythm();
        if (null != this.csm) {
            this.csm.checkConnect(host, port, context);
        }
        if (null != this.osm) {
            this.osm.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        this.checkRythm();
        if (null != this.csm) {
            this.csm.checkListen(port);
        }
        if (null != this.osm) {
            this.osm.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        this.checkRythm();
        if (null != this.csm) {
            this.csm.checkAccept(host, port);
        }
        if (null != this.osm) {
            this.osm.checkAccept(host, port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        this.checkRythm();
        if (null != this.csm) {
            this.csm.checkMulticast(maddr);
        }
        if (null != this.osm) {
            this.osm.checkMulticast(maddr);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        this.checkRythm();
        if (null != this.csm) {
            this.csm.checkPropertiesAccess();
        }
        if (null != this.osm) {
            this.osm.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (key.startsWith("rythm.")) {
            key = key.substring(7);
        }
        if (null != RythmConfigurationKey.valueOfIgnoreCase(key)) {
            return;
        }
        RythmEngine e = RythmSecurityManager.engine();
        if (null == e) {
            return;
        }
        String s = e.conf().allowedSystemProperties();
        if (s.indexOf(key) > -1) {
            return;
        }
        this.checkRythm();
        if (null != this.csm) {
            this.csm.checkPropertyAccess(key);
        }
        if (null != this.osm) {
            this.osm.checkPropertyAccess(key);
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        this.checkRythm();
        if (null != this.csm) {
            return this.csm.checkTopLevelWindow(window);
        }
        if (null != this.osm) {
            return this.osm.checkTopLevelWindow(window);
        }
        return true;
    }

    @Override
    public void checkPrintJobAccess() {
        this.checkRythm();
        if (null != this.csm) {
            this.csm.checkPrintJobAccess();
        }
        if (null != this.osm) {
            this.osm.checkPrintJobAccess();
        }
    }

    public void checkSystemClipboardAccess() {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkSystemClipboardAccess();
        }
        if (null != this.csm) {
            this.csm.checkSystemClipboardAccess();
        }
    }

    public void checkAwtEventQueueAccess() {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkAwtEventQueueAccess();
        }
        if (null != this.csm) {
            this.csm.checkAwtEventQueueAccess();
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (null != this.osm) {
            this.osm.checkPackageAccess(pkg);
        }
        if (null != this.csm) {
            this.csm.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkPackageDefinition(pkg);
        }
        if (null != this.osm) {
            this.osm.checkPackageDefinition(pkg);
        }
    }

    private void checkFilePermission(FilePermission fp) {
        String actions = fp.getActions();
        String name = fp.getName();
        if (actions.contains("read")) {
            this.checkRead(name);
        }
        if (actions.contains("write")) {
            this.checkWrite(name);
        }
        if (actions.contains("delete")) {
            this.checkDelete(name);
        }
        if (actions.contains("execute")) {
            this.checkExec(name);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        if (perm instanceof FilePermission) {
            FilePermission fp = (FilePermission)perm;
            this.checkFilePermission(fp);
        } else if ("setSecurityManager".equals(perm.getName())) {
            this.checkRythm();
        }
        if (null != this.osm) {
            this.osm.checkPermission(perm);
        }
        if (null != this.csm) {
            this.csm.checkPermission(perm);
        }
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        if (null != this.osm) {
            this.osm.checkMemberAccess(clazz, which);
        }
        if (null != this.csm) {
            this.csm.checkMemberAccess(clazz, which);
        }
    }

    @Override
    public void checkSetFactory() {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkSetFactory();
        }
        if (null != this.csm) {
            this.csm.checkSetFactory();
        }
    }

    static {
        deletable = writable = new IFilePathValidator(){

            @Override
            public boolean isValid(String path) {
                return RythmSecurityManager.allowTmpDirIO(path);
            }
        };
        BASE_RYTHM = RythmEngine.class.getResource(RythmEngine.class.getSimpleName() + ".class").getFile().replace("RythmEngine.class", "").toLowerCase();
        BASE_JDK = Integer.class.getResource(Integer.class.getSimpleName() + ".class").getFile().replace("Integer.class", "").toLowerCase();
    }

    private static interface IFilePathValidator {
        public boolean isValid(String var1);
    }
}

