/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.internal.RythmThreadFactory;
import org.rythmengine.internal.compiler.ParamTypeInferencer;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.FileResourceLoader;
import org.rythmengine.resource.FileTemplateResource;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.StringTemplateResource;
import org.rythmengine.utils.S;

public class TemplateResourceManager {
    private static final ILogger logger = Logger.get(TemplateResourceManager.class);
    public static final ITemplateResource NULL = new ITemplateResource(){

        @Override
        public Object getKey() {
            return null;
        }

        @Override
        public String getSuggestedClassName() {
            return null;
        }

        @Override
        public String asTemplateContent() {
            return null;
        }

        @Override
        public boolean refresh() {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public ICodeType codeType(RythmEngine engine) {
            return null;
        }

        @Override
        public ITemplateResourceLoader getLoader() {
            return null;
        }
    };
    private RythmEngine engine;
    private Map<Object, ITemplateResource> cache = new HashMap<Object, ITemplateResource>();
    private List<ITemplateResourceLoader> loaders;
    private FileResourceLoader adhocFileLoader = null;
    private Map<Object, ITemplateResourceLoader> whichLoader = new HashMap<Object, ITemplateResourceLoader>();
    private boolean typeInference;
    private static Set<String> blackList = new HashSet<String>();
    private static ThreadLocal<Stack<Set<String>>> tmpBlackList = new ThreadLocal<Stack<Set<String>>>(){

        @Override
        protected Stack<Set<String>> initialValue() {
            return new Stack<Set<String>>();
        }
    };
    private ScheduledExecutorService loadingService = new ScheduledThreadPoolExecutor(1, new ScannerThreadFactory());

    public static void setUpTmpBlackList() {
        tmpBlackList.get().push(new HashSet());
    }

    public static void reportNonResource(String str) {
        tmpBlackList.get().peek().add(str);
    }

    public static void commitTmpBlackList() {
        try {
            Set<String> ss = tmpBlackList.get().pop();
            blackList.addAll(ss);
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public static void rollbackTmpBlackList() {
        try {
            tmpBlackList.get().pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public TemplateResourceManager(RythmEngine engine) {
        Boolean defLoader;
        this.engine = engine;
        RythmConfiguration conf = engine.conf();
        this.typeInference = conf.typeInferenceEnabled();
        this.loaders = new ArrayList<ITemplateResourceLoader>(conf.getList(RythmConfigurationKey.RESOURCE_LOADER_IMPLS, ITemplateResourceLoader.class));
        if (!this.loaders.isEmpty() && !(defLoader = (Boolean)conf.get(RythmConfigurationKey.RESOURCE_DEF_LOADER_ENABLED)).booleanValue()) {
            return;
        }
        List<File> roots = conf.templateHome();
        for (File root : roots) {
            FileResourceLoader frl = new FileResourceLoader(engine, root);
            if (null == this.adhocFileLoader) {
                this.adhocFileLoader = frl;
            }
            this.loaders.add(frl);
        }
    }

    private ITemplateResource cache(ITemplateResource resource) {
        if (resource.isValid()) {
            this.cache.put(resource.getKey(), resource);
        }
        return resource;
    }

    public TemplateClass tryLoadTemplate(String tmplName, TemplateClass callerClass) {
        ITemplateResourceLoader loader;
        if (blackList.contains(tmplName)) {
            return null;
        }
        TemplateClass tc = null;
        RythmEngine engine = this.engine;
        Iterator<ITemplateResourceLoader> i$ = this.loaders.iterator();
        while (i$.hasNext() && null == (tc = (loader = i$.next()).tryLoadTemplate(tmplName, engine, callerClass))) {
        }
        return tc;
    }

    public ITemplateResource get(File file) {
        return this.cache(new FileTemplateResource(file, this.adhocFileLoader));
    }

    public ITemplateResource get(String str) {
        ITemplateResource resource = this.getResource(str);
        if (!resource.isValid()) {
            resource = new StringTemplateResource(str);
        }
        return this.cache(resource);
    }

    public ITemplateResourceLoader whichLoader(ITemplateResource resource) {
        return this.whichLoader.get(resource.getKey());
    }

    public ITemplateResource getResource(String str) {
        ITemplateResource resource = this.cache.get(str);
        if (null != resource) {
            return resource;
        }
        for (ITemplateResourceLoader loader : this.loaders) {
            resource = loader.load(str);
            if (null == resource || !resource.isValid()) continue;
            this.whichLoader.put(resource.getKey(), loader);
            break;
        }
        return null == resource ? NULL : this.cache(resource);
    }

    public void scan() {
        for (ITemplateResourceLoader loader : this.loaders) {
            loader.scan(this);
        }
    }

    public void resourceLoaded(ITemplateResource resource) {
        this.resourceLoaded(resource, true);
    }

    public TemplateClass resourceLoaded(ITemplateResource resource, boolean async) {
        ITemplateResourceLoader loader = resource.getLoader();
        this.whichLoader.put(resource.getKey(), loader);
        return this._resourceLoaded(resource);
    }

    private TemplateClass _resourceLoaded(ITemplateResource resource) {
        RythmEngine engine;
        TemplateClass tc;
        if (!resource.isValid()) {
            return null;
        }
        String key = S.str(resource.getKey());
        if (this.typeInference) {
            key = key + ParamTypeInferencer.uuid();
        }
        if (null == (tc = (engine = this.engine).classes().getByTemplate(key))) {
            tc = new TemplateClass(resource, engine);
        }
        tc.asTemplate(engine);
        return tc;
    }

    public void shutdown() {
        this.loadingService.shutdown();
    }

    private static class ScannerThreadFactory
    extends RythmThreadFactory {
        private ScannerThreadFactory() {
            super("rythm-scanner");
        }
    }
}

