/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.resource;

import java.util.ArrayList;
import java.util.Arrays;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.TemplateResourceBase;
import org.rythmengine.resource.TemplateResourceManager;
import org.rythmengine.utils.S;

public abstract class ResourceLoaderBase
implements ITemplateResourceLoader {
    protected static ILogger logger = Logger.get(ResourceLoaderBase.class);
    private RythmEngine engine;

    @Override
    public RythmEngine getEngine() {
        return this.engine;
    }

    @Override
    public void setEngine(RythmEngine engine) {
        this.engine = engine;
    }

    public String getFullName(TemplateClass tc) {
        int pos;
        String root;
        String key = tc.getKey().toString();
        if (key.startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        if (key.startsWith(root = this.getResourceLoaderRoot())) {
            key = key.replace(root, "");
        }
        if (key.startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        if (-1 != (pos = key.lastIndexOf("."))) {
            key = key.substring(0, pos);
        }
        key = key.replace('/', '.').replace('\\', '.');
        key = key + tc.codeType.resourceNameSuffix();
        return key;
    }

    protected RythmEngine getDefaultEngine() {
        return Rythm.engine();
    }

    @Override
    public TemplateClass tryLoadTemplate(String tmplName, RythmEngine engine, TemplateClass callerTemplateClass) {
        return this.tryLoadTemplate(tmplName, engine, callerTemplateClass, true);
    }

    private TemplateClass tryLoadTemplate(String tmplName, RythmEngine engine, TemplateClass callerClass, boolean processTagName) {
        TemplateClass tc;
        if (null == engine) {
            engine = this.getDefaultEngine();
        }
        if (engine.templateRegistered(tmplName)) {
            return null;
        }
        String rythmSuffix = engine.conf().resourceNameSuffix();
        ArrayList<String> suffixes = new ArrayList<String>(Arrays.asList(".html", ".json", ".js", ".css", ".csv", ".tag", ".xml", ".txt", ""));
        ICodeType codeType = TemplateResourceBase.getTypeOfPath(engine, tmplName);
        if (ICodeType.DefImpl.RAW == codeType) {
            codeType = callerClass.codeType;
        }
        String tagNameOrigin = tmplName;
        if (processTagName) {
            boolean withRythmSuffix = S.notEmpty(rythmSuffix);
            for (String s : suffixes) {
                if (tmplName.endsWith(s)) {
                    tmplName = tmplName.substring(0, tmplName.lastIndexOf(s));
                    break;
                }
                if (!withRythmSuffix || !tmplName.endsWith(s = s + rythmSuffix)) continue;
                tmplName = tmplName.substring(0, tmplName.lastIndexOf(s));
                break;
            }
        }
        tmplName = tmplName.replace('.', '/');
        String sfx = codeType.resourceNameSuffix();
        if (S.notEmpty(sfx) && !((String)suffixes.get(0)).equals(sfx)) {
            suffixes.remove(sfx);
            suffixes.add(0, sfx);
        }
        ArrayList<String> roots = new ArrayList<String>();
        String root0 = this.getResourceLoaderRoot().replace('\\', '/');
        roots.add(root0);
        if (null != callerClass.importPaths) {
            for (String s : callerClass.importPaths) {
                roots.add(root0 + "/" + s.replace('.', '/'));
            }
        }
        String tmplName0 = tmplName;
        String currentPath = callerClass.getKey().toString();
        int pos = currentPath.lastIndexOf("/");
        if (-1 != pos) {
            if ((currentPath = currentPath.substring(0, pos)).startsWith(root0)) {
                roots.add(currentPath);
            } else {
                if (currentPath.startsWith("/")) {
                    currentPath = currentPath.substring(1);
                }
                if (!currentPath.startsWith(root0)) {
                    currentPath = root0 + "/" + currentPath;
                }
                roots.add(currentPath);
            }
        }
        for (String root : roots) {
            tmplName = root + "/" + tmplName0;
            for (String suffix : suffixes) {
                String path = tmplName + suffix;
                ITemplateResource resource = this.load(path);
                if (null == resource || !resource.isValid()) continue;
                TemplateClass tc2 = engine.resourceManager().resourceLoaded(resource, false);
                return tc2;
            }
        }
        TemplateClass templateClass = tc = processTagName ? this.tryLoadTemplate(tagNameOrigin, engine, callerClass, false) : null;
        if (null == tc) {
            TemplateResourceManager.reportNonResource(tmplName);
        }
        return tc;
    }

    @Override
    public void scan(TemplateResourceManager manager) {
        logger.warn("Resource scan not supported by %s", this.getClass().getName());
    }
}

