/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.BlockCodeToken;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;

public class SectionParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.SECTION;
    }

    @Override
    public IParser create(IContext ctx) {
        return new RemoveLeadingLineBreakAndSpacesParser(ctx){

            @Override
            public Token go() {
                Regex r = SectionParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("bad @section statement. Correct usage: @section(\"mySection\"){...}", new Object[0]);
                }
                int curLine = this.ctx().currentLine();
                this.step(r.stringMatched().length());
                String s = r.stringMatched(1);
                s = S.stripBraceAndQuotation(s);
                return new SectionToken(s, this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "\\n?[ \\t\\x0B\\f]*%s%s\\s*((?@()))[\\s]*\\{?";
    }

    public class SectionToken
    extends BlockCodeToken {
        private String section;

        public SectionToken(String section, IContext context) {
            super(null, context);
            this.section = section;
        }

        @Override
        public void output() {
            this.p("\n__startSection(\"").p(this.section).p("\");\n");
        }

        @Override
        public String closeBlock() {
            return "\n__endSection();";
        }
    }
}

