/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import java.util.regex.Matcher;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.BlockCodeToken;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;

public class NoCompactParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.NOCOMPACT;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new RemoveLeadingLineBreakAndSpacesParser(ctx){

            @Override
            public Token go() {
                Matcher m = NoCompactParser.this.ptn(this.dialect()).matcher(this.remain());
                if (!m.matches()) {
                    return null;
                }
                String matched = m.group(1);
                this.step(matched.length());
                if (matched.startsWith("\n") || matched.endsWith("\n")) {
                    String blank;
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    Regex r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    String blank;
                    Regex r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                return new BlockCodeToken("", this.ctx()){

                    @Override
                    public void openBlock() {
                        this.ctx().getCodeBuilder().addBuilder(new Token("", this.ctx()){

                            @Override
                            protected void output() {
                                this.ctx().pushCompact(false);
                                super.output();
                            }
                        });
                    }

                    @Override
                    public String closeBlock() {
                        this.ctx().getCodeBuilder().addBuilder(new Token("", this.ctx()){

                            @Override
                            protected void output() {
                                this.ctx().popCompact();
                                super.output();
                            }
                        });
                        return "";
                    }
                };
            }
        };
    }

    @Override
    protected String patternStr() {
        return "(\\n?[ \\t\\x0B\\f]*%s%s\\s*\\(\\s*\\)[\\s]*\\{?[ \\t\\x0B\\f]*\\n?).*";
    }
}

