/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;

public class IncludeParser
extends KeywordParserFactory {
    private static final String R = "(^\\n?[ \\t\\x0B\\f]*%s(%s\\s*((?@()))\\s*))";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public Token go() {
                String blank;
                Regex r0;
                String matched;
                Regex r = IncludeParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("Error parsing @include statement. Correct usage: @include(\"foo.bar, a.b.c, ...\")", new Object[0]);
                }
                if ((matched = r.stringMatched()).startsWith("\n")) {
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                int lineNo = this.ctx().currentLine();
                this.step(matched.length());
                String s = r.stringMatched(3);
                if (S.isEmpty(s)) {
                    this.raiseParseException("Error parsing @include statement. Correct usage: @include(foo.bar, a.b.c, ...)", new Object[0]);
                }
                s = S.stripBraceAndQuotation(s);
                try {
                    String code = this.ctx().getCodeBuilder().addIncludes(s, lineNo);
                    if (matched.endsWith("\n")) {
                        code = code + ";p(\"\\n\");";
                    }
                    return new CodeToken(code, this.ctx());
                }
                catch (NoClassDefFoundError e) {
                    this.raiseParseException("error adding includes: " + e.getMessage() + "\n possible cause: lower/upper case issue on windows platform", new Object[0]);
                    return null;
                }
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.INCLUDE;
    }
}

