/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IKeyword;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.ExpressionParser;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;

public class I18nParser
extends KeywordParserFactory {
    @Override
    public IKeyword keyword() {
        return Keyword.I18N;
    }

    @Override
    protected String patternStr() {
        return "^((\\n?[ \\t\\x0B\\f]*)%s%s((?@())))";
    }

    protected static String innerPattern() {
        return "^((?@\"\")|(?@''))(\\s*,\\s*(.*))?";
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public Token go() {
                String remain = this.remain();
                Regex r = I18nParser.this.reg(this.dialect());
                if (!r.search(remain)) {
                    this.raiseParseException("Error parsing @i18n statement. Correct usage: @i18n(\"key\", ...)", new Object[0]);
                }
                String matched = r.stringMatched();
                this.step(matched.length());
                String space = r.stringMatched(2);
                ctx.getCodeBuilder().addBuilder(new Token.StringToken(space, ctx));
                String s = S.stripBrace(r.stringMatched(1).replace("@i18n", ""));
                r = new Regex(I18nParser.innerPattern());
                if (r.search(s)) {
                    String args = r.stringMatched(3);
                    if (S.empty(args)) {
                        String k = r.stringMatched(1);
                        s = "\"" + S.stripQuotation(k) + "\"";
                    } else {
                        String k = r.stringMatched(1);
                        s = "\"" + S.stripQuotation(k) + "\", " + args;
                    }
                }
                s = String.format("__i18n(%s)", s);
                s = ExpressionParser.processPositionPlaceHolder(s);
                return new CodeToken(s, this.ctx()){

                    @Override
                    public void output() {
                        this.p("p(").p(this.s).p(");");
                        this.pline();
                    }
                };
            }
        };
    }

    public static void main(String[] args) {
        String s = "'sss', 1324";
        Regex r = new Regex(String.format("^((?@\"\")|(?@''))(\\s*,\\s*(.*))?", "@", "i18n"));
        I18nParser.p(s, r);
    }
}

