/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.ParserBase;

public class CodeTypeBlockEndSensor
extends ParserBase {
    private static Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    public CodeTypeBlockEndSensor(IContext context) {
        super(context);
    }

    @Override
    public Token go() {
        Matcher m;
        IContext ctx = this.ctx();
        ICodeType curType = ctx.peekCodeType();
        if (curType.allowedExternalTypes().isEmpty()) {
            return null;
        }
        String remain = ctx.getRemain();
        String blockEnd = curType.blockEnd();
        if (null == blockEnd) {
            logger.warn("null block end found for type[%s]", curType);
            return null;
        }
        Pattern p = patterns.get(blockEnd);
        if (null == p) {
            p = Pattern.compile(blockEnd, 32);
            patterns.put(blockEnd, p);
        }
        if ((m = p.matcher(remain)).matches()) {
            String matched = m.group(1);
            ctx.step(matched.length());
            ctx.popCodeType();
            String s = String.format("p(\"%s\");__ctx.popCodeType();", matched, curType);
            return new CodeToken(s, ctx);
        }
        return null;
    }
}

