/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.internal.parser.build_in.IfThenToken;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;

public class BreakParser
extends KeywordParserFactory {
    private static final String R = "^(\\n?[ \\t\\x0B\\f]*%s%s\\s*((?@()))?[\\s;]*)";

    @Override
    protected String patternStr() {
        return R;
    }

    @Override
    public IParser create(IContext c) {
        return new RemoveLeadingLineBreakAndSpacesParser(c){

            @Override
            public Token go() {
                Regex r = BreakParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("Bad @break statement. Correct usage: @break()", new Object[0]);
                }
                String matched = r.stringMatched();
                String condition = r.stringMatched(2);
                if (null != condition) {
                    condition = S.stripBrace(condition);
                }
                this.step(matched.length());
                IContext.Break b = this.ctx().peekBreak();
                if (null == b) {
                    this.raiseParseException("Bad @break statement: No loop context", new Object[0]);
                }
                if (S.notEmpty(condition)) {
                    return new IfThenToken(condition, "break", this.ctx());
                }
                return new CodeToken(b.getStatement(), this.ctx());
            }
        };
    }

    @Override
    public Keyword keyword() {
        return Keyword.BREAK;
    }
}

