/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.compiler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.rythmengine.RythmEngine;
import org.rythmengine.utils.S;

public class ParamTypeInferencer {
    private static final ThreadLocal<Map<String, String>> typeMap = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    private static final ThreadLocal<String> uuid = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "";
        }
    };

    public static String typeTransform(String type) {
        if ((type = type.trim()).contains("Boolean") && type.matches("(.*[^a-zA-Z0-9_]+)?boolean([^a-zA-Z0-9_].*|$)")) {
            return type.replace("Boolean", "boolean");
        }
        if (type.contains("Integer") && type.matches("(.*[^a-zA-Z0-9_]+)?int([^a-zA-Z0-9_].*|$)")) {
            return type.replace("Integer", "int");
        }
        if (type.contains("Float") && type.matches("(.*[^a-zA-Z0-9_]+)?float([^a-zA-Z0-9_].*|$)")) {
            return type.replace("Float", "float");
        }
        if (type.contains("Double") && type.matches("(.*[^a-zA-Z0-9_]+)?double([^a-zA-Z0-9_].*|$)")) {
            return type.replace("Double", "double");
        }
        if (type.contains("Character") && type.matches("(.*[^a-zA-Z0-9_]+)?char([^a-zA-Z0-9_].*|$)")) {
            return type.replace("Character", "char");
        }
        if (type.contains("Long") && type.matches("(.*[^a-zA-Z0-9_]+)?long([^a-zA-Z0-9_].*|$)")) {
            return type.replace("Long", "long");
        }
        if (type.contains("Byte") && type.matches("(.*[^a-zA-Z0-9_]+)?byte([^a-zA-Z0-9_].*|$)")) {
            return type.replace("Byte", "byte");
        }
        return type;
    }

    private static String getTypeName(Object val) {
        String clsName;
        if (null == val) {
            clsName = "Object";
        } else {
            Collection col;
            Class<?> c = val.getClass();
            clsName = c.getName();
            if (clsName.contains("$")) {
                clsName = clsName.startsWith("java.") ? c.getSuperclass().getName() : clsName.replace('$', '.');
            }
            if (c.isArray()) {
                Class<?> cc = c.getComponentType();
                while (cc.isArray()) {
                    cc = cc.getComponentType();
                }
                String cName = cc.getName();
                String s = clsName;
                int d = 0;
                for (int i = 0; i < s.length() && s.charAt(i) == '['; ++i) {
                    ++d;
                }
                StringBuilder sb = new StringBuilder(cName);
                for (int i = 0; i < d; ++i) {
                    sb.append("[]");
                }
                clsName = sb.toString();
            } else if (val instanceof Collection && (col = (Collection)val).size() > 0) {
                if (val instanceof Map) {
                    Object k = ((Map)val).keySet().iterator().next();
                    Object v = ((Map)val).get(k);
                    String kType = ParamTypeInferencer.getTypeName(k);
                    String vType = null == v ? "Object" : ParamTypeInferencer.getTypeName(v);
                    clsName = clsName + "<" + kType + "," + vType + ">";
                } else {
                    Object e = col.iterator().next();
                    String eType = null == val ? "Object" : ParamTypeInferencer.getTypeName(e);
                    clsName = clsName + "<" + eType + ">";
                }
            }
        }
        return clsName;
    }

    public static void registerParams(RythmEngine engine, Object ... args) {
        if (!engine.conf().typeInferenceEnabled()) {
            return;
        }
        if (null == args || args.length == 0) {
            return;
        }
        Map<String, String> tMap = typeMap.get();
        tMap.clear();
        long id = 0L;
        if (args.length == 1 && args[0] instanceof Map) {
            Map params = (Map)args[0];
            for (String name : params.keySet()) {
                Object val = params.get(name);
                String typeName = ParamTypeInferencer.getTypeName(val);
                tMap.put(name, typeName);
                id += (long)(typeName.hashCode() * name.hashCode());
            }
        } else {
            for (int i = 0; i < args.length; ++i) {
                String name = "__v_" + (i + 1);
                String typeName = ParamTypeInferencer.getTypeName(args[i]);
                tMap.put(name, typeName);
                id += (long)((i + 1) * typeName.hashCode());
            }
        }
        if (id < 0L) {
            id = -1L * id;
        }
        uuid.set(String.valueOf(id));
    }

    public static String uuid() {
        return S.str(uuid.get());
    }

    public static Map<String, String> getTypeMap() {
        return typeMap.get();
    }
}

