/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal;

import java.util.regex.Pattern;

public interface IJavaExtension {
    public String extend(String var1, String var2);

    public Pattern pattern1();

    public Pattern pattern2();

    public String methodName();

    public static class ParameterExtension
    implements IJavaExtension {
        private String methodName = null;
        private String fullMethodName = null;
        private Pattern pattern1 = null;
        private Pattern pattern2 = null;
        private boolean requireTemplate = false;
        private boolean lastParam = false;

        public ParameterExtension(String waiveName, String name, String signature, String fullName) {
            this(waiveName, name, signature, fullName, false);
        }

        public ParameterExtension(String waiveName, String name, String signature, String fullName, boolean requireTemplate) {
            this(waiveName, name, signature, fullName, requireTemplate, false);
        }

        public ParameterExtension(String waiveName, String name, String signature, String fullName, boolean requireTemplate, boolean lastParam) {
            this.methodName = name;
            this.fullMethodName = fullName;
            this.pattern1 = Pattern.compile(String.format(".*(?<!%s)\\.%s\\s*\\((\\s*%s?\\s*)\\)\\s*$", waiveName, this.methodName, signature));
            this.pattern2 = Pattern.compile(String.format("\\.%s\\s*\\((\\s*%s?\\s*)\\)\\s*$", this.methodName, signature));
            this.requireTemplate = requireTemplate;
            this.lastParam = lastParam;
        }

        @Override
        public Pattern pattern1() {
            return this.pattern1;
        }

        @Override
        public Pattern pattern2() {
            return this.pattern2;
        }

        @Override
        public String extend(String s, String signature) {
            String ptn = "%s(%s, %s)";
            if (this.requireTemplate) {
                ptn = "%s(this, %s, %s)";
            }
            if (this.lastParam) {
                return String.format(ptn, this.fullMethodName, signature, s);
            }
            return String.format(ptn, this.fullMethodName, s, signature);
        }

        @Override
        public String methodName() {
            return this.methodName;
        }
    }

    public static class VoidParameterExtension
    implements IJavaExtension {
        private String methodName = null;
        private String fullMethodName = null;
        private Pattern pattern1 = null;
        private Pattern pattern2 = null;
        private boolean requireTemplate = false;

        public VoidParameterExtension(String waiveName, String name, String fullName) {
            this(waiveName, name, fullName, false);
        }

        public VoidParameterExtension(String waiveName, String name, String fullName, boolean requireTemplate) {
            this.methodName = name;
            this.fullMethodName = fullName;
            this.pattern1 = Pattern.compile(String.format(".*(?<!%s)\\.(?i)%s\\s*\\(\\s*\\)\\s*$", waiveName, this.methodName));
            this.pattern2 = Pattern.compile(String.format("\\.(?i)%s\\s*\\(\\s*\\)\\s*$", this.methodName));
            this.requireTemplate = requireTemplate;
        }

        @Override
        public Pattern pattern1() {
            return this.pattern1;
        }

        @Override
        public Pattern pattern2() {
            return this.pattern2;
        }

        @Override
        public String extend(String s, String signature) {
            String ptn = "%s(%s)";
            if (this.requireTemplate) {
                ptn = "%s(this, %s)";
            }
            return String.format(ptn, this.fullMethodName, s);
        }

        @Override
        public String methodName() {
            return this.methodName;
        }
    }
}

