/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.extension.IRenderExceptionHandler;
import org.rythmengine.extension.IRythmListener;
import org.rythmengine.extension.ISourceCodeEnhancer;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IEvent;
import org.rythmengine.internal.IEventDispatcher;
import org.rythmengine.internal.RythmEvents;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.TemplateResourceManager;
import org.rythmengine.template.ITag;
import org.rythmengine.template.ITemplate;
import org.rythmengine.template.TemplateBase;
import org.rythmengine.utils.F;

public class EventBus
implements IEventDispatcher {
    protected static final ILogger logger = Logger.get(EventBus.class);
    private final RythmEngine engine;
    private final ISourceCodeEnhancer sourceCodeEnhancer;
    private final IRenderExceptionHandler exceptionHandler;
    private final RythmListenerDispatcher renderListener = new RythmListenerDispatcher();
    private Map<IEvent<?, ?>, IEventHandler<?, ?>> dispatcher = new HashMap();

    public final void registerRenderListener(IRythmListener l) {
        this.renderListener.listeners.add(l);
    }

    public final void unregisterRenderListener(IRythmListener l) {
        this.renderListener.listeners.remove(l);
    }

    public EventBus(RythmEngine engine) {
        this.engine = engine;
        RythmConfiguration conf = engine.conf();
        this.sourceCodeEnhancer = (ISourceCodeEnhancer)conf.get(RythmConfigurationKey.CODEGEN_SOURCE_CODE_ENHANCER);
        this.exceptionHandler = (IRenderExceptionHandler)conf.get(RythmConfigurationKey.RENDER_EXCEPTION_HANDLER);
        IRythmListener l = (IRythmListener)conf.get(RythmConfigurationKey.RENDER_LISTENER);
        if (null != l) {
            this.registerRenderListener(l);
        }
        this.registerHandlers();
    }

    @Override
    public Object accept(IEvent event, Object param) {
        IEventHandler<?, ?> handler = this.dispatcher.get(event);
        if (null != handler) {
            return handler.handleEvent(this.engine, param);
        }
        return null;
    }

    private void registerHandlers() {
        Map<IEvent<?, ?>, IEventHandler<?, ?>> m = this.dispatcher;
        m.put(RythmEvents.ON_PARSE, new IEventHandler<String, CodeBuilder>(){

            @Override
            public String handleEvent(RythmEngine engine, CodeBuilder c) {
                String tmpl = c.template();
                tmpl = tmpl.replaceAll("(\\r\\n)", "\n");
                tmpl = tmpl.replaceAll("\\r", "\n");
                return tmpl;
            }
        });
        m.put(RythmEvents.PARSE_FAILED, new IEventHandler<Void, TemplateClass>(){

            @Override
            public Void handleEvent(RythmEngine engine, TemplateClass tc) {
                TemplateResourceManager.rollbackTmpBlackList();
                return null;
            }
        });
        m.put(RythmEvents.ON_BUILD_JAVA_SOURCE, new IEventHandler<Void, CodeBuilder>(){

            @Override
            public Void handleEvent(RythmEngine engine, CodeBuilder cb) {
                ISourceCodeEnhancer ce = EventBus.this.sourceCodeEnhancer;
                if (null == ce) {
                    return null;
                }
                if (cb.basicTemplate()) {
                    return null;
                }
                Map<String, ?> defArgs = ce.getRenderArgDescriptions();
                for (String name : defArgs.keySet()) {
                    Object o = defArgs.get(name);
                    String type = o instanceof Class ? ((Class)o).getName() : o.toString();
                    cb.addRenderArgs(-1, type, name);
                }
                for (String s : ce.imports()) {
                    cb.addImport(s, -1);
                }
                return null;
            }
        });
        m.put(RythmEvents.COMPILED, new IEventHandler<byte[], byte[]>(){

            @Override
            public byte[] handleEvent(RythmEngine engine, byte[] bytes) {
                TemplateResourceManager.commitTmpBlackList();
                return bytes;
            }
        });
        m.put(RythmEvents.COMPILE_FAILED, new IEventHandler<Void, TemplateClass>(){

            @Override
            public Void handleEvent(RythmEngine engine, TemplateClass tc) {
                TemplateResourceManager.rollbackTmpBlackList();
                return null;
            }
        });
        m.put(RythmEvents.ON_CLOSING_JAVA_CLASS, new IEventHandler<Void, CodeBuilder>(){

            @Override
            public Void handleEvent(RythmEngine engine, CodeBuilder cb) {
                ISourceCodeEnhancer ce = EventBus.this.sourceCodeEnhancer;
                if (null == ce) {
                    return null;
                }
                if (cb.basicTemplate()) {
                    return null;
                }
                cb.np(ce.sourceCode());
                cb.pn();
                return null;
            }
        });
        m.put(RythmEvents.ON_RENDER, new IEventHandler<Void, ITemplate>(){

            @Override
            public Void handleEvent(RythmEngine engine, ITemplate template) {
                ISourceCodeEnhancer ce = engine.conf().sourceEnhancer();
                if (null != ce) {
                    ce.setRenderArgs(template);
                }
                EventBus.this.renderListener.onRender(template);
                return null;
            }
        });
        m.put(RythmEvents.RENDERED, new IEventHandler<Void, ITemplate>(){

            @Override
            public Void handleEvent(RythmEngine engine, ITemplate template) {
                engine.renderSettings.clear();
                Rythm.RenderTime.clear();
                EventBus.this.renderListener.rendered(template);
                return null;
            }
        });
        m.put(RythmEvents.ON_TAG_INVOCATION, new IEventHandler<Void, F.T2<ITemplate, ITag>>(){

            @Override
            public Void handleEvent(RythmEngine engine, F.T2<ITemplate, ITag> param) {
                EventBus.this.renderListener.onInvoke((ITag)param._2);
                return null;
            }
        });
        m.put(RythmEvents.TAG_INVOKED, new IEventHandler<Void, F.T2<TemplateBase, ITag>>(){

            @Override
            public Void handleEvent(RythmEngine engine, F.T2<TemplateBase, ITag> param) {
                EventBus.this.renderListener.invoked((ITag)param._2);
                return null;
            }
        });
        m.put(RythmEvents.ENTER_INVOKE_TEMPLATE, new IEventHandler<Void, TemplateBase>(){

            @Override
            public Void handleEvent(RythmEngine engine, TemplateBase caller) {
                EventBus.this.renderListener.enterInvokeTemplate(caller);
                return null;
            }
        });
        m.put(RythmEvents.EXIT_INVOKE_TEMPLATE, new IEventHandler<Void, TemplateBase>(){

            @Override
            public Void handleEvent(RythmEngine engine, TemplateBase caller) {
                EventBus.this.renderListener.exitInvokeTemplate(caller);
                return null;
            }
        });
        m.put(RythmEvents.ON_RENDER_EXCEPTION, new IEventHandler<Boolean, F.T2<TemplateBase, Exception>>(){

            @Override
            public Boolean handleEvent(RythmEngine engine, F.T2<TemplateBase, Exception> param) {
                if (null == EventBus.this.exceptionHandler) {
                    return false;
                }
                return EventBus.this.exceptionHandler.handleTemplateExecutionException((Exception)param._2, (TemplateBase)param._1);
            }
        });
    }

    private static interface IEventHandler<RETURN, PARAM> {
        public RETURN handleEvent(RythmEngine var1, PARAM var2);
    }

    private static class RythmListenerDispatcher
    implements IRythmListener {
        private List<IRythmListener> listeners = new ArrayList<IRythmListener>();

        private RythmListenerDispatcher() {
        }

        @Override
        public void onRender(ITemplate template) {
            for (IRythmListener l : this.listeners) {
                try {
                    l.onRender(template);
                }
                catch (RuntimeException e) {
                    logger.warn(e, "Error executing onRender method on rythm listener: " + l.getClass(), new Object[0]);
                }
            }
        }

        @Override
        public void rendered(ITemplate template) {
            for (IRythmListener l : this.listeners) {
                try {
                    l.rendered(template);
                }
                catch (RuntimeException e) {
                    logger.warn(e, "Error executing rendered method on rythm listener: " + l.getClass(), new Object[0]);
                }
            }
        }

        @Override
        public void enterInvokeTemplate(TemplateBase caller) {
            for (IRythmListener l : this.listeners) {
                try {
                    l.enterInvokeTemplate(caller);
                }
                catch (RuntimeException e) {
                    logger.warn(e, "Error executing enterInvokeTemplate method on rythm listener: " + l.getClass(), new Object[0]);
                }
            }
        }

        @Override
        public void exitInvokeTemplate(TemplateBase caller) {
            for (IRythmListener l : this.listeners) {
                try {
                    l.exitInvokeTemplate(caller);
                }
                catch (RuntimeException e) {
                    logger.warn(e, "Error executing exitInvokeTemplate method on rythm listener: " + l.getClass(), new Object[0]);
                }
            }
        }

        @Override
        public void onInvoke(ITag tag) {
            for (IRythmListener l : this.listeners) {
                try {
                    l.onInvoke(tag);
                }
                catch (RuntimeException e) {
                    logger.warn(e, "Error executing onInvoke method on rythm listener: " + l.getClass(), new Object[0]);
                }
            }
        }

        @Override
        public void invoked(ITag tag) {
            for (IRythmListener l : this.listeners) {
                try {
                    l.invoked(tag);
                }
                catch (RuntimeException e) {
                    logger.warn(e, "Error executing invoked method on rythm listener: " + l.getClass(), new Object[0]);
                }
            }
        }
    }
}

