/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.conf;

import java.io.File;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.rythmengine.Rythm;
import org.rythmengine._Rythm;
import org.rythmengine.cache.CacheServiceFactory;
import org.rythmengine.cache.NoCacheService;
import org.rythmengine.exception.ConfigurationException;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.IDurationParser;
import org.rythmengine.extension.II18nMessageResolver;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.JDKLogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.sandbox.SandboxThreadFactory;
import org.rythmengine.utils.S;

public enum RythmConfigurationKey {
    BUILT_IN_CODE_TYPE_ENABLED("built_in.code_type.enabled", true),
    BUILT_IN_TRANSFORMER_ENABLED("built_in.transformer.enabled", true),
    CACHE_ENABLED("cache.enabled", false),
    CACHE_SERVICE_IMPL("cache.service.impl"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            Boolean cacheEnabled = (Boolean)CACHE_ENABLED.getConfiguration(configuration);
            if (!cacheEnabled.booleanValue()) {
                return NoCacheService.INSTANCE;
            }
            return CacheServiceFactory.INSTANCE.get();
        }
    }
    ,
    CACHE_DURATION_PARSER_IMPL("cache.duration_parser.impl", IDurationParser.DEFAULT_PARSER),
    CACHE_PROD_ONLY_ENABLED("cache.prod_only.enabled", true),
    CODEGEN_COMPACT_ENABLED("codegen.compact.enabled", true),
    CODEGEN_SOURCE_CODE_ENHANCER("codegen.source_code_enhancer.impl"),
    CODEGEN_BYTE_CODE_ENHANCER("codegen.byte_code_enhancer.impl"),
    DEFAULT_CODE_TYPE_IMPL("default.code_type.impl", ICodeType.DefImpl.RAW),
    DEFAULT_CACHE_TTL("default.cache_ttl"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String k = this.getKey();
            Object v = configuration.get(k);
            if (null == v) {
                return (T)Integer.valueOf(3600);
            }
            if (v instanceof Number) {
                return (T)v;
            }
            return (T)Integer.valueOf(v.toString());
        }
    }
    ,
    ENGINE_MODE("engine.mode"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String k = this.getKey();
            Object v = configuration.get(k);
            if (null == v) {
                return (T)((Object)Rythm.Mode.prod);
            }
            if (v instanceof Rythm.Mode) {
                return (T)v;
            }
            return (T)((Object)Rythm.Mode.valueOf(v.toString()));
        }
    }
    ,
    ENGINE_ID("engine.id"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            return "re-" + S.random(3);
        }
    }
    ,
    ENGINE_CLASS_LOADER_PARENT_IMPL("engine.class_loader.parent.impl"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (null == cl) {
                cl = Rythm.class.getClassLoader();
            }
            return cl;
        }
    }
    ,
    ENGINE_CLASS_LOADER_BYTE_CODE_HELPER_IMPL("engine.class_loader.byte_code_helper.impl"),
    ENGINE_LOAD_PRECOMPILED_ENABLED("engine.load_precompiled.enabled", false),
    ENGINE_FILE_WRITE_ENABLED("engine.file_write.enabled", true),
    ENGINE_GAE_ENABLED("engine.gae.enabled", false),
    ENGINE_PRECOMPILE_MODE("engine.precompile_mode.enabled"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String k = this.getKey();
            Object v = configuration.get(k);
            if (null == v) {
                return (T)Boolean.FALSE;
            }
            if (v instanceof Boolean) {
                return (T)v;
            }
            return (T)Boolean.valueOf(v.toString());
        }
    }
    ,
    ENGINE_OUTPUT_JAVA_SOURCE_ENABLED("engine.debug_java_source.enabled", false),
    ENGINE_PLAYFRAMEWORK("engine.playframework.enabled", false),
    ENGINE_PLUGIN_VERSION("engine.plugin.version", ""),
    FEATURE_TRANSFORM_ENABLED("feature.transform.enabled", true),
    FEATURE_TYPE_INFERENCE_ENABLED("feature.type_inference.enabled", false),
    FEATURE_SMART_ESCAPE_ENABLED("feature.smart_escape.enabled", true),
    FEATURE_NATURAL_TEMPLATE_ENABLED("feature.natural_template.enabled", false),
    HOME_TEMPLATE("home.template.dir"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            URL url = Thread.currentThread().getContextClassLoader().getResource("rythm");
            if (null != url) {
                return new File(url.getPath());
            }
            return new File("rythm");
        }

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            Object defVal = this.getDefVal(configuration);
            String key = this.getKey();
            Object o = RythmConfigurationKey.getValFromAliases(configuration, this.getKey(), "dir", defVal);
            ArrayList<File> fl = new ArrayList<File>();
            if (o instanceof File) {
                fl.add((File)o);
            } else if (o instanceof List) {
                for (Object el : (List)o) {
                    if (null == el) continue;
                    if (el instanceof File) {
                        fl.add((File)el);
                        continue;
                    }
                    fl.add(RythmConfigurationKey.asFile(el.toString(), key));
                }
            } else if (o.getClass().isArray()) {
                int len = Array.getLength(o);
                for (int i = 0; i < len; ++i) {
                    Object el = Array.get(o, i);
                    if (el instanceof File) {
                        fl.add((File)el);
                        continue;
                    }
                    fl.add(RythmConfigurationKey.asFile(el.toString(), key));
                }
            } else {
                String s = o.toString();
                for (String el : s.split("[,;]")) {
                    fl.add(RythmConfigurationKey.asFile(el.trim(), key));
                }
            }
            return (T)fl;
        }
    }
    ,
    HOME_TMP("home.tmp.dir"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            String tmp = System.getProperty("java.io.tmpdir");
            File f = new File(tmp, "__rythm");
            if (!f.exists() && !f.mkdirs()) {
                f = new File(tmp);
            }
            return f;
        }
    }
    ,
    HOME_PRECOMPILED("home.precompiled.dir"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            return null;
        }
    }
    ,
    I18N_LOCALE("i18n.locale"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            Locale retval;
            String k = this.getKey();
            Object o = configuration.get(k);
            if (o instanceof Locale) {
                return (T)o;
            }
            String s = S.str(o);
            if (S.empty(s)) {
                return (T)Locale.getDefault();
            }
            String[] sa = s.split("_");
            String lang = sa[0];
            if (sa.length > 1) {
                String region = sa[1];
                retval = new Locale(lang, region);
            } else {
                retval = new Locale(lang);
            }
            return (T)retval;
        }
    }
    ,
    I18N_MESSAGE_SOURCES("i18n.message.sources", "messages"),
    I18N_MESSAGE_RESOLVER("i18n.message.resolver.impl", II18nMessageResolver.DefaultImpl.INSTANCE),
    LOG_ENABLED("log.enabled", true),
    LOG_FACTORY_IMPL("log.factory.impl"){

        @Override
        protected Object getDefVal(Map<String, ?> configuration) {
            try {
                Class.forName("org.apache.commons.logging.Log");
                Class<?> logFactCls = Class.forName("org.rythmengine.logger.CommonsLoggerFactory");
                return logFactCls;
            }
            catch (Exception e) {
                return new JDKLogger.Factory();
            }
        }
    }
    ,
    LOG_SOURCE_JAVA_ENABLED("log.source.java.enabled", true),
    LOG_SOURCE_TEMPLATE_ENABLED("log.source.template.enabled", true),
    LOG_TIME_RENDER_ENABLED("log.time.render.enabled", false),
    RENDER_LISTENER("render.listener.impl"),
    RENDER_EXCEPTION_HANDLER("render.exception_handler.impl"),
    RESOURCE_LOADER_IMPLS("resource.loader.impls"),
    RESOURCE_DEF_LOADER_ENABLED("resource.loader.def.enabled", true),
    RESOURCE_NAME_SUFFIX("resource.name.suffix", ""){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String s = (String)super.getConfiguration(configuration);
            if (S.empty(s)) {
                return (T)"";
            }
            if (!s.startsWith(".")) {
                s = "." + s;
            }
            return (T)s;
        }
    }
    ,
    RESOURCE_AUTO_SCAN("resource.autoScan", false),
    SANDBOX_SECURITY_MANAGER_IMPL("sandbox.security_manager.impl"),
    SANDBOX_TIMEOUT("sandbox.timeout"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String k = this.getKey();
            Object v = configuration.get(k);
            if (null == v) {
                return (T)Integer.valueOf(2000);
            }
            if (v instanceof Number) {
                return (T)v;
            }
            return (T)Integer.valueOf(v.toString());
        }
    }
    ,
    SANDBOX_POOL_SIZE("sandbox.pool.size"){

        @Override
        public <T> T getConfiguration(Map<String, ?> configuration) {
            String k = this.getKey();
            Object v = configuration.get(k);
            if (null == v) {
                return (T)Integer.valueOf(10);
            }
            if (v instanceof Number) {
                return (T)v;
            }
            return (T)Integer.valueOf(v.toString());
        }
    }
    ,
    SANDBOX_RESTRICTED_CLASS("sandbox.restricted_class", ""),
    SANDBOX_ALLOWED_SYSTEM_PROPERTIES("sandbox.allowed_system_properties", "java.io.tmpdir,file.encoding,user.dir,line.separator,java.vm.name,java.protocol.handler.pkgs,suppressRawWhenUnchecked,user.language,user.region,user.timezone,user.country,java.home,sun.timezone.ids.oldmapping,file.separator,path.separator"),
    SANBOX_THREAD_FACTORY_IMPL("sandbox.thread_factory.impl", new SandboxThreadFactory()),
    SANDBOX_TEMP_IO_ENABLED("sandbox.tmp_dir.io.enabled", true),
    SANDBOX_SECURE_CODE("sandbox.secure_code", UUID.randomUUID().toString()),
    EXT_TRANSFORMER_IMPLS("ext.transformer.impls"),
    EXT_FORMATTER_IMPLS("ext.formatter.impls"),
    EXT_PROP_ACCESSOR_IMPLS("ext.prop_accessor.impls");

    private String key;
    private Object defVal;
    private static ILogger logger;
    private static Map<String, RythmConfigurationKey> lookup;

    private RythmConfigurationKey(String key) {
        this(key, (Object)null);
    }

    private RythmConfigurationKey(String key, Object defVal) {
        this.key = key;
        this.defVal = defVal;
    }

    public String getKey() {
        return this.key;
    }

    protected Object getDefVal(Map<String, ?> configuration) {
        return this.defVal;
    }

    public String toString() {
        return this.key;
    }

    private static List<String> aliases(String key, String suffix) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("rythm." + key);
        l.add(key);
        if (S.notEmpty(suffix)) {
            String k0 = key.replace("." + suffix, "");
            l.add("rythm." + k0);
            l.add(k0);
        }
        return l;
    }

    private static Object getValFromAliases(Map<String, ?> configuration, String key, String suffix, Object defVal) {
        Object v = configuration.get(key);
        if (null == v) {
            String k0;
            Iterator<String> i$ = RythmConfigurationKey.aliases(key, suffix).iterator();
            while (i$.hasNext() && null == (v = configuration.get(k0 = i$.next()))) {
            }
            if (null == v) {
                v = defVal;
            }
        }
        return v;
    }

    private static boolean toBoolean(Object v) {
        if (null == v) {
            return false;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return Boolean.parseBoolean(v.toString());
    }

    private static Boolean getEnabled(String key, Map<String, ?> configuration, Object defVal) {
        Object v = RythmConfigurationKey.getValFromAliases(configuration, key, "enabled", defVal);
        if (null == v) {
            v = RythmConfigurationKey.getValFromAliases(configuration, key, "disabled", defVal);
            return !RythmConfigurationKey.toBoolean(v);
        }
        return RythmConfigurationKey.toBoolean(v);
    }

    private static <T> T getImpl(String key, Map<String, ?> configuration, Object defVal) {
        Object v = RythmConfigurationKey.getValFromAliases(configuration, key, "impl", defVal);
        if (null == v) {
            return null;
        }
        if (v instanceof Class) {
            try {
                return ((Class)v).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException(e, "Error getting implementation configuration: %s", key);
            }
        }
        if (!(v instanceof String)) {
            return (T)v;
        }
        String clsName = (String)v;
        try {
            return (T)Class.forName(clsName).newInstance();
        }
        catch (Exception e) {
            try {
                Object o = _Rythm.eval(clsName);
                if (o instanceof Class) {
                    return ((Class)o).newInstance();
                }
                return (T)o;
            }
            catch (Exception e1) {
                throw new ConfigurationException(e, "Error getting implementation configuration: %s", key);
            }
        }
    }

    private static <T> T newInstance(String key, Class c, Class<T> expectedClass) {
        if (!expectedClass.isAssignableFrom(c)) {
            logger.warn("Mismatched type found for configuration %s", key);
            return null;
        }
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            logger.warn(e, "Cannot create new instance for configuration %s", key);
            return null;
        }
    }

    public static <T> List<T> getImplList(String key, Map<String, ?> configuration, Class<T> c) {
        Object v = RythmConfigurationKey.getValFromAliases(configuration, key, "impls", null);
        if (null == v) {
            return Collections.EMPTY_LIST;
        }
        boolean needClass = Class.class.isAssignableFrom(c);
        ArrayList<Object> l = new ArrayList<Object>();
        Class<?> vc = v.getClass();
        if (c.isAssignableFrom(vc)) {
            l.add(v);
            return l;
        }
        if (v instanceof Class) {
            if (needClass) {
                l.add(v);
            } else {
                T inst = RythmConfigurationKey.newInstance(key, (Class)v, c);
                if (null != inst) {
                    l.add(inst);
                }
            }
            return l;
        }
        if (vc.isArray()) {
            int len = Array.getLength(v);
            for (int i = 0; i < len; ++i) {
                T inst;
                Object el = Array.get(v, i);
                if (null == el) continue;
                Class<?> elc = el.getClass();
                if (c.isAssignableFrom(elc)) {
                    l.add(el);
                    continue;
                }
                if (el instanceof Class) {
                    if (needClass) {
                        l.add(el);
                        continue;
                    }
                    inst = RythmConfigurationKey.newInstance(key, (Class)el, c);
                    if (null == inst) continue;
                    l.add(inst);
                    continue;
                }
                try {
                    elc = Class.forName(el.toString());
                    if (needClass) {
                        l.add(elc);
                        continue;
                    }
                    inst = RythmConfigurationKey.newInstance(key, elc, c);
                    if (null == inst) continue;
                    l.add(inst);
                    continue;
                }
                catch (Exception e) {
                    logger.warn(e, "Error getting impl class out from %s for configuration %s", el, key);
                }
            }
            return l;
        }
        if (Collection.class.isAssignableFrom(vc)) {
            Collection col = (Collection)v;
            for (Object el : col) {
                T inst;
                if (null == el) continue;
                Class<?> elc = el.getClass();
                if (c.isAssignableFrom(elc)) {
                    l.add(el);
                    continue;
                }
                if (el instanceof Class) {
                    if (needClass) {
                        l.add(el);
                        continue;
                    }
                    inst = RythmConfigurationKey.newInstance(key, (Class)el, c);
                    if (null == inst) continue;
                    l.add(inst);
                    continue;
                }
                try {
                    elc = Class.forName(el.toString());
                    if (needClass) {
                        l.add(elc);
                        continue;
                    }
                    inst = RythmConfigurationKey.newInstance(key, elc, c);
                    if (null == inst) continue;
                    l.add(inst);
                }
                catch (Exception e) {
                    logger.warn(e, "Error getting impl class out from %s for configuration %s", el, key);
                }
            }
            return l;
        }
        for (String s : v.toString().split("[ \t,;]+")) {
            try {
                Class<?> ec = Class.forName(s);
                if (needClass) {
                    l.add(ec);
                    continue;
                }
                T inst = RythmConfigurationKey.newInstance(key, ec, c);
                if (null == inst) continue;
                l.add(inst);
            }
            catch (Exception e) {
                logger.warn(e, "Error getting impl class out from %s for configuration %s", s, key);
            }
        }
        return l;
    }

    private static File asFile(String s, String key) {
        boolean isAbsolute = false;
        if (s.startsWith("/") || s.startsWith(File.separator)) {
            isAbsolute = true;
        } else if (s.matches("^[a-zA-Z]:.*")) {
            isAbsolute = true;
        }
        if (isAbsolute) {
            return new File(s);
        }
        try {
            if (s.startsWith("..")) {
                URL url = Thread.currentThread().getContextClassLoader().getResource(".");
                String path = url.getPath();
                path = path.endsWith("/") ? path + s : path + "/" + s;
                return new File(path);
            }
            URL url = Thread.currentThread().getContextClassLoader().getResource(s);
            return new File(url.getPath());
        }
        catch (Exception e) {
            throw new ConfigurationException(e, "Error reading file configuration %s", key);
        }
    }

    private static File getFile(String key, Map<String, ?> configuration, Object defVal) {
        Object v = RythmConfigurationKey.getValFromAliases(configuration, key, "dir", defVal);
        if (null == v) {
            return null;
        }
        if (v instanceof File) {
            return (File)v;
        }
        String s = v.toString();
        return RythmConfigurationKey.asFile(s, key);
    }

    public <T> T getConfiguration(Map<String, ?> configuration) {
        String key = this.key;
        Object defVal = this.getDefVal(configuration);
        if (key.endsWith(".enabled")) {
            return (T)RythmConfigurationKey.getEnabled(key, configuration, defVal);
        }
        if (key.endsWith(".impl")) {
            return RythmConfigurationKey.getImpl(key, configuration, defVal);
        }
        if (key.endsWith(".dir")) {
            return (T)RythmConfigurationKey.getFile(key, configuration, defVal);
        }
        return (T)RythmConfigurationKey.getValFromAliases(configuration, key, null, defVal);
    }

    public <T> T getDefaultConfiguration() {
        return this.getConfiguration(Collections.emptyMap());
    }

    public static RythmConfigurationKey valueOfIgnoreCase(String s) {
        if (S.empty(s)) {
            throw new IllegalArgumentException();
        }
        return lookup.get(s.trim().toLowerCase());
    }

    static {
        logger = Logger.get(RythmConfigurationKey.class);
        lookup = new HashMap<String, RythmConfigurationKey>(50);
        for (RythmConfigurationKey k : RythmConfigurationKey.values()) {
            lookup.put(k.getKey().toLowerCase(), k);
        }
    }
}

