/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import org.rythmengine.RythmEngine;
import org.rythmengine.Sandbox;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.toString.ToStringOption;
import org.rythmengine.toString.ToStringStyle;
import org.rythmengine.utils.Escape;

public class Rythm {
    public static boolean debug = false;
    static RythmEngine engine = null;

    public static void init(Map<String, ?> conf) {
        if (null != engine) {
            throw new IllegalStateException("Rythm is already initialized");
        }
        engine = new RythmEngine(conf);
        engine.setShutdownListener(new RythmEngine.IShutdownListener(){

            @Override
            public void onShutdown() {
                engine = null;
            }
        });
    }

    public static void init(File file) {
        if (null != engine) {
            throw new IllegalStateException("Rythm is already initialized");
        }
        engine = new RythmEngine(file);
        engine.setShutdownListener(new RythmEngine.IShutdownListener(){

            @Override
            public void onShutdown() {
                engine = null;
            }
        });
    }

    public static void init() {
        Rythm.init((Map)null);
    }

    public static void init(RythmEngine engine) {
        if (null != Rythm.engine) {
            throw new IllegalStateException("Rythm is already initialized");
        }
        Rythm.engine = engine;
        engine.setShutdownListener(new RythmEngine.IShutdownListener(){

            @Override
            public void onShutdown() {
                engine = null;
            }
        });
    }

    private static void checkInit() {
        if (null == engine) {
            Rythm.init();
        }
    }

    public static RythmEngine engine() {
        Rythm.checkInit();
        return engine;
    }

    public static boolean insideSandbox() {
        return RythmEngine.insideSandbox();
    }

    public static Sandbox sandbox() {
        return Rythm.engine().sandbox();
    }

    public static Sandbox sandbox(Map<String, Object> userContext) {
        return Rythm.engine().sandbox(userContext);
    }

    public boolean isProdMode() {
        return Rythm.engine().isProdMode();
    }

    public final RythmEngine prepare(ICodeType codeType, Locale locale, Map<String, Object> usrCtx) {
        return Rythm.engine().prepare(codeType, locale, usrCtx);
    }

    public final RythmEngine prepare(ICodeType codeType) {
        return Rythm.engine().prepare(codeType);
    }

    public final RythmEngine prepare(Locale locale) {
        return Rythm.engine().prepare(locale);
    }

    public final RythmEngine prepare(Map<String, Object> userContext) {
        return Rythm.engine().prepare(userContext);
    }

    public static String render(String template, Object ... args) {
        return Rythm.engine().render(template, args);
    }

    public static String render(File file, Object ... args) {
        return Rythm.engine().render(file, args);
    }

    public static String substitute(String template, Object ... args) {
        return Rythm.engine().substitute(template, args);
    }

    public static String substitute(File template, Object ... args) {
        return Rythm.engine().substitute(template, args);
    }

    public static String toString(String template, Object obj) {
        return Rythm.engine().toString(template, obj);
    }

    public static String toString(Object obj) {
        return Rythm.engine().toString(obj);
    }

    public static String toString(Object obj, ToStringOption option, ToStringStyle style) {
        return Rythm.engine().toString(obj, option, style);
    }

    public static String commonsToString(Object obj, ToStringOption option, org.apache.commons.lang3.builder.ToStringStyle style) {
        return Rythm.engine().commonsToString(obj, option, style);
    }

    public static String renderStr(String template, Object ... args) {
        return Rythm.engine().renderString(template, args);
    }

    public static String renderString(String template, Object ... args) {
        return Rythm.engine().renderString(template, args);
    }

    public static String renderIfTemplateExists(String template, Object ... args) {
        return Rythm.engine().renderIfTemplateExists(template, args);
    }

    public static Object eval(String s) {
        return Rythm.engine().eval(s);
    }

    public static void shutdown() {
        if (null == engine) {
            return;
        }
        engine.shutdown();
        engine = null;
    }

    public static final class RenderTime {
        private static final ThreadLocal<Escape> escape_ = new ThreadLocal();
        private static final ThreadLocal<ICodeType> type_ = new ThreadLocal();

        public static void setEscape(Escape e) {
            escape_.set(e);
        }

        public static Escape getEscape() {
            Escape e = escape_.get();
            if (null == e) {
                ICodeType type = RenderTime.getCodeType();
                e = null == type ? Escape.XML : type.escape();
            }
            return e;
        }

        public static void setCodeType(ICodeType type) {
            type_.set(type);
        }

        public static ICodeType getCodeType() {
            return type_.get();
        }

        public static void clear() {
            escape_.remove();
            type_.remove();
        }
    }

    public static enum Mode {
        dev,
        prod;


        public boolean isDev() {
            return dev == this;
        }

        public boolean isProd() {
            return prod == this;
        }
    }
}

