/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.utils;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.extension.II18nMessageResolver;
import org.rythmengine.extension.Transformer;
import org.rythmengine.internal.CacheKey;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.template.ITemplate;
import org.rythmengine.utils.Escape;
import org.rythmengine.utils.F;
import org.rythmengine.utils.I18N;
import org.rythmengine.utils.Range;
import org.rythmengine.utils.RawData;

public class S {
    public static final S INSTANCE = new S();
    public static final String EMPTY_STR = "";
    private static final ILogger logger = Logger.get(S.class);
    public static final int IGNORECASE = 4096;
    public static final int IGNORESPACE = 8192;
    private static final Range<Integer> digits = F.R(48, 58);
    private static final Range<Integer> uppers = F.R(65, 91);
    private static final Range<Integer> lowers = F.R(97, 123);

    public static boolean isEmpty(String s) {
        return null == s || EMPTY_STR.equals(s.trim());
    }

    public static boolean empty(String s) {
        return null == s || EMPTY_STR.equals(s.trim());
    }

    public static boolean isNotEmpty(String s) {
        return !S.isEmpty(s);
    }

    public static boolean notEmpty(String s) {
        return !S.isEmpty(s);
    }

    public static boolean isEmpty(Object o) {
        return null == o || EMPTY_STR.equals(o.toString().trim());
    }

    public static boolean empty(Object o) {
        return null == o || EMPTY_STR.equals(S.str(o).trim());
    }

    public static boolean isNotEmpty(Object o) {
        return !S.isEmpty(o);
    }

    public static boolean notEmpty(Object o) {
        return !S.isEmpty(o);
    }

    public static boolean isEqual(String s1, String s2) {
        return S.isEqual(s1, s2, 0);
    }

    @Transformer
    public static boolean eq(String s1, String s2) {
        return S.isEqual(s1, s2, 0);
    }

    public static boolean isEqual(Object o1, Object o2) {
        return S.isEqual(S.str(o1), S.str(o2));
    }

    public static boolean eq(Object o1, Object o2) {
        return S.isEqual(S.str(o1), S.str(o2), 0);
    }

    public static boolean eq(String s1, String s2, int modifier) {
        return S.isEqual(s1, s2, modifier);
    }

    public static boolean isEqual(String s1, String s2, int modifier) {
        if (null == s1) {
            return s2 == null;
        }
        if (null == s2) {
            return false;
        }
        if ((modifier & 0x2000) != 0) {
            s1 = s1.trim();
            s2 = s2.trim();
        }
        if ((modifier & 0x1000) != 0) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public static String str(Object o) {
        return null == o ? EMPTY_STR : o.toString();
    }

    public static String toString(Object o) {
        return null == o ? EMPTY_STR : o.toString();
    }

    public static String removeAllLineBreaks(Object o) {
        String s = S.str(o);
        return s.replaceAll("[\n\r]+", " ");
    }

    @Transformer
    public static RawData raw(Object o) {
        return new RawData(o);
    }

    @Transformer(requireTemplate=true)
    public static RawData escape(Object o) {
        return S.escape(null, o);
    }

    public static RawData escape(ITemplate template, Object o) {
        if (S.empty(o)) {
            return RawData.NULL;
        }
        Escape escape = null != template ? template.__curEscape() : Escape.RAW;
        return escape.apply(o);
    }

    @Transformer
    public static RawData escape(Object o, Object escape) {
        if (S.isEmpty(o)) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        if (escape instanceof Escape) {
            return ((Escape)((Object)escape)).apply(o);
        }
        if (S.isEmpty(escape)) {
            return S.escape(o);
        }
        String se = escape.toString();
        if ("json".equalsIgnoreCase(se)) {
            return S.escapeJson(o);
        }
        if ("xml".equalsIgnoreCase(se)) {
            return S.escapeXml(o);
        }
        if ("javascript".equalsIgnoreCase(se) || "js".equalsIgnoreCase(se)) {
            return S.escapeJavaScript(o);
        }
        if ("csv".equalsIgnoreCase(se)) {
            return S.escapeCsv(o);
        }
        if ("html".equalsIgnoreCase(se)) {
            return S.escapeHtml(o);
        }
        if ("raw".equalsIgnoreCase(se)) {
            return S.raw(o);
        }
        throw new IllegalArgumentException("Unknown escape scheme: " + se);
    }

    @Transformer
    public static RawData escapeHTML(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return new RawData(StringEscapeUtils.escapeHtml4((String)o.toString()));
    }

    public static RawData escapeHtml(Object o) {
        return S.escapeHTML(o);
    }

    @Transformer
    public static RawData escapeCSV(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return new RawData(StringEscapeUtils.escapeCsv((String)o.toString()));
    }

    public static RawData escapeCsv(Object o) {
        return S.escapeCSV(o);
    }

    @Transformer
    public static RawData escapeJSON(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        String s0 = o.toString();
        s0 = s0.replace("\\", "\\\\").replaceAll("[\n\r]+", "\\\\\\n").replaceAll("[ \t]+", " ").replaceAll("\"", "\\\\\"");
        return new RawData(s0);
    }

    public static RawData escapeJson(Object o) {
        return S.escapeJSON(o);
    }

    @Transformer
    public static RawData escapeJavaScript(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return new RawData(StringEscapeUtils.escapeEcmaScript((String)o.toString()));
    }

    public static RawData escapeJavascript(Object o) {
        return S.escapeJavaScript(o);
    }

    @Transformer
    public static RawData escapeJS(Object o) {
        return S.escapeJavaScript(o);
    }

    public static RawData escapeJava(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return new RawData(StringEscapeUtils.escapeJava((String)o.toString()));
    }

    @Transformer
    public static RawData escapeXML(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return new RawData(StringEscapeUtils.escapeXml((String)o.toString()));
    }

    public static RawData escapeXml(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return new RawData(StringEscapeUtils.escapeXml((String)o.toString()));
    }

    public static RawData escapeRegex(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        String s = o.toString();
        return new RawData(s.replaceAll("([\\/\\*\\{\\}\\<\\>\\-\\\\\\!])", "\\\\$1"));
    }

    public static String strip(Object o, String prefix, String suffix) {
        if (null == o) {
            return EMPTY_STR;
        }
        String s = o.toString();
        if ((s = s.trim()).startsWith(prefix)) {
            s = s.substring(prefix.length());
        }
        if (s.endsWith(suffix)) {
            s = s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    public static String stripBrace(Object o) {
        return S.strip(o, "(", ")");
    }

    public static String stripQuotation(Object o) {
        return S.strip(S.strip(o, "\"", "\""), "'", "'");
    }

    public static String stripBraceAndQuotation(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        String s = S.stripBrace(o);
        s = S.stripQuotation(s);
        return s;
    }

    public static String shrinkSpace(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        return o.toString().replaceAll("[\r\n]+", "\n").replaceAll("[ \\t\\x0B\\f]+", " ");
    }

    public static boolean isDigitsOrAlphabetic(char c) {
        char i = c;
        return digits.include(Integer.valueOf(i)) || uppers.include(Integer.valueOf(i)) || lowers.include(Integer.valueOf(i));
    }

    @Transformer
    public static String capitalizeWords(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        String source = o.toString();
        char prevc = ' ';
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c != ' ' && !S.isDigitsOrAlphabetic(prevc)) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(c);
            }
            prevc = c;
        }
        return sb.toString();
    }

    @Transformer
    public static String noAccents(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        String string = o.toString();
        return Normalizer.normalize(string, Normalizer.Form.NFKC).replaceAll("[\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0101\u0105\u0103]", "a").replaceAll("[\u00e7\u0107\u010d\u0109\u010b]", "c").replaceAll("[\u010f\u0111\u00f0]", "d").replaceAll("[\u00e8\u00e9\u00ea\u00eb\u0113\u0119\u011b\u0115\u0117]", "e").replaceAll("[\u0192\u017f]", "f").replaceAll("[\u011d\u011f\u0121\u0123]", "g").replaceAll("[\u0125\u0127]", "h").replaceAll("[\u00ec\u00ed\u00ee\u00ef\u012b\u0129\u012d\u012f\u0131]", "i").replaceAll("[\u0133\u0135]", "j").replaceAll("[\u0137\u0138]", "k").replaceAll("[\u0142\u013e\u013a\u013c\u0140]", "l").replaceAll("[\u00f1\u0144\u0148\u0146\u0149\u014b]", "n").replaceAll("[\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u0151\u014f\u0153]", "o").replaceAll("[\u00de\u00fe]", "p").replaceAll("[\u0155\u0159\u0157]", "r").replaceAll("[\u015b\u0161\u015f\u015d\u0219]", "s").replaceAll("[\u0165\u0163\u0167\u021b]", "t").replaceAll("[\u00f9\u00fa\u00fb\u00fc\u016b\u016f\u0171\u016d\u0169\u0173]", "u").replaceAll("[\u0175]", "w").replaceAll("[\u00fd\u00ff\u0177]", "y").replaceAll("[\u017e\u017c\u017a]", "z").replaceAll("[\u00e6]", "ae").replaceAll("[\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u0100\u0104\u0102]", "A").replaceAll("[\u00c7\u0106\u010c\u0108\u010a]", "C").replaceAll("[\u010e\u0110\u00d0]", "D").replaceAll("[\u00c8\u00c9\u00ca\u00cb\u0112\u0118\u011a\u0114\u0116]", "E").replaceAll("[\u011c\u011e\u0120\u0122]", "G").replaceAll("[\u0124\u0126]", "H").replaceAll("[\u00cc\u00cd\u00ce\u00cf\u012a\u0128\u012c\u012e\u0130]", "I").replaceAll("[\u0134]", "J").replaceAll("[\u0136]", "K").replaceAll("[\u0141\u013d\u0139\u013b\u013f]", "L").replaceAll("[\u00d1\u0143\u0147\u0145\u014a]", "N").replaceAll("[\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u014c\u0150\u014e]", "O").replaceAll("[\u0154\u0158\u0156]", "R").replaceAll("[\u015a\u0160\u015e\u015c\u0218]", "S").replaceAll("[\u00d9\u00da\u00db\u00dc\u016a\u016e\u0170\u016c\u0168\u0172]", "U").replaceAll("[\u0174]", "W").replaceAll("[\u00dd\u0176\u0178]", "Y").replaceAll("[\u0179\u017d\u017b]", "Z").replaceAll("[\u00df]", "ss");
    }

    @Transformer
    public static String lowerFirst(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        String string = o.toString();
        if (string.length() == 0) {
            return string;
        }
        return (EMPTY_STR + string.charAt(0)).toLowerCase() + string.substring(1);
    }

    @Transformer
    public static String capFirst(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        String string = o.toString();
        if (string.length() == 0) {
            return string;
        }
        return (EMPTY_STR + string.charAt(0)).toUpperCase() + string.substring(1);
    }

    @Transformer
    public static String camelCase(Object obj) {
        if (null == obj) {
            return EMPTY_STR;
        }
        String string = obj.toString();
        StringBuilder result = new StringBuilder(string.length());
        String[] sa = string.split(" ");
        int l = sa.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            for (String s : sa[i].split("_")) {
                result.append(S.capFirst(s));
            }
        }
        return result.toString();
    }

    @Transformer
    public static RawData nl2br(RawData data) {
        return new RawData(data.toString().replace("\n", "<br/>"));
    }

    public static RawData nl2br(Object data) {
        return new RawData(StringEscapeUtils.escapeHtml4((String)S.str(data)).replace("\n", "<br/>"));
    }

    @Transformer
    public static String urlEncode(Object data) {
        if (null == data) {
            return EMPTY_STR;
        }
        String entity = data.toString();
        try {
            String encoding = "utf-8";
            return URLEncoder.encode(entity, encoding);
        }
        catch (UnsupportedEncodingException e) {
            Logger.error(e, entity, new Object[0]);
            return entity;
        }
    }

    public static String format(Number number) {
        return S.format(null, number, null, null);
    }

    public static String format(ITemplate template, Number number) {
        return S.format(template, number, null, null);
    }

    @Transformer(requireTemplate=true)
    public static String format(Number number, String pattern, Locale locale) {
        return S.format(null, number, pattern, locale);
    }

    public static String format(ITemplate template, Number number, String pattern, Locale locale) {
        NumberFormat nf;
        if (null == number) {
            number = 0;
        }
        if (null == locale) {
            locale = I18N.locale(template);
        }
        if (null == pattern) {
            nf = NumberFormat.getNumberInstance(locale);
        } else {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            nf = new DecimalFormat(pattern, symbols);
        }
        return nf.format(number);
    }

    @Transformer(requireTemplate=true)
    public static String format(Number number, String pattern) {
        return S.format(null, number, pattern, null);
    }

    public static String format(ITemplate template, Number number, String pattern) {
        return S.format(template, number, pattern, null);
    }

    @Transformer(requireTemplate=true)
    public static String format(Date date) {
        return S.format(date, null, null, null);
    }

    public static String format(ITemplate template, Date date) {
        return S.format(template, date, null, null, null);
    }

    @Transformer(requireTemplate=true)
    public static String format(Date date, String pattern) {
        return S.format(date, pattern, null, null);
    }

    public static String format(ITemplate template, Date date, String pattern) {
        return S.format(template, date, pattern, null, null);
    }

    @Transformer(requireTemplate=true)
    public static String format(Date date, String pattern, Locale locale) {
        return S.format(date, pattern, locale, null);
    }

    public static String format(ITemplate template, Date date, String pattern, Locale locale) {
        return S.format(template, date, pattern, locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String format(Date date, String pattern, Locale locale, String timezone) {
        return S.format(null, date, pattern, locale, timezone);
    }

    public static String format(ITemplate template, Date date, String pattern, Locale locale, String timezone) {
        if (null == date) {
            date = new Date(0L);
        }
        if (null == locale) {
            locale = I18N.locale(template);
        }
        DateFormat df = null != pattern ? new SimpleDateFormat(pattern, locale) : DateFormat.getDateInstance(2, locale);
        if (null != timezone) {
            df.setTimeZone(TimeZone.getTimeZone(timezone));
        }
        return df.format(date);
    }

    @Transformer
    public static String formatSize(Object data) {
        if (null == data) {
            throw new NullPointerException();
        }
        Long bytes = data instanceof Number ? (Long)data : Long.valueOf(data.toString());
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + "KB";
        }
        if (bytes < 0x40000000L) {
            return bytes / 0x100000L + "MB";
        }
        return bytes / 0x40000000L + "GB";
    }

    @Transformer(requireTemplate=true)
    public static String formatCurrency(Object data) {
        return S.formatCurrency(null, data, null, null);
    }

    public static String formatCurrency(ITemplate template, Object data) {
        return S.formatCurrency(template, data, null, null);
    }

    @Transformer(requireTemplate=true)
    public static String formatCurrency(Object data, String currencyCode) {
        return S.formatCurrency(null, data, currencyCode, null);
    }

    public static String formatCurrency(ITemplate template, Object data, String currencyCode) {
        return S.formatCurrency(template, data, currencyCode, null);
    }

    public static String formatCurrency(Object data, String currencyCode, Locale locale) {
        return S.formatCurrency(null, data, currencyCode, locale);
    }

    public static String formatCurrency(ITemplate template, Object data, String currencyCode, Locale locale) {
        if (null == data) {
            throw new NullPointerException();
        }
        Number number = data instanceof Number ? (Number)((Number)data) : (Number)Double.parseDouble(data.toString());
        if (null == locale) {
            locale = I18N.locale(template);
        }
        Currency currency = null == currencyCode ? Currency.getInstance(locale) : Currency.getInstance(currencyCode);
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(locale);
        numberFormat.setCurrency(currency);
        numberFormat.setMaximumFractionDigits(currency.getDefaultFractionDigits());
        String s = numberFormat.format(number);
        s = s.replace(currency.getCurrencyCode(), currency.getSymbol(locale));
        return s;
    }

    private static String getMessage(ITemplate template, ResourceBundle bundle, String key, Locale locale, Object ... args) {
        if (null == locale) {
            locale = I18N.locale(template);
        }
        String s = key;
        try {
            s = bundle.getString(key);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        int argLen = args.length;
        if (argLen > 0) {
            MessageFormat fmt = new MessageFormat(s, locale);
            Object[] argsResolved = new Object[argLen];
            for (int i = 0; i < argLen; ++i) {
                Object arg = args[i];
                if (arg instanceof String) {
                    arg = S.i18n(template, (String)arg, new Object[0]);
                }
                argsResolved[i] = arg;
            }
            return fmt.format(argsResolved);
        }
        return s;
    }

    public static String i18n(ITemplate template, String key, Object ... args) {
        Serializable cached;
        Object arg0;
        II18nMessageResolver resolver;
        if (null != template && null != (resolver = template.__engine().conf().i18nMessageResolver()) && II18nMessageResolver.DefaultImpl.INSTANCE != resolver) {
            return resolver.getMessage(template, key, args);
        }
        boolean useFormat = args.length > 0;
        Locale locale = null;
        if (useFormat && (arg0 = args[0]) instanceof Locale) {
            locale = (Locale)arg0;
            Object[] args0 = new Object[args.length - 1];
            System.arraycopy(args, 1, args0, 0, args.length - 1);
            args = args0;
            boolean bl = useFormat = args.length > 0;
        }
        if (null == locale) {
            locale = I18N.locale(template);
        }
        RythmEngine engine = null == template ? RythmEngine.get() : template.__engine();
        String cacheKey = null;
        if (null != template && null != locale && S.notEmpty(cached = engine.cached(cacheKey = CacheKey.i18nMsg(template, key, useFormat, locale), new Object[0]))) {
            return S.str(cached);
        }
        for (String msgSrc : RythmConfiguration.get().messageSources()) {
            String data;
            ResourceBundle bundle = I18N.bundle(template, msgSrc, locale);
            if (null == bundle || null == (data = S.getMessage(template, bundle, key, locale, args))) continue;
            if (null != engine) {
                engine.cache(cacheKey, (Object)data, -1, new Object[0]);
            }
            return data;
        }
        return key;
    }

    @Transformer(requireTemplate=true)
    public static String i18n(String key, Object ... args) {
        return S.i18n(null, key, args);
    }

    @Transformer(requireTemplate=true)
    public static String i18n(String key) {
        return S.i18n(null, key, new Object[0]);
    }

    public static String random(int len) {
        char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '$', '#', '^', '&', '_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '~', '!', '@'};
        int max = chars.length;
        Random r = new Random();
        StringBuffer sb = new StringBuffer(len);
        while (len-- > 0) {
            int i = r.nextInt(max);
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static String random() {
        return S.random(8);
    }

    @Transformer
    public static String join(Iterable itr) {
        return S.join(itr, ",");
    }

    @Transformer
    public static String join(Iterable itr, String sep) {
        StringBuilder sb = new StringBuilder();
        Iterator i = itr.iterator();
        if (!i.hasNext()) {
            return EMPTY_STR;
        }
        sb.append(i.next());
        while (i.hasNext()) {
            sb.append(sep);
            sb.append(i.next());
        }
        return sb.toString();
    }

    public static String join(Iterable itr, char sep) {
        return S.join(itr, String.valueOf(sep));
    }

    public static String join(Character[] a) {
        return S.join(a, ",");
    }

    public static String join(Character[] a, String sep) {
        int len = a.length;
        if (len == 0) {
            return EMPTY_STR;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(a[0]));
        for (int i = 1; i < len; ++i) {
            sb.append(sep).append(a[i]);
        }
        return sb.toString();
    }

    public static String join(Character[] a, char sep) {
        return S.join(a, String.valueOf(sep));
    }

    public static String join(Integer[] a) {
        return S.join(a, ",");
    }

    public static String join(Integer[] a, String sep) {
        int len = a.length;
        if (len == 0) {
            return EMPTY_STR;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(a[0]));
        for (int i = 1; i < len; ++i) {
            sb.append(sep).append(a[i]);
        }
        return sb.toString();
    }

    public static String join(Integer[] a, char sep) {
        return S.join(a, String.valueOf(sep));
    }

    public static String join(Long[] a) {
        return S.join(a, ",");
    }

    public static String join(Long[] a, String sep) {
        int len = a.length;
        if (len == 0) {
            return EMPTY_STR;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(a[0]));
        for (int i = 1; i < len; ++i) {
            sb.append(sep).append(a[i]);
        }
        return sb.toString();
    }

    public static String join(Long[] a, char sep) {
        return S.join(a, String.valueOf(sep));
    }

    public static String join(Float[] a) {
        return S.join(a, ",");
    }

    public static String join(Float[] a, String sep) {
        int len = a.length;
        if (len == 0) {
            return EMPTY_STR;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(a[0]));
        for (int i = 1; i < len; ++i) {
            sb.append(sep).append(a[i]);
        }
        return sb.toString();
    }

    public static String join(Float[] a, char sep) {
        return S.join(a, String.valueOf(sep));
    }

    public static String join(Double[] a) {
        return S.join(a, ",");
    }

    public static String join(Double[] a, String sep) {
        int len = a.length;
        if (len == 0) {
            return EMPTY_STR;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(a[0]));
        for (int i = 1; i < len; ++i) {
            sb.append(sep).append(a[i]);
        }
        return sb.toString();
    }

    public static String join(Double[] a, char sep) {
        return S.join(a, String.valueOf(sep));
    }
}

