/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;

public class IO {
    public static String readContentAsString(File file) {
        return IO.readContentAsString(file, "utf-8");
    }

    public static String readContentAsString(URL url, String encoding) {
        try {
            return IO.readContentAsString(url.openStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readContentAsString(URL url) {
        return IO.readContentAsString(url, "utf-8");
    }

    public static String readContentAsString(File file, String encoding) {
        try {
            return IO.readContentAsString(new FileInputStream(file), encoding);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readContentAsString(InputStream is) {
        return IO.readContentAsString(is, "utf-8");
    }

    public static String readContentAsString(InputStream is, String encoding) {
        try {
            String line;
            StringWriter result = new StringWriter();
            PrintWriter out = new PrintWriter(result);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));
            int lineNo = 0;
            while ((line = reader.readLine()) != null) {
                if (lineNo++ > 0) {
                    out.println();
                }
                out.print(line);
            }
            String string = result.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void writeContent(CharSequence content, File file) {
        IO.writeContent(content, file, "utf-8");
    }

    public static void writeContent(CharSequence content, File file, String encoding) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)os, encoding));
            printWriter.println(content);
            printWriter.flush();
            os.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void writeContent(CharSequence content, Writer writer) {
        try {
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println(content);
            printWriter.flush();
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

