/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.exception.FastRuntimeException;
import org.rythmengine.exception.RythmException;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.II18nMessageResolver;
import org.rythmengine.internal.IEvent;
import org.rythmengine.internal.RythmEvents;
import org.rythmengine.internal.TemplateBuilder;
import org.rythmengine.internal.compiler.ClassReloadException;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.template.ITag;
import org.rythmengine.template.ITemplate;
import org.rythmengine.utils.Escape;
import org.rythmengine.utils.F;
import org.rythmengine.utils.IO;
import org.rythmengine.utils.JSONWrapper;
import org.rythmengine.utils.Range;
import org.rythmengine.utils.RawData;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public abstract class TemplateBase
extends TemplateBuilder
implements ITemplate {
    protected static final ILogger __logger = Logger.get(TemplateBase.class);
    protected transient RythmEngine __engine = null;
    private transient TemplateClass __templateClass = null;
    private Writer w;
    private OutputStream os;
    protected Map<String, Object> __renderArgs = new HashMap<String, Object>();
    private String layoutContent = "";
    private Map<String, String> layoutSections = new HashMap<String, String>();
    private Map<String, Object> renderProperties = new HashMap<String, Object>();
    protected TemplateBase __parent = null;
    private StringBuilder tmpOut = null;
    private String section = null;
    private TextBuilder tmpCaller = null;
    private Writer w_ = null;
    private static final ThreadLocal<Boolean> cce_ = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private Map<String, Object> userCtx;
    protected ITemplate.__Context __ctx = new ITemplate.__Context();
    protected boolean __logTime = false;
    private II18nMessageResolver i18n = null;

    public void __setTemplateClass(TemplateClass templateClass) {
        this.__templateClass = templateClass;
    }

    public void __prepareRender(ICodeType type, Locale locale) {
        this.__ctx.init(this, type, locale);
        Class<?> c = this.getClass();
        Class<?> pc = c.getSuperclass();
        if (TemplateBase.class.isAssignableFrom(pc) && !Modifier.isAbstract(pc.getModifiers())) {
            try {
                TemplateClass ptc = this.__engine().classes().getByClassName(pc.getName());
                if (null == ptc) {
                    throw new RuntimeException("Cannot find template class for parent class: " + pc);
                }
                this.__parent = (TemplateBase)ptc.asTemplate();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (null != this.__parent) {
            this.__parent.__ctx.init(this.__parent, type, locale);
        }
    }

    protected S s() {
        return S.INSTANCE;
    }

    @Override
    public ITemplate __setWriter(Writer writer) {
        if (null == writer) {
            throw new NullPointerException();
        }
        if (null != this.os) {
            throw new IllegalStateException("Cannot set writer to template when outputstream is presented");
        }
        if (null != this.w) {
            throw new IllegalStateException("Cannot set writer to template when an writer is presented");
        }
        this.w = writer;
        return this;
    }

    @Override
    public ITemplate __setOutputStream(OutputStream os) {
        if (null == os) {
            throw new NullPointerException();
        }
        if (null != this.w) {
            throw new IllegalStateException("Cannot set output stream to template when writer is presented");
        }
        if (null != this.os) {
            throw new IllegalStateException("Cannot set output stream to template when an outputstream is presented");
        }
        this.os = os;
        return this;
    }

    @Override
    public RythmEngine __engine() {
        return null == this.__engine ? Rythm.engine() : this.__engine;
    }

    protected void __invokeTag(int line, String name) {
        this.__engine.invokeTemplate(line, name, this, null, null, null);
    }

    protected void __invokeTag(int line, String name, boolean ignoreNonExistsTag) {
        this.__engine.invokeTemplate(line, name, this, null, null, null, ignoreNonExistsTag);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params) {
        this.__engine.invokeTemplate(line, name, this, params, null, null);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params, boolean ignoreNonExistsTag) {
        this.__engine.invokeTemplate(line, name, this, params, null, null, ignoreNonExistsTag);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params, ITag.__Body body) {
        this.__engine.invokeTemplate(line, name, this, params, body, null);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params, ITag.__Body body, boolean ignoreNoExistsTag) {
        this.__engine.invokeTemplate(line, name, this, params, body, null, ignoreNoExistsTag);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params, ITag.__Body body, ITag.__Body context) {
        this.__engine.invokeTemplate(line, name, this, params, body, context);
    }

    protected void __invokeTag(int line, String name, ITag.__ParameterList params, ITag.__Body body, ITag.__Body context, boolean ignoreNonExistsTag) {
        this.__engine.invokeTemplate(line, name, this, params, body, context, ignoreNonExistsTag);
    }

    protected RawData __render(String template, Object ... args) {
        if (null == template) {
            return new RawData("");
        }
        return S.raw(this.__engine.sandbox().render(template, args));
    }

    protected RawData __render(String template) {
        if (null == template) {
            return new RawData("");
        }
        return S.raw(this.__engine.sandbox().render(template, this.__renderArgs));
    }

    protected final void __setLayoutContent(String body) {
        this.layoutContent = body;
    }

    private void __addLayoutSection(String name, String section) {
        if (this.layoutSections.containsKey(name)) {
            return;
        }
        this.layoutSections.put(name, section);
    }

    protected void __startSection(String name) {
        if (null == name) {
            throw new NullPointerException("section name cannot be null");
        }
        if (null != this.tmpOut) {
            throw new IllegalStateException("section cannot be nested");
        }
        this.tmpCaller = this.__caller;
        this.__caller = null;
        this.tmpOut = this.__buffer;
        this.__buffer = new StringBuilder();
        this.section = name;
    }

    protected void __endSection() {
        this.__endSection(false);
    }

    protected void __endSection(boolean def) {
        if (null == this.tmpOut && null == this.tmpCaller) {
            throw new IllegalStateException("section has not been started");
        }
        this.__addLayoutSection(this.section, this.__buffer.toString());
        this.__buffer = this.tmpOut;
        this.__caller = this.tmpCaller;
        this.tmpOut = null;
        this.tmpCaller = null;
    }

    protected void __pLayoutSection(String name) {
        this.p(this.layoutSections.get(name));
    }

    protected RawData __getSection(String name) {
        return S.raw(this.layoutSections.get(name));
    }

    protected RawData __getSection() {
        return S.raw(S.isEmpty(this.layoutContent) ? this.layoutSections.get("__CONTENT__") : this.layoutContent);
    }

    protected void __pLayoutContent() {
        this.p(this.__getSection());
    }

    private void addAllLayoutSections(Map<String, String> sections) {
        if (null != sections) {
            this.layoutSections.putAll(sections);
        }
    }

    private void addAllRenderProperties(Map<String, Object> properties) {
        if (null != properties) {
            this.renderProperties.putAll(properties);
        }
    }

    protected TemplateBase __internalClone() {
        try {
            return (TemplateBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public ITemplate __cloneMe(RythmEngine engine, ITemplate caller) {
        if (null == engine) {
            throw new NullPointerException();
        }
        TemplateBase tmpl = this.__internalClone();
        if (tmpl.__parent != null) {
            tmpl.__parent = (TemplateBase)tmpl.__parent.__cloneMe(engine, caller);
        }
        tmpl.__engine = engine;
        tmpl.__templateClass = this.__templateClass;
        tmpl.__ctx = new ITemplate.__Context(this.__ctx, tmpl);
        if (null != this.__buffer) {
            tmpl.__buffer = new StringBuilder();
        }
        tmpl.__renderArgs = new HashMap<String, Object>(this.__renderArgs.size());
        tmpl.layoutContent = "";
        tmpl.layoutSections = new HashMap<String, String>();
        tmpl.renderProperties = new HashMap<String, Object>();
        tmpl.section = null;
        tmpl.tmpCaller = null;
        tmpl.tmpOut = null;
        tmpl.__logTime = this.__logTime;
        tmpl.w = null;
        tmpl.os = null;
        if (null != caller) {
            tmpl.__caller = (TextBuilder)((Object)caller);
            HashMap<String, Object> callerRenderArgs = new HashMap<String, Object>(((TemplateBase)caller).__renderArgs);
            Map<String, Class> types = tmpl.__renderArgTypeMap();
            for (String s : callerRenderArgs.keySet()) {
                Class c;
                Object o;
                if (tmpl.__renderArgs.containsKey(s) || null == (o = callerRenderArgs.get(s)) || null != (c = types.get(s)) && !c.isAssignableFrom(o.getClass())) continue;
                tmpl.__setRenderArg(s, o);
            }
        }
        tmpl.__setUserContext(engine.renderSettings.userContext());
        return tmpl;
    }

    protected void __internalInit() {
        this.__loadExtendingArgs();
        this.__init();
    }

    protected void __setup() {
    }

    protected void __loadExtendingArgs() {
    }

    @Override
    public void __init() {
    }

    private boolean __logTime() {
        return __logger.isDebugEnabled() && (this.__logTime || this.__engine.conf().logRenderTime());
    }

    @Override
    public TemplateClass __getTemplateClass(boolean useCaller) {
        TemplateBase caller;
        TemplateClass tc = this.__templateClass;
        if (useCaller && null == tc && null != (caller = this.__caller())) {
            return caller.__getTemplateClass(true);
        }
        return tc;
    }

    @Override
    public final void render(OutputStream os) {
        this.__setOutputStream(os);
        this.render();
    }

    @Override
    public final void render(Writer w) {
        this.__setWriter(w);
        this.render();
    }

    protected void __triggerRenderEvent(IEvent<Void, ITemplate> event, RythmEngine engine) {
        event.trigger(engine, this);
    }

    @Override
    public final String render() {
        RythmEngine engine = this.__engine();
        RythmEngine.set(engine);
        try {
            long l = 0L;
            if (this.__logTime()) {
                l = System.currentTimeMillis();
            }
            this.__triggerRenderEvent(RythmEvents.ON_RENDER, engine);
            this.__setup();
            if (this.__logTime()) {
                __logger.debug("< preprocess [%s]: %sms", this.getClass().getName(), System.currentTimeMillis() - l);
                l = System.currentTimeMillis();
            }
            String s = this.__internalRender();
            this.__triggerRenderEvent(RythmEvents.RENDERED, engine);
            if (this.__logTime()) {
                __logger.debug("<<<<<<<<<<<< [%s] total render: %sms", this.getClass().getName(), System.currentTimeMillis() - l);
            }
            return s;
        }
        catch (ClassReloadException e) {
            if (__logger.isDebugEnabled()) {
                __logger.debug("Cannot hotswap class, try to restart engine...", new Object[0]);
            }
            engine.restart(e);
            return this.render();
        }
    }

    protected void __setOutput(String path) {
        try {
            this.w_ = new BufferedWriter(new FileWriter(path));
        }
        catch (Exception e) {
            throw new FastRuntimeException(e.getMessage());
        }
    }

    protected void __setOutput(File file) {
        try {
            this.w_ = new BufferedWriter(new FileWriter(file));
        }
        catch (Exception e) {
            throw new FastRuntimeException(e.getMessage());
        }
    }

    protected void __setOutput(OutputStream os) {
        this.w_ = new OutputStreamWriter(os);
    }

    protected void __setOutput(Writer w) {
        this.w_ = w;
    }

    protected void __internalBuild() {
        this.w_ = null;
        RythmEngine engine = this.__engine();
        try {
            long l = 0L;
            if (this.__logTime()) {
                l = System.currentTimeMillis();
            }
            this.__internalInit();
            this.build();
            if (this.__logTime()) {
                __logger.debug("<<<<<<<<<<<< [%s] build: %sms", this.getClass().getName(), System.currentTimeMillis() - l);
            }
        }
        catch (RythmException e) {
            throw e;
        }
        catch (Throwable e) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            String msg = null;
            for (StackTraceElement se : stackTrace) {
                TemplateClass tc;
                String cName = se.getClassName();
                if (!cName.contains("__R_T_C__")) continue;
                if (cName.indexOf("$") != -1) {
                    cName = cName.substring(0, cName.lastIndexOf("$"));
                }
                if (null == (tc = this.__engine.classes().getByClassName(cName))) continue;
                if (null == msg && S.isEmpty(msg = e.getMessage())) {
                    msg = "Rythm runtime exception caused by " + e.getClass().getName();
                }
                RythmException re = new RythmException(this.__engine, e, tc, se.getLineNumber(), -1, msg);
                int lineNo = re.templateLineNumber;
                String key = tc.getKey().toString();
                int i = key.indexOf(10);
                if (i == -1) {
                    i = key.indexOf(13);
                }
                if (i > -1) {
                    key = key.substring(0, i - 1) + "...";
                }
                if (key.length() > 80) {
                    key = key.substring(0, 80) + "...";
                }
                if (lineNo != -1) {
                    StackTraceElement[] newStack = new StackTraceElement[stackTrace.length + 1];
                    newStack[0] = new StackTraceElement(tc.name(), "", key, lineNo);
                    System.arraycopy(stackTrace, 0, newStack, 1, stackTrace.length);
                    re.setStackTrace(newStack);
                }
                throw re;
            }
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        if (null != this.w_) {
            try {
                IO.writeContent((CharSequence)this.toString(), this.w_);
                this.w_ = null;
            }
            catch (Exception e) {
                Logger.error(e, "failed to write template content to output destination", new Object[0]);
            }
        }
    }

    protected String __internalRender() {
        this.__internalBuild();
        if (null != this.__parent && this.__parent != this) {
            this.__parent.__setLayoutContent(this.toString());
            this.__parent.addAllLayoutSections(this.layoutSections);
            this.__parent.addAllRenderProperties(this.renderProperties);
            this.__parent.__setRenderArgs(this.__renderArgs);
            return this.__parent.render();
        }
        return this.toString();
    }

    @Override
    public TextBuilder build() {
        return this;
    }

    @Override
    public Map<String, Object> __getUserContext() {
        return null == this.userCtx ? Collections.EMPTY_MAP : this.userCtx;
    }

    @Override
    public ITemplate __setUserContext(Map<String, Object> context) {
        this.userCtx = context;
        return this;
    }

    protected Class[] __renderArgTypeArray() {
        return null;
    }

    protected String __renderArgName(int i) {
        return null;
    }

    protected Map<String, Class> __renderArgTypeMap() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public ITemplate __setRenderArgs(Map<String, Object> args) {
        this.__renderArgs.putAll(args);
        return this;
    }

    @Override
    public ITemplate __setRenderArg(JSONWrapper jsonData) {
        if (jsonData.isArray()) {
            this.setJSONArray(jsonData.getArray());
        } else {
            this.setJSONObject(jsonData.getObject());
        }
        return this;
    }

    private void setJSONArray(List<Object> jsonArray) {
        Class[] types = this.__renderArgTypeArray();
        int paraNo = jsonArray.size();
        if (types.length == 1 && types[0].equals(List.class)) {
            String vn;
            Map<String, Class> typeMap = this.__renderArgTypeMap();
            Class c = typeMap.get((vn = this.__renderArgName(0)) + "__0");
            if (null == c) {
                c = typeMap.get(vn);
            }
            List p = JSON.parseArray((String)jsonArray.toString(), (Class)c);
            this.__setRenderArg(vn, (Object)p);
        } else {
            for (int i = 0; i < types.length && i < paraNo; ++i) {
                Object o = jsonArray.get(i);
                Class c = types[i];
                Object p = o instanceof List ? JSON.parseArray((String)o.toString(), (Class)c) : JSON.parseObject((String)o.toString(), (Class)c);
                this.__setRenderArg(i, p);
            }
        }
    }

    private void setJSONObject(Map<String, Object> jsonObject) {
        Map<String, Class> types = this.__renderArgTypeMap();
        for (String nm : jsonObject.keySet()) {
            Object p;
            if (!types.containsKey(nm)) continue;
            Class c = types.get(nm);
            Object o = jsonObject.get(nm);
            if (o instanceof List) {
                Map<String, Class> typeMap = this.__renderArgTypeMap();
                Class c0 = typeMap.get(nm + "__0");
                boolean isArray = false;
                if (null == c0) {
                    isArray = true;
                    c0 = typeMap.get(nm);
                }
                if (isArray) {
                    JSONArray l = (JSONArray)o;
                    Class<?> c1 = c0.getComponentType();
                    int size = l.size();
                    Object a = Array.newInstance(c1, size);
                    for (int i = 0; i < size; ++i) {
                        Object el = l.get(i);
                        el = JSON.parseObject((String)el.toString(), c1);
                        Array.set(a, i, el);
                    }
                    p = a;
                } else {
                    p = JSON.parseArray((String)o.toString(), (Class)c0);
                }
            } else {
                String s = o.toString();
                p = String.class.equals((Object)c) ? s : JSON.parseObject((String)s, (Class)c);
            }
            this.__setRenderArg(nm, p);
        }
    }

    protected TemplateBase __setRenderArgs0(ITag.__ParameterList params) {
        for (int i = 0; i < params.size(); ++i) {
            ITag.__Parameter param = params.get(i);
            if (null != param.name) {
                this.__setRenderArg(param.name, param.value);
                continue;
            }
            this.__setRenderArg(i, param.value);
        }
        return this;
    }

    @Override
    public ITemplate __setRenderArgs(Object ... args) {
        return this;
    }

    @Override
    public ITemplate __setRenderArg(String name, Object arg) {
        this.__renderArgs.put(name, arg);
        return this;
    }

    protected final TemplateBase __set(String name, Object arg) {
        this.__setRenderArg(name, arg);
        return this;
    }

    protected final TemplateBase __caller() {
        return null == this.__caller ? null : (TemplateBase)this.__caller;
    }

    @Override
    public <T> T __getRenderArg(String name) {
        Object val = this.__renderArgs.get(name);
        return (T)(null != val ? val : (null != this.__caller ? this.caller().__getRenderArg(name) : null));
    }

    protected final <T> T __get(String name) {
        return this.__getRenderArg(name);
    }

    protected final <T> T __getAs(String name, Class<T> c) {
        T o = this.__getRenderArg(name);
        if (null == o) {
            return null;
        }
        return o;
    }

    protected final <T> T __getRenderProperty(String name, T def) {
        Object o = this.renderProperties.get(name);
        return (T)(null == o ? def : o);
    }

    protected final <T> T __getRenderProperty(String name) {
        return this.__getRenderProperty(name, null);
    }

    protected final <T> T __getRenderPropertyAs(String name, T def) {
        T o = this.__getRenderProperty(name, def);
        return null == o ? def : o;
    }

    protected final void __setRenderProperty(String name, Object val) {
        this.renderProperties.put(name, val);
    }

    protected final void __handleTemplateExecutionException(Exception e) {
        try {
            if (!RythmEvents.ON_RENDER_EXCEPTION.trigger(this.__engine(), F.T2(this, e)).booleanValue()) {
                throw e;
            }
        }
        catch (RuntimeException e0) {
            throw e0;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public ITemplate __setRenderArg(int position, Object arg) {
        return this;
    }

    @Override
    public ICodeType __curCodeType() {
        return this.__ctx.currentCodeType();
    }

    @Override
    public Locale __curLocale() {
        return this.__ctx.currentLocale();
    }

    @Override
    public Escape __curEscape() {
        return this.__ctx.currentEscape();
    }

    private boolean appendToBuffer() {
        return null != this.__parent || null == this.w && null == this.os;
    }

    private boolean appendToWriter() {
        return null == this.__parent && null != this.w;
    }

    private boolean appendToOutputStream() {
        return null == this.__parent && null != this.os;
    }

    @Override
    protected void __append(TextBuilder.StrBuf wrapper) {
        if (this.appendToBuffer()) {
            super.__append(wrapper);
            return;
        }
        if (this.appendToOutputStream()) {
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(wrapper.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(Object o) {
        String oStr = o.toString();
        if (this.appendToBuffer()) {
            super.__append(oStr);
        }
        TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(oStr);
        if (this.appendToOutputStream()) {
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(wrapper.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(char c) {
        if (this.appendToBuffer()) {
            super.__append(c);
        }
        if (this.appendToOutputStream()) {
            try {
                this.os.write(c);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(c);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(int i) {
        if (this.appendToBuffer()) {
            super.__append(i);
        }
        if (this.appendToOutputStream()) {
            TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(String.valueOf(i));
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(String.valueOf(i));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(long l) {
        if (this.appendToBuffer()) {
            super.__append(l);
        }
        if (this.appendToOutputStream()) {
            TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(String.valueOf(l));
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(String.valueOf(l));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(float f) {
        if (this.appendToBuffer()) {
            super.__append(f);
        }
        if (this.appendToOutputStream()) {
            TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(String.valueOf(f));
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(String.valueOf(f));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(double d) {
        if (this.appendToBuffer()) {
            super.__append(d);
        }
        if (this.appendToOutputStream()) {
            TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(String.valueOf(d));
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(String.valueOf(d));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void __append(boolean b) {
        if (this.appendToBuffer()) {
            super.__append(b);
        }
        if (this.appendToOutputStream()) {
            TextBuilder.StrBuf wrapper = new TextBuilder.StrBuf(String.valueOf(b));
            try {
                this.os.write(wrapper.toBinary());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appendToWriter()) {
            try {
                this.w.write(String.valueOf(b));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Escape __defaultEscape() {
        return this.__ctx.currentEscape();
    }

    @Override
    public final TemplateBase pe(Object o) {
        return (TemplateBase)super.pe(o);
    }

    @Override
    public final TemplateBase pe(Object o, Escape escape) {
        return (TemplateBase)super.pe(o, escape);
    }

    protected static void __log(String msg, Object ... args) {
        __logger.info(msg, args);
    }

    protected static void __debug(String msg, Object ... args) {
        __logger.debug(msg, args);
    }

    protected static void __info(String msg, Object ... args) {
        __logger.info(msg, args);
    }

    protected static void __warn(String msg, Object ... args) {
        __logger.error(msg, args);
    }

    protected static void __warn(Throwable t, String msg, Object ... args) {
        __logger.error(t, msg, args);
    }

    protected static void __error(String msg, Object ... args) {
        __logger.error(msg, args);
    }

    protected static void __error(Throwable t, String msg, Object ... args) {
        __logger.error(t, msg, args);
    }

    protected String __i18n(String key, Object ... args) {
        if (this.i18n == null) {
            this.i18n = this.__engine().conf().i18nMessageResolver();
        }
        return this.i18n.getMessage(this, key, args);
    }

    protected static class __Itr<T>
    implements Iterable<T> {
        private Object _o = null;
        private int _size = -1;
        private Iterator<T> iterator = null;
        private int cursor = 0;

        public __Itr(T[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return __Itr.this.cursor < __Itr.this._size;
                }

                @Override
                public T next() {
                    return ((Object[])__Itr.this._o)[__Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public __Itr(int[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return __Itr.this.cursor < __Itr.this._size;
                }

                @Override
                public T next() {
                    return ((int[])__Itr.this._o)[__Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public __Itr(long[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return __Itr.this.cursor < __Itr.this._size;
                }

                @Override
                public T next() {
                    return ((long[])__Itr.this._o)[__Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public __Itr(float[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return __Itr.this.cursor < __Itr.this._size;
                }

                @Override
                public T next() {
                    return Float.valueOf(((float[])__Itr.this._o)[__Itr.this.cursor++]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public __Itr(double[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return __Itr.this.cursor < __Itr.this._size;
                }

                @Override
                public T next() {
                    return ((double[])__Itr.this._o)[__Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public __Itr(short[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return __Itr.this.cursor < __Itr.this._size;
                }

                @Override
                public T next() {
                    return ((short[])__Itr.this._o)[__Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public __Itr(char[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return __Itr.this.cursor < __Itr.this._size;
                }

                @Override
                public T next() {
                    return Character.valueOf(((char[])__Itr.this._o)[__Itr.this.cursor++]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public __Itr(byte[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return __Itr.this.cursor < __Itr.this._size;
                }

                @Override
                public T next() {
                    return ((byte[])__Itr.this._o)[__Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public __Itr(boolean[] ta) {
            this._o = ta;
            this._size = ta.length;
            this.iterator = new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return __Itr.this.cursor < __Itr.this._size;
                }

                @Override
                public T next() {
                    return ((boolean[])__Itr.this._o)[__Itr.this.cursor++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public __Itr(Range range) {
            this._o = range;
            this._size = range.size();
            this.iterator = range.iterator();
        }

        public __Itr(Object obj) {
            if (null == obj) {
                throw new NullPointerException();
            }
            String s = obj.toString();
            if (S.isEmpty(s)) {
                this._o = "";
                this._size = 0;
                this.iterator = Collections.EMPTY_LIST.iterator();
                return;
            }
            ArrayList<String> seps = new ArrayList<String>();
            RythmEngine engine = RythmEngine.get();
            RythmConfiguration conf = engine.conf();
            if ("zh".equals(conf.locale().getLanguage())) {
                seps.addAll(Arrays.asList("\n,\u3001,\uff0c,\uff1b,\u3002,\uff1a".split(",")));
            } else {
                seps.add("\n");
            }
            seps.addAll(Arrays.asList(";^,^:^_^-".split("\\^")));
            for (String sep : seps) {
                if (!s.contains(sep)) continue;
                List<String> ls = Arrays.asList(s.split(sep));
                ArrayList<String> ls0 = new ArrayList<String>();
                for (String s0 : ls) {
                    ls0.add(s0.trim());
                }
                this._o = ls0;
                this._size = ls.size();
                this.iterator = ls0.iterator();
                break;
            }
            if (null == this._o) {
                ArrayList<String> ls = new ArrayList<String>();
                ls.add(s);
                this._size = 1;
                this.iterator = ls.iterator();
            }
        }

        public __Itr(Iterable<T> tc) {
            this._o = tc;
            if (tc instanceof Collection) {
                this._size = ((Collection)tc).size();
            } else {
                int i = 0;
                Iterator<T> itr = tc.iterator();
                while (itr.hasNext()) {
                    ++i;
                    itr.next();
                }
                this._size = i;
            }
            this.iterator = tc.iterator();
        }

        public int size() {
            return this._size;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterator;
        }
    }
}

