/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.sandbox;

import java.util.UUID;
import org.rythmengine.RythmEngine;
import org.rythmengine.internal.RythmThreadFactory;
import org.rythmengine.internal.compiler.TemplateClassLoader;
import org.rythmengine.sandbox.RythmSecurityManager;

public class SandboxThreadFactory
extends RythmThreadFactory {
    private SecurityManager sm;
    private String password = null;

    public SandboxThreadFactory(SecurityManager sm, String password, RythmEngine re) {
        super("rythm-executor");
        if (null == sm) {
            String pass = UUID.randomUUID().toString();
            sm = new RythmSecurityManager(System.getSecurityManager(), pass, re);
            this.password = pass;
        } else {
            this.password = password;
        }
        this.sm = sm;
    }

    @Override
    protected Thread newThread0(ThreadGroup g, Runnable r, String name, long stackSize) {
        return new SandboxThread(this, this.sm, g, r, name, stackSize);
    }

    static void shutdown() {
    }

    static class SandboxThread
    extends Thread {
        private SecurityManager sm;
        private SandboxThreadFactory fact;

        public SandboxThread(SandboxThreadFactory fact, SecurityManager sm, ThreadGroup group, Runnable target, String name, long stackSize) {
            super(group, target, name, stackSize);
            this.sm = sm;
            this.fact = fact;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean needsSetSM;
            SecurityManager osm = System.getSecurityManager();
            SecurityManager nsm = this.sm;
            boolean bl = needsSetSM = null == osm || !osm.getClass().equals(nsm.getClass());
            if (needsSetSM) {
                System.setSecurityManager(nsm);
            }
            TemplateClassLoader.setSandboxPassword(this.fact.password);
            try {
                super.run();
            }
            finally {
                if (needsSetSM) {
                    if (nsm instanceof RythmSecurityManager) {
                        RythmSecurityManager rsm = (RythmSecurityManager)nsm;
                        rsm.unlock(this.fact.password);
                        System.setSecurityManager(osm);
                        rsm.lock(this.fact.password);
                    } else {
                        System.setSecurityManager(osm);
                    }
                }
            }
        }
    }
}

