/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.sandbox;

import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Exchanger;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.rythmengine.RythmEngine;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.sandbox.SandboxThreadFactory;
import org.rythmengine.template.ITemplate;

public class SandboxExecutingService {
    private static ILogger logger = Logger.get(SandboxExecutingService.class);
    private ScheduledExecutorService scheduler = null;
    private long timeout = 1000L;
    private RythmEngine engine;

    public SandboxExecutingService(int poolSize, SandboxThreadFactory fact, long timeout, RythmEngine re) {
        this.scheduler = new ScheduledThreadPoolExecutor(poolSize, fact, new ThreadPoolExecutor.AbortPolicy());
        this.timeout = timeout;
        this.engine = re;
    }

    private Future<Object> exec(final Map<String, Object> userCtx, final ITemplate tmpl, final String template, final File file, final Object ... args) {
        return this.scheduler.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    SandboxExecutingService.this.engine.prepare(userCtx);
                    ITemplate t = tmpl;
                    if (null == t) {
                        if (null != template) {
                            t = SandboxExecutingService.this.engine.getTemplate(template, args);
                        } else if (null != file) {
                            t = SandboxExecutingService.this.engine.getTemplate(file, args);
                        } else {
                            throw new NullPointerException();
                        }
                    }
                    return t.render();
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
    }

    public String execute(Map<String, Object> context, File template, Object ... args) {
        if (null == template) {
            throw new NullPointerException();
        }
        Future<Object> f = null;
        try {
            f = this.exec(context, null, null, template, args);
            Object o = f.get(this.timeout, TimeUnit.MILLISECONDS);
            if (o instanceof RuntimeException) {
                throw (RuntimeException)o;
            }
            if (o instanceof Exchanger) {
                throw new RuntimeException((Exception)o);
            }
            return null == o ? "" : o.toString();
        }
        catch (RuntimeException e) {
            f.cancel(true);
            throw e;
        }
        catch (Exception e) {
            f.cancel(true);
            throw new RuntimeException(e);
        }
    }

    public String execute(Map<String, Object> context, String template, Object ... args) {
        if (null == template) {
            throw new NullPointerException();
        }
        Future<Object> f = null;
        try {
            f = this.exec(context, null, template, null, args);
            Object o = f.get(this.timeout, TimeUnit.MILLISECONDS);
            if (o instanceof RuntimeException) {
                throw (RuntimeException)o;
            }
            if (o instanceof Exchanger) {
                throw new RuntimeException((Exception)o);
            }
            return null == o ? "" : o.toString();
        }
        catch (RuntimeException e) {
            f.cancel(true);
            throw e;
        }
        catch (Exception e) {
            f.cancel(true);
            throw new RuntimeException(e);
        }
    }

    public Future<Object> executeAsync(ITemplate t) {
        final Future<Object> f = this.exec(null, t, null, null, null);
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                f.cancel(true);
            }
        }, this.timeout, TimeUnit.MILLISECONDS);
        return f;
    }

    public void shutdown() {
        SandboxThreadFactory.shutdown();
        this.scheduler.shutdownNow();
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }
}

