/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.sandbox;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.sandbox.Base64;
import org.rythmengine.sandbox.SandboxThreadFactory;

public class RythmSecurityManager
extends SecurityManager {
    private SecurityManager osm;
    private String code = null;
    private ThreadLocal<Boolean> released = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private RythmEngine engine = null;

    public static boolean isRythmThread() {
        return Thread.currentThread() instanceof SandboxThreadFactory.SandboxThread;
    }

    private RythmEngine engine() {
        return null == this.engine ? RythmEngine.get() : this.engine;
    }

    private String hash(String input) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            byte[] out = m.digest(input.getBytes());
            return new String(Base64.encode(out));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public RythmSecurityManager(SecurityManager sm, String password, RythmEngine re) {
        this.osm = sm;
        if (null == password) {
            throw new NullPointerException();
        }
        this.code = this.hash(password);
        this.engine = re;
    }

    public void setPassword(String password) {
        if (null != this.code) {
            throw new IllegalStateException("security code already intiailized");
        }
        this.code = this.hash(password);
    }

    public void unlock(String password) {
        if (!this.code.equals(this.hash(password))) {
            throw new SecurityException("password not match");
        }
        this.released.set(true);
    }

    public void lock(String password) {
        if (!this.code.equals(this.hash(password))) {
            throw new SecurityException("password not match");
        }
        this.released.set(false);
    }

    private void checkRythm() {
        if (!this.released.get().booleanValue() && RythmSecurityManager.isRythmThread()) {
            throw new SecurityException("Access to protected resource is restricted in Sandbox mode");
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (!(t instanceof SandboxThreadFactory.SandboxThread)) {
            this.checkRythm();
        }
        if (null != this.osm) {
            this.osm.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkAccess(g);
        }
    }

    @Override
    public void checkExit(int status) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkExit(status);
        }
    }

    @Override
    public void checkExec(String cmd) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkLink(lib);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkRead(fd);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkWrite(fd);
        }
    }

    @Override
    public void checkWrite(String file) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkDelete(file);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkConnect(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkAccept(host, port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkMulticast(maddr);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (key.startsWith("rythm.")) {
            key = key.substring(7);
        }
        if (null != RythmConfigurationKey.valueOfIgnoreCase(key)) {
            return;
        }
        RythmEngine e = this.engine();
        if (null == e) {
            return;
        }
        String s = e.conf().allowedSystemProperties();
        if (s.indexOf(key) > -1) {
            return;
        }
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkPropertyAccess(key);
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        this.checkRythm();
        if (null != this.osm) {
            return this.osm.checkTopLevelWindow(window);
        }
        return true;
    }

    @Override
    public void checkPrintJobAccess() {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkPrintJobAccess();
        }
    }

    public void checkSystemClipboardAccess() {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkSystemClipboardAccess();
        }
    }

    public void checkAwtEventQueueAccess() {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkAwtEventQueueAccess();
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (null != this.osm) {
            this.osm.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        if ("setSecurityManager".equals(perm.getName())) {
            this.checkRythm();
        }
        if (null != this.osm) {
            this.osm.checkPermission(perm);
        }
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        if (null != this.osm) {
            this.osm.checkMemberAccess(clazz, which);
        }
    }

    @Override
    public void checkSetFactory() {
        this.checkRythm();
        if (null != this.osm) {
            this.osm.checkSetFactory();
        }
    }
}

