/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.resource;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.internal.RythmThreadFactory;
import org.rythmengine.internal.compiler.ParamTypeInferencer;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.resource.ClasspathTemplateResource;
import org.rythmengine.resource.FileTemplateResource;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.StringTemplateResource;
import org.rythmengine.utils.S;

public class TemplateResourceManager {
    private RythmEngine engine;
    private Map<Object, ITemplateResource> cache = new HashMap<Object, ITemplateResource>();
    private ITemplateResourceLoader _resourceLoader = null;
    private boolean typeInference;
    private ScheduledExecutorService loadingService = new ScheduledThreadPoolExecutor(10, new ScannerThreadFactory());

    public TemplateResourceManager(RythmEngine engine) {
        this.engine = engine;
        this._resourceLoader = (ITemplateResourceLoader)engine.conf().get(RythmConfigurationKey.RESOURCE_LOADER_IMPL);
        this.typeInference = engine.conf().typeInferenceEnabled();
    }

    private ITemplateResource cache(ITemplateResource resource) {
        if (resource.isValid()) {
            this.cache.put(resource.getKey(), resource);
        }
        return resource;
    }

    public TemplateClass tryLoadTemplate(String tagName, TemplateClass tc) {
        if (null != this._resourceLoader) {
            return this._resourceLoader.tryLoadTemplate(tagName, this.engine, tc);
        }
        return FileTemplateResource.tryLoadTemplate(tagName, this.engine, tc);
    }

    public String getFullTagName(TemplateClass tc) {
        if (null != this._resourceLoader) {
            return this._resourceLoader.getFullName(tc, this.engine);
        }
        return FileTemplateResource.getFullTagName(tc, this.engine);
    }

    public ITemplateResource get(File file) {
        return this.cache(new FileTemplateResource(file, this.engine));
    }

    public ITemplateResource get(String str) {
        ITemplateResource resource = this.getResource(str);
        if (!resource.isValid()) {
            resource = new StringTemplateResource(str, this.engine);
        }
        return this.cache(resource);
    }

    public ITemplateResource getResource(String str) {
        ITemplateResource resource = this.cache.get(str);
        if (null != resource) {
            return resource;
        }
        if (null != this._resourceLoader) {
            resource = this._resourceLoader.load(str);
        }
        if (null != resource) {
            return resource;
        }
        resource = new FileTemplateResource(str, this.engine);
        if (!resource.isValid()) {
            resource = new ClasspathTemplateResource(str, this.engine);
        }
        return this.cache(resource);
    }

    public void resourceLoaded(ITemplateResource resource) {
        TemplateClass tc;
        if (!resource.isValid()) {
            return;
        }
        String key = S.str(resource.getKey());
        if (this.typeInference) {
            key = key + ParamTypeInferencer.uuid();
        }
        if (null == (tc = this.engine.classes().getByTemplate(key))) {
            tc = new TemplateClass(resource, this.engine);
        }
        tc.asTemplate();
    }

    public void scan(File home) {
        String path;
        String string = path = null == home ? null : home.getAbsolutePath();
        if (null != this._resourceLoader) {
            this._resourceLoader.scan(path, this);
        } else {
            this.scan_(home);
        }
    }

    private void scan_(File file) {
        if (file.isFile() && file.canRead()) {
            this.load_(file);
        } else {
            for (File f : file.listFiles()) {
                this.scan_(f);
            }
        }
    }

    private void load_(final File file) {
        this.loadingService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                FileTemplateResource resource = new FileTemplateResource(file, TemplateResourceManager.this.engine);
                TemplateResourceManager.this.resourceLoaded(resource);
                return null;
            }
        });
    }

    private static class ScannerThreadFactory
    extends RythmThreadFactory {
        private ScannerThreadFactory() {
            super("rythm-scanner");
        }
    }
}

